//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: pty.cc,v 1.10 1995/06/04 07:14:49 prb Exp $"); }
#include <Cvo/_Machine.h++>
#include <stdio.h>
#include <termios.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#if	defined(__NEED_SYSENT__)
#include <sysent.h>
#endif
#include <sys/stat.h>
#if	!defined(TCSANOW) || defined(cray) || defined(__NEED_SYS_IOCTL__)
#include <sys/ioctl.h>
#endif
#include <Cvo/util.h++>
#if defined(__NEED_OSFCN__)
#include <osfcn.h>
#endif
#if defined(__NEED_IOCTL_DEF__)
extern "C" int ioctl(int, unsigned long, char *);
#endif
#if defined(__USE_STREAMS__)
#include <sys/stropts.h>
#include <string.h>
#endif

#define _PATH_TTY       "/dev/tty"

#if !defined(cray)
int
GetPty(char *line)
{   CVO_ENTER
	int p;

#if defined(__USE_STREAMS__)
    	p = open("/dev/ptmx", O_RDWR);
    	if (p >= 0) {
	    grantpt(p);
	    unlockpt(p);
	    strcpy(line, ptsname(p));
	    CVO_RETURN(p)
    	}
    	perror("/dev/ptmx");
#else
	char c, *p1, *p2;
	int i;

	sprintf(line, "/dev/ptyXX");
	p1 = &line[8];
	p2 = &line[9];

	for (c = 'p'; c <= 's'; c++) {
		struct stat stb;

		*p1 = c;
		*p2 = '0';
		if (stat(line, &stb) < 0)
			break;
		for (i = 0; i < 16; i++) {
			*p2 = "0123456789abcdef"[i];
			p = open(line, 2);
			if (p > 0) {
				line[5] = 't';
				CVO_RETURN(p)
			}
		}
	}
#endif
	CVO_RETURN(-1)
}

void
GetPtySlave(char *line)
{   CVO_ENTER
	struct termios tio;
	int t = -1;
	int NFiles;

        if (NFiles = sysconf(_SC_OPEN_MAX) < 1)
		NFiles = 20;

#if defined(TIOCNOTTY)
	if ((t = open(_PATH_TTY, O_RDWR)) >= 0) {
		ioctl(t, TIOCNOTTY, (char *)0);
		close(t);
	}
#endif

	chown(line, getuid(), getgid());
	chmod(line, 0600);

	if ((t = open(line, O_RDWR|O_NOCTTY)) < 0) {
		perror(line);
		exit(1);
	}
#if	defined(__USE_STREAMS__)
	ioctl(t, I_PUSH, "ptem");
	ioctl(t, I_PUSH, "ldterm");
#endif

	signal(SIGHUP, SIG_IGN);
#if	defined(__HAVE_VHANGUP__)
	vhangup();
#endif
	signal(SIGHUP, SIG_DFL);

	if ((t = open(line, O_RDWR|O_NOCTTY)) < 0) {
		perror(line);
		exit(1);
	}

	tcgetattr(t, &tio);

	tio.c_cflag = CS8|CREAD;
	tio.c_lflag = ISIG|IEXTEN|ICANON|ECHO|ECHOE|ECHOK;
#if	defined(ECHOCTL)
	tio.c_lflag |= ECHOCTL;
#endif
#if	defined(ECHOKE)
	tio.c_lflag |= ECHOKE;
#endif
	tio.c_oflag = OPOST|ONLCR;
	tio.c_iflag = BRKINT|IGNPAR|ICRNL|IXON;
#if	defined(IMAXBEL)
	tio.c_iflag |= IMAXBEL;
#endif

	cfsetospeed(&tio, B9600);
	cfsetispeed(&tio, B9600);

	tcsetattr(t, TCSANOW, &tio);

	if (setsid() < 0) {
		perror("setsid");
		exit(1);
	}

#if	defined(TIOCSCTTY)
	ioctl(t, TIOCSCTTY, (char *)0);
#else
	close(open(line, O_RDWR));
#endif

	if (t != 0)
		dup2(t, 0);
	if (t != 1)
		dup2(t, 1);
	if (t != 2)
		dup2(t, 2);
	for (t = 3; t < NFiles; ++t)
		close(t);
	setgid(getgid());
	setuid(getuid());
    CVO_VOID_RETURN
}
#endif

#if defined(cray)
#include <errno.h>

int
GetPty(char *line)
{   CVO_ENTER
    int p;
    int npty;
    struct stat sb;
    char myline[32];

    long highpty;
#ifdef _SC_CRAY_NPTY
    if ((highpty = sysconf(_SC_CRAY_NPTY)) == -1)
#endif
	highpty = 128;


    for (npty = 0; npty <= highpty; npty++) {
	(void) sprintf(myline, "/dev/pty/%03d", npty);
	p = open(myline, 2);
	if (p < 0)
	    continue;
	(void) sprintf(line, "/dev/ttyp%03d", npty);
	//
	// Here are some shenanigans to make sure that there
	// are no listeners lurking on the line.
	//
	if (stat(line, &sb) < 0) {
	    (void) close(p);
	    continue;
	}
	if (sb.st_uid || sb.st_gid || sb.st_mode != 0600) {
	    chown(line, 0, 0);
	    chmod(line, 0600);
	    (void)close(p);
	    p = open(myline, 2);
	    if (p < 0)
		continue;
	}
	//
	// Now it should be safe...check for accessability.
	//
	if (access(line, 6) == 0)
	    CVO_RETURN(p)
	else {
	    // no tty side to pty so skip it
	    (void) close(p);
	}
    }
    CVO_RETURN(-1)
}

void
GetPtySlave(char *line)
{   CVO_ENTER
    struct termios tio;
    int t = -1;
    int NFiles;

    if (NFiles = sysconf(_SC_OPEN_MAX) < 1)
	    NFiles = 20;

#ifdef TIOCNOTTY
    if ((t = open(_PATH_TTY, O_RDWR)) >= 0) {
	    ioctl(t, TIOCNOTTY, (char *)0);
	    close(t);
    }
#endif

    chown(line, getuid(), getgid());
    chmod(line, 0600);

    if ((t = open(line, O_RDWR|O_NOCTTY)) < 0) {
	    perror(line);
	    exit(1);
    }

    signal(SIGHUP, SIG_IGN);
#if	defined(__HAVE_VHANGUP__)
    vhangup();
#endif
    signal(SIGHUP, SIG_DFL);

    if ((t = open(line, O_RDWR|O_NOCTTY)) < 0) {
	    perror(line);
	    exit(1);
    }

    tcgetattr(t, &tio);

    tio.c_cflag = CS8|CREAD;
    tio.c_lflag = ISIG|IEXTEN|ICANON|ECHO|ECHOE|ECHOK;
#if defined(ECHOCTL)
    tio.c_lflag |= ECHOCTL;
#endif
#if defined(ECHOKE)
    tio.c_lflag |= ECHOKE;
#endif
    tio.c_oflag = OPOST|ONLCR;
    tio.c_iflag = BRKINT|IGNPAR|ICRNL|IXON;
#if defined(IMAXBEL)
    tio.c_iflag |= IMAXBEL;
#endif

    cfsetospeed(&tio, B9600);
    cfsetispeed(&tio, B9600);

    tcsetattr(t, TCSANOW, &tio);

    if (setsid() < 0) {
	    perror("setsid");
	    exit(1);
    }

#if defined(TCSETCTTY) && !defined(TIOCSCTTY)
#define	TIOCSCTTY TCSETCTTY
#endif

#if defined(TIOCSCTTY)
    ioctl(t, TIOCSCTTY, (char *)0);
#endif

    if (t != 0)
	    dup2(t, 0);
    if (t != 1)
	    dup2(t, 1);
    if (t != 2)
	    dup2(t, 2);
    for (t = 3; t < NFiles; ++t)
	    close(t);
    setgid(getgid());
    setuid(getuid());
    CVO_VOID_RETURN
}
#endif
