//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: debug.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <stdio.h>
#include <stdarg.h>
#include <Cvo/Window.h++>

static unsigned long _cvo_debug_flags = 0;

#if	defined(DEBUG)
void
_cvo_debug(unsigned long type, char *message, ...)
{   CVO_ENTER
    if (!(type & _cvo_debug_flags))
	CVO_VOID_RETURN

    va_list ap;
    va_start(ap, message);

    fprintf(stderr, "Cvo-DBG: ");
    vfprintf(stderr, message, ap);
    va_end(ap);
    CVO_VOID_RETURN
}

void
_cvo_debug(unsigned long type, Cvo_Object * w, char *message, ...)
{   CVO_ENTER
    if (!(type & (_cvo_debug_flags|(w ? w->debug_flags : 0))))
	CVO_VOID_RETURN

    va_list ap;
    va_start(ap, message);

    fprintf(stderr, "Cvo-DBG: ");
    vfprintf(stderr, message, ap);
    va_end(ap);
    CVO_VOID_RETURN
}
#elif	defined(__GNUC__)
void _cvo_debug(unsigned long , char *, ...) { ; }
void _cvo_debug(unsigned long , Cvo_Object *, char *, ...) { ; }
#endif


void
_cvo_setdebug(unsigned long type, Cvo_Object *w)
{   CVO_ENTER
    if (w)
	w->debug_flags |= type;
    else
	_cvo_debug_flags |= type;
    CVO_VOID_RETURN
}
