//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: WindowViewPort.cc,v 1.7 1994/09/26 18:32:50 prb Exp $"); }
#include <Cvo/WindowViewPort.h++>

CONSTRUCTORS(Cvo_WindowViewPort, Cvo_ViewPort, "CvoWindowViewPort")
CONSTRUCTORS_1ARG(Cvo_WindowViewPortWindow, Cvo_Window,
		  "CvoWindowViewPortWindow", Cvo_WindowViewPort *)
CONSTRUCTORS_1ARG(Cvo_WindowViewPortClipFrame, Cvo_Frame,
		  "CvoWindowViewPortClipFrame", Cvo_WindowViewPort *)
CONSTRUCTORS_1ARG(Cvo_WindowViewPortPanner, Cvo_Frame, "CvoWindowViewPortPanner",
                  Cvo_WindowViewPort *)

static Cvo_Default defs[] = {
    "*CvoWindowViewPortWindow.Sunken: True",
    "*CvoWindowViewPortPannerWindow.Sunken: True",
    "*CvoWindowViewPort.BorderWidth: 0",
    "*CvoWindowViewPortPanner.BorderWidth: 0",
    "*CvoWindowViewPortWindow.horizontalLayoutPad: 0",
    "*CvoWindowViewPortWindow.verticalLayoutPad: 0",
    "*CvoWindowViewPortWindow.cursor: Fleur",
    "*CvoWindowViewPortClipFrame.borderWidth: 0",
    "*CvoWindowViewPortClipFrame.chamfer: 0",
};

void
Cvo_WindowViewPortClipFrame::_Init(Cvo_WindowViewPort *w)
{   CVO_ENTER
    DontLayoutChildren();
    wvp = w;
    CVO_VOID_RETURN
}

int
Cvo_WindowViewPortClipFrame::StandardComputeLayoutSize(int force)
{   CVO_ENTER
    int ret = SelfComputeLayoutSize(force);

    if (children) {
	Cvo_LayoutWindow *lw = children->ToLayoutWindow();
	Cvo_FrameLayout *lay = lw->Layout();

	lw->ComputeLayoutSize(force);
	if (!wvp->Horizontal()) {
	    layout.minimum.width = lay->minimum.width;
	    layout.desired.width = lay->desired.width;
	    layout.maximum.width = lay->maximum.width;
	}
	if (!wvp->Vertical()) {
	    layout.minimum.height = lay->minimum.height;
	    layout.desired.height = lay->desired.height;
	    layout.maximum.height = lay->maximum.height;
	}
    }
    CVO_RETURN(ret)
}

int
Cvo_WindowViewPortClipFrame::StandardLayoutFunction(int force, int, int, int)
{   CVO_ENTER
    if (force == -1)
	CVO_RETURN(CvoL_FOREWARD)

    if (width != parent->Width() || height != parent->Height()) {
	ForceResizeWindow(parent->Width(), parent->Height(), Cvo_LAYOUTTAG);
    }

    if (children && children->ToLayoutWindow()) {
	Cvo_WindowViewPortWindow *wvpw = (Cvo_WindowViewPortWindow *)Parent();
	Cvo_LayoutWindow *lw = children->ToLayoutWindow();
	Cvo_FrameLayout *lay = lw->Layout();

	int nw = lay->desired.width;
	int nh = lay->desired.height;
	if (!wvp->Horizontal()) {
	    nw = wvpw->Width();
	    lay->desired.width = nw;
	    lay->fillw = 1;
	} else
	    lay->fillw = 0;
	if (!wvp->Vertical()) {
	    nh = wvpw->Height();
	    lay->desired.height = nh;
	    lay->fillh = 1;
	} else
	    lay->fillh = 0;
	lw->LayoutFunction(1, 0, nw, nh);
    }

    CVO_RETURN(CvoL_FOREWARD)
}

void
Cvo_WindowViewPortWindow::_Init(Cvo_WindowViewPort *w)
{   CVO_ENTER
    clipframe = new Cvo_WindowViewPortClipFrame("viewPortClipFrame", this, w);
    clipframe->ExpandFrame();
    viewframe = 0;
    wvp = w;
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort::_Init()
{   CVO_ENTER
    type = CvoT_WindowViewPort;
    moving = False;
    synchronize = True;
    main = new Cvo_WindowViewPortWindow("viewPortWindow", upper, this);
    main->ExpandFrame();

    main->Register(CvoResizeEvent, &Cvo_WindowViewPort_Resize, this);
    Register(CvoMapRequestEvent, &Cvo_WindowViewPort_Mapped);
    if (GetResourceTruth(_Qpannable, _QPannable, True)) {
	main->Register(ButtonPress, &Cvo_WindowViewPort_Move, this);
	main->_AddSelectMask(ButtonMotionMask);
    }

    ResetFrame(new Cvo_Frame("viewPortFrame", ClipFrame()));
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort::ResetFrame(Cvo_Window *viewframe)
{   CVO_ENTER
    delete Frame();
    viewframe->DontPosition();

    ((Cvo_WindowViewPortWindow *)main)->SetFrame(viewframe);
    Frame()->Register(CvoResizeEvent, &Cvo_WindowViewPort_ViewResize, this);
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort::AddHorizontal()
{   CVO_ENTER
    if (!Horizontal()) {
        Cvo_ViewPort::AddHorizontal();
        Horizontal()->Register(CvoScrollBarEvent,
                     &Cvo_WindowViewPort_ScrollHorizontal, this);
        Horizontal()->SetMaximum(Frame()->Width());
        Horizontal()->SetVisible(ClipFrame()->Width());
    }
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort::AddVertical()
{   CVO_ENTER
    if (!Vertical()) {
        Cvo_ViewPort::AddVertical();
        Vertical()->Register(CvoScrollBarEvent,
                     &Cvo_WindowViewPort_ScrollVertical, this);
        Vertical()->SetMaximum(Frame()->Height());
        Vertical()->SetVisible(ClipFrame()->Height());
    }
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_ScrollHorizontal(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ScrollBarEvent *se = (Cvo_ScrollBarEvent *)ev;
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)data;

    if (wvp->moving)
	CVO_VOID_RETURN

    Cvo_WindowViewPortMoveEvent mvpme;

    wvp->Frame()->Origin(&mvpme.old_x, &mvpme.old_y);
    wvp->Frame()->ForceMoveWindow(-se->value, mvpme.old_y);
    wvp->Frame()->Origin(&mvpme.new_x, &mvpme.new_y);
    wvp->SendEvent(CvoWindowViewPortMoveEvent, &mvpme);

    if (wvp->Object()) {
	wvp->Frame()->Flush();
	if (wvp->synchronize)
	    XSync(wvp->Dpy(), False);
    }
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_ScrollVertical(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ScrollBarEvent *se = (Cvo_ScrollBarEvent *)ev;
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)data;

    if (wvp->moving)
	CVO_VOID_RETURN

    Cvo_WindowViewPortMoveEvent mvpme;

    wvp->Frame()->Origin(&mvpme.old_x, &mvpme.old_y);
    wvp->Frame()->ForceMoveWindow(mvpme.old_x, -se->value);
    wvp->Frame()->Origin(&mvpme.new_x, &mvpme.new_y);
    wvp->SendEvent(CvoWindowViewPortMoveEvent, &mvpme);

    if (wvp->Object()) {
	wvp->Frame()->Flush();
	if (wvp->synchronize)
	    XSync(wvp->Dpy(), False);
    }
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_Resize(Cvo_Object *obj, XEvent *, void *data)
{   CVO_ENTER
    Cvo_WindowViewPortWindow *wvpw = (Cvo_WindowViewPortWindow *)obj;
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)data;

    int mx = wvp->Horizontal() ? 0 : wvpw->Width();
    int my = wvp->Vertical() ? 0 : wvpw->Height();

    if (wvp->Vertical())
	wvp->Vertical()->SetVisible(wvpw->Height());
    if (wvp->Horizontal())
	wvp->Horizontal()->SetVisible(wvpw->Width());

    if (mx || my) {
	int nw = wvpw->viewframe->ToLayoutWindow()->Layout()->desired.width;
	int nh = wvpw->viewframe->ToLayoutWindow()->Layout()->desired.height;
	if (!wvp->Horizontal()) {
	    nw = wvpw->Width();
	    wvpw->viewframe->Layout()->desired.width = nw;
	    wvpw->viewframe->Layout()->fillw = 1;
	} else
	    wvpw->viewframe->Layout()->fillw = 0;
	if (!wvp->Vertical()) {
	    nh = wvpw->Height();
	    wvpw->viewframe->Layout()->desired.height = nh;
	    wvpw->viewframe->Layout()->fillh = 1;
	} else
	    wvpw->viewframe->Layout()->fillh = 0;
	wvpw->viewframe->LayoutFunction(1, 0, nw, nh);
    }
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_Mapped(Cvo_Object *obj, XEvent *, void *)
{   CVO_ENTER
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)obj;

    if (wvp->Vertical()) {
	wvp->Vertical()->SetVisible(wvp->ClipFrame()->Height());
    }
    if (wvp->Horizontal()) {
	wvp->Horizontal()->SetVisible(wvp->ClipFrame()->Width());
    }
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_ViewResize(Cvo_Object *obj, XEvent *, void *data)
{   CVO_ENTER
    Cvo_Frame *vf = (Cvo_Frame *)obj;
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)data;

    if (wvp->Vertical())
	wvp->Vertical()->SetMaximum(vf->Height());
    if (wvp->Horizontal())
	wvp->Horizontal()->SetMaximum(vf->Width());
    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_Move(Cvo_Object *obj, XEvent *bev, void *data)
{   CVO_ENTER
    Cvo_WindowViewPortWindow *wvpw = (Cvo_WindowViewPortWindow *)obj;
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)data;
    Cvo_Window *frm = wvp->Frame();

    if (frm->Width() <= wvpw->Width() &&
	frm->Height() <= wvpw->Height()) {
	    CVO_VOID_RETURN
    }

    int x, y;
    int ox, oy;

    int xoff, yoff;

    frm->XOrigin(&xoff, &yoff);

    xoff = -xoff;
    yoff = -yoff;
    if (bev->type == ButtonPress) {
	ox = bev->xbutton.x;
	oy = bev->xbutton.y;
    } else {
	frm->QueryMouseLocation(&ox, &oy);
    }

    wvp->moving = True;

    for (;;) {
        XEvent ev;

        XMaskEvent(frm->Dpy(),
                   ExposureMask |
                   PointerMotionHintMask |
                   ButtonMotionMask |
                   ButtonReleaseMask,
                   &ev);

        if (ev.type == ButtonRelease || ev.type == MotionNotify) {

	    if (ev.type == MotionNotify) {
		x = ev.xmotion.x;
		y = ev.xmotion.y;
	    } else {
		x = ev.xbutton.x;
		y = ev.xbutton.y;
	    }
	    wvpw->FromXCoord(&x, &y);

            if (frm->Width() > wvpw->Width()) {
                xoff += ox - x;
                if (xoff < 0)
                    xoff = 0;
                if (xoff + wvpw->Width() > frm->Width())
                    xoff = frm->Width() - wvpw->Width();
                ox = x;
            }
            if (frm->Height() > wvpw->Height()) {
                yoff += oy - y;
                if (yoff < 0)
                    yoff = 0;
                if (yoff + wvpw->Height() > frm->Height())
                    yoff = frm->Height() - wvpw->Height();
                oy = y;
            }

	    Cvo_WindowViewPortMoveEvent mvpme;

	    frm->Origin(&mvpme.old_x, &mvpme.old_y);
	    frm->ForceMoveWindow(-xoff, -yoff);
	    frm->Origin(&mvpme.new_x, &mvpme.new_y);

	    wvp->SendEvent(CvoWindowViewPortMoveEvent, &mvpme);

	    if (wvp->Vertical())
		wvp->Vertical()->SetCurrent(yoff);
	    if (wvp->Horizontal())
		wvp->Horizontal()->SetCurrent(xoff);

            if (ev.type == ButtonRelease) {
		wvp->moving = False;
                CVO_VOID_RETURN
	    }
        } else {
            _Cvo_event(&ev);
        }
    }
}

void
Cvo_WindowViewPortPannerExposureHandler(Cvo_Object*, XEvent*, void* d)
{ CVO_ENTER
    Cvo_WindowViewPortPanner* wvpp = (Cvo_WindowViewPortPanner*) d;
    wvpp->MakeDirty();
    wvpp->ReLayout(1);
    CVO_VOID_RETURN
}

Cvo_Quark _QfollowPanner	= "followPanner";
Cvo_Quark _QFollowPanner	= "FollowPanner";

void
Cvo_WindowViewPortPanner::_Init(Cvo_WindowViewPort* viewport)
{ CVO_ENTER
    follow = GetResourceInt(_QfollowPanner, _QFollowPanner, 0);

    DontLayoutChildren();
    DontComputeChildrenSize();

    vp = viewport;
    dirty = 1;
    holdstate = False;

    panner = new Cvo_Window("CvoWindowViewPortPannerWindow", this);

    vp->ClipFrame()->Register(CvoResizeEvent,
		 Cvo_WindowViewPortPanner_Resize, this)->AddDependent(this);
    vp->Frame()->Register(CvoResizeEvent,
		 Cvo_WindowViewPortPanner_Resize, this)->AddDependent(this);
    vp->Register(CvoWindowViewPortMoveEvent,
		 Cvo_WindowViewPortPanner_Move, this)->AddDependent(this);

    Register(CvoResizeEvent, Cvo_WindowViewPortPanner_Resize, this);
    panner->Register(Expose, Cvo_WindowViewPortPannerExposureHandler, this);
    Register(CvoMapRequestEvent, Cvo_WindowViewPortPanner_Resize, this);

    if (GetResourceTruth(_Qpannable, _QPannable, True)) {
	panner->Register(ButtonPress, Cvo_WindowViewPort_Panner, vp);
	panner->_AddSelectMask(ButtonMotionMask);
    }

    lineColor = Cvo_Color(this, GetResource(_QlineColor, _QColor, "Black"));
    CVO_VOID_RETURN
}

int
Cvo_WindowViewPortPanner::StandardLayoutFunction(int force, int, int w, int h)
{   CVO_ENTER
    if (force == -1) {
	CVO_RETURN(1)
    }

    if (width != w || height != h || layout.x != position.x
                                  || layout.y != position.y) {
	MoveResizeWindow(layout.x, layout.y, w, h, Cvo_LAYOUTTAG);
    }

    if (!panner->Object()) {
	CVO_RETURN(1)
    }
	    
    if (dirty) {
	panner->ClearWindow();
	Load_Pixmap();
    }
    
    Cvo_WindowViewPortWindow *wvpw = (Cvo_WindowViewPortWindow *)vp->main;
    Cvo_Window *frm = vp->Frame();
    int x_org, y_org;
    int x_ext, y_ext;
    int xoff, yoff;

    if (!Object()) {
	CVO_RETURN(1)
    }

    xoff = - xoffset;
    yoff = - yoffset;

    if (frm->Height() > wvpw->ClipFrame()->Height()) {
	y_org = (yoff * panner->Height()) / frm->Height();
	y_ext = (wvpw->ClipFrame()->Height() * panner->Height()) / frm->Height();
    } else {
	y_org = 0;
	y_ext = panner->Height() - 1;
    }
    
    if (frm->Width() > wvpw->ClipFrame()->Width()) {
	x_org = (xoff * panner->Width()) / frm->Width();
	x_ext = (wvpw->ClipFrame()->Width() * panner->Width()) / frm->Width();
    } else {
	x_org = 0;
	x_ext = panner->Width() - 1;
    }

    CARD32 xor_value = lineColor->Pixel()^panner->CurrentBackground()->Pixel();
    panner->SetForeground(xor_value);
    panner->SetFunction(GXxor);

    if (dirty) {
	dirty=0;
    } else {
	panner->DrawRectangle(prev_x_org, prev_y_org, prev_x_ext, prev_y_ext);
    }
    panner->DrawRectangle(x_org, y_org, x_ext, y_ext);
    panner->SetFunction(GXcopy);
    prev_x_org = x_org;
    prev_y_org = y_org;
    prev_x_ext = x_ext;
    prev_y_ext = y_ext;

    CVO_RETURN(1)
}

void
Cvo_WindowViewPortPanner_Move(Cvo_Object *, XEvent *, void *data)
{   CVO_ENTER
    Cvo_WindowViewPortPanner* wvpp = (Cvo_WindowViewPortPanner*)data;
    Cvo_Window *frm = wvpp->vp->Frame();

    frm->XOrigin(&wvpp->xoffset, &wvpp->yoffset);

    wvpp->ReLayout(1);

    CVO_VOID_RETURN
}

void
Cvo_WindowViewPortPanner_Resize(Cvo_Object *, XEvent *, void *data)
{   CVO_ENTER
    Cvo_WindowViewPortPanner* wvpp = (Cvo_WindowViewPortPanner*)data;
    Cvo_Window *frm = wvpp->vp->Frame();
    Cvo_Window* panfrm = wvpp->panner;
    int nw, nh;
    int x_winOrg, y_winOrg;
    int y_scale, x_scale;

    if (!wvpp->Object() || !frm->Object() || !panfrm->Object()) {
	CVO_VOID_RETURN
    }

    if (frm->Height() <= 0 || frm->Width() <= 0 ||
	wvpp->Height() <= 0 || wvpp->Width() <= 0) {
	CVO_VOID_RETURN
    }

    y_scale = (frm->Height() * MAGN) / wvpp->Height();
    x_scale = (frm->Width() * MAGN) / wvpp->Width();

    if (y_scale <= 0 || x_scale <=0) {
	CVO_VOID_RETURN
    }

    if (y_scale < MAGN || x_scale < MAGN){
	if (x_scale > y_scale) {
	    y_scale = y_scale * MAGN / x_scale;
	    x_scale = MAGN;
	} else {
	    x_scale = x_scale * MAGN / y_scale;
	    y_scale = MAGN;
	}
    }

    do {
	if (y_scale < x_scale) {
	    nh = (frm->Height() * MAGN) / x_scale;
	    nw = (frm->Width() * MAGN) / x_scale;
	    x_scale++;
	} else {
	    nh = (frm->Height() * MAGN) / y_scale;
	    nw = (frm->Width() * MAGN) / y_scale;
	    y_scale++;
	}
    } while (nh >= wvpp->Height() || nw >= wvpp->Width());
    y_winOrg = (wvpp->Height() - nh) / 2 + 1;
    x_winOrg = (wvpp->Width() - nw) / 2 + 1;

    nw -= 2*(panfrm->BorderWidth()+panfrm->HorizontalPad())+panfrm->Raise() + wvpp->HorizontalPad();
    nh -= 2*(panfrm->BorderWidth()+panfrm->VerticalPad())+panfrm->Raise() + wvpp->VerticalPad();
	
    if (nh <= 0)
	nh = 1;
    if (nw <= 0)
	nw = 1;

    //
    // Make sure the panner has been sized
    //
    if (panfrm->Width() != nw || panfrm->Height() != nh) {
	panfrm->_SetSize(nw, nh);
	panfrm->ForceResizeWindow(nw, nh);
    } 
    panfrm->ToXCoord(&x_winOrg, &y_winOrg);
    panfrm->MoveWindow(x_winOrg, y_winOrg);

    frm->XOrigin(&wvpp->xoffset, &wvpp->yoffset);

    Cvo_AnyEvent re;
    wvpp->SendEvent(CvoWindowViewPortPannerEvent, &re);

    CVO_VOID_RETURN
}

void
Cvo_WindowViewPort_Panner(Cvo_Object *obj, XEvent *bev, void *)
{   CVO_ENTER
    Cvo_Frame *panwin = (Cvo_Frame*)obj;
    Cvo_WindowViewPortPanner *wvpp =
	(Cvo_WindowViewPortPanner *)panwin->Parent();
    Cvo_WindowViewPort *wvp = (Cvo_WindowViewPort *)wvpp->vp;
    Cvo_WindowViewPortWindow *wvpw = (Cvo_WindowViewPortWindow *)wvp->main;
    Cvo_Window *frm = wvp->Frame();

    if ((frm->Width() <= wvpw->Width() &&
	frm->Height() <= wvpw->Height()) ||
	(frm->Height() <= panwin->Height() &&
	frm->Width() <= panwin->Width())) {
	    CVO_VOID_RETURN
    }

    int x, y;
    int ox, oy;
    unsigned int m;
    Window wt;

    int xoff, yoff;

    int x_scale, y_scale;

    if (frm->Height() > panwin->Height()) {
	y_scale = frm->Height()/panwin->Height();
    } else {
	y_scale = 1;
    }
    
    if (frm->Width() > panwin->Width()) {
	x_scale = frm->Width()/panwin->Width();
    } else {
	x_scale = 1;
    }

    frm->XOrigin(&xoff, &yoff);

    xoff = -xoff;
    yoff = -yoff;

    if (bev->type == ButtonPress) {
	ox = bev->xbutton.x;
	oy = bev->xbutton.y;
    } else {
	XQueryPointer(panwin->Dpy(), panwin->Object(), &wt, &wt,
		      &x, &y, &ox, &oy, &m);
    }

    wvp->moving = True;

    for (;;) {
        XEvent ev;

        XMaskEvent(panwin->Dpy(),
                   ExposureMask |
                   PointerMotionHintMask |
                   ButtonMotionMask |
                   ButtonReleaseMask,
                   &ev);

        if (ev.type == ButtonRelease || ev.type == MotionNotify) {

	    if (ev.type == MotionNotify) {
		x = ev.xmotion.x;
		y = ev.xmotion.y;
	    } else {
		x = ev.xbutton.x;
		y = ev.xbutton.y;
	    }
	    wvpw->FromXCoord(&x, &y);

            if (frm->Width() > wvpw->Width()) {
                xoff -= (ox - x)*x_scale;
                if (xoff < 0)
                    xoff = 0;
                if (xoff + wvpw->Width() > frm->Width())
                    xoff = frm->Width() - wvpw->Width();
                ox = x;
            }
            if (frm->Height() > wvpw->Height()) {
                yoff -= (oy - y)*y_scale;
                if (yoff < 0)
                    yoff = 0;
                if (yoff + wvpw->Height() > frm->Height())
                    yoff = frm->Height() - wvpw->Height();
                oy = y;
            }

	    wvpp->xoffset = -xoff;
	    wvpp->yoffset = -yoff;
	    wvpp->ReLayout(1);

	    if (wvpp->follow || ev.type == ButtonRelease) {
		frm->ForceMoveWindow(-xoff, -yoff);
		
		Cvo_AnyEvent re;
		wvp->SendEvent(CvoWindowViewPortMoveEvent, &re);

		if (wvp->Vertical())
		    wvp->Vertical()->SetCurrent(yoff);
		if (wvp->Horizontal())
		    wvp->Horizontal()->SetCurrent(xoff);
	    }

            if (ev.type == ButtonRelease) {
		wvp->moving = False;
                CVO_VOID_RETURN
	    }
        } else {
            _Cvo_event(&ev);
        }
    }
}
