//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Shell.cc,v 1.15 1995/06/04 07:14:49 prb Exp $"); }
#include <Cvo/Shell.h++>
#include <termios.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#if	!defined(TIOCSWINSZ) || defined(__NEED_SYS_IOCTL__)
#include <sys/ioctl.h>
#endif
#include <unistd.h>
#if defined(__NEED_IOCTL_DEF__)
extern "C" int ioctl(int, unsigned long, char *);
#endif
#if defined(__NEED_PUTENV_DEF__)
extern "C" int putenv(char *);
#endif

CONSTRUCTORS_2ARG(Cvo_Shell, Cvo_Text, "CvoShell", char *, char **)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Shell)

int GetPty(char *line);
void GetPtySlave(char *line);

static Cvo_Default defaults[] = {
    "*CvoShell*Sunken:True",
    "*CvoShell*Pad:2",
    "*CvoShell.Cursor:xterm",
    "*CvoShell*FontFamily:Courier",
    "*CvoShell*TabStop:8",
};

CVO_BEGIN_BIND(Cvo_Shell)
CVO_DOBIND(Cvo_Shell, "insert-selection", InsertSelection)
CVO_DOBIND(Cvo_Shell, "mit-mouse-hack",   SendMouse)
CVO_END_BIND(Cvo_Shell, Cvo_Text)

static char *trans = "\
    ~Ctrl <Btn2Up>:insert-selection(PRIMARY, CUT_BUFFER0) \n\
";

//   Ctrl <Btn2Down>:mit-mouse-hack()\n\


struct ShellArgs {
    char *program;
    char **argv;
};

void
Cvo_Shell::_Init(char *program, char **argv)
{   CVO_ENTER

    pid = -2;
    status = -1;
    ei = 0;
    
    ShellArgs *sa = new ShellArgs;
    int cnt = 0;
    int ac;

    cnt = strlen(program)+1;
    for (ac = 0; argv[ac]; ++ac)
	cnt += strlen(argv[ac]) + 1;

    sa->program = new char[cnt];
    sa->argv = new char *[ac+1];
    
    char *t = sa->program;
    char *f;

    f = program;
    while (*t++ = *f++)
	;

    for (ac = 0; argv[ac]; ++ac) {
	sa->argv[ac] = t;
	f = argv[ac];
	while (*t++ = *f++)
	    ;
    }
    sa->argv[ac] = 0;

    Raw();
    FixedWidth();
    ShowCursor();

    fd = GetPty(line);

    Register(CvoResizeEvent, &Cvo_Shell::NewSize, sa);
    AddTranslations(trans);
    CVO_VOID_RETURN
}

void
Cvo_Shell::NewSize(XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ResizeEvent *re = (Cvo_ResizeEvent *)ev;

    struct winsize ws;
    memset((char *)&ws, 0, sizeof(ws));
    int x;

    ws.ws_row = NLines();
    ws.ws_col = NCols();

    if (pid == -2) {
	ShellArgs *sa = (ShellArgs *)data;
	switch(pid = fork()) {
	case -1:
	    perror("fork");
	    Cvo_Exit(1);
	case 0:
	    GetPtySlave(line);
	    for (x = 3; x < Ev::nbrFds; ++x)
		close(x);
	    putenv("TERM=xterm");
	    if (ioctl(0, TIOCSWINSZ, (char *)&ws) < 0)
		perror("TIOCSWINSZ");
	    //
    	    // Silly AIX does not understand the truth about
	    // what "const" means.  This is pretty silly,
	    // but mostly harmless.
	    //
#if defined(__BROKEN_EXECVP__)
	    execvp((const char *)sa->program, (const char **)sa->argv);
#else
	    execvp(sa->program, sa->argv);
#endif
	    perror(sa->program);
	    exit(1);
	default:
	    delete [] sa->program;
	    delete [] sa->argv;
	    delete sa;
	    Register(CvoKeyTextEvent, &Cvo_Shell::KeyTextEvent);
	    ei = new EvInputEvent(fd, _Cvo_Shell_Input, this);
	    break;
	}
    } else
	ioctl(fd, TIOCSWINSZ, (char *)&ws);
    CVO_VOID_RETURN
}

Cvo_Shell::~Cvo_Shell()
{   CVO_ENTER
    delete ei;
    if (pid > 0)
	kill(pid, SIGHUP);
    CVO_DONE
}

void
Cvo_Shell::KeyTextEvent(XEvent *ev, void *)
{   CVO_ENTER
    Cvo_KeyTextEvent *kte = (Cvo_KeyTextEvent *)ev;

    if (kte->text && kte->text->mbLength() > 0)
	write(fd, kte->text->mbValue(), kte->text->mbLength());
    CVO_VOID_RETURN
}

void
Cvo_Shell::InsertSelection(XEvent *, int, char **)
{
    Cvo_CharacterBuffer cb;

    if (GetSelection(&cb))
	write(fd, cb.mbValue(), cb.mbLength());
}

void
_Cvo_Shell_Input(EvIOEvent *ei, void *d)
{   CVO_ENTER
    Cvo_Shell *shell = (Cvo_Shell *)d;

    char buf[256];
    int r;

    ei->Disable();
    if ((r = read(ei->Fd(), buf, sizeof(buf))) > 0) {
	shell->Write(buf, r);
	shell->Flush();
	ei->Enable();
    } else {
    	if (shell->status) {
	    shell->status = 0;
	    new EvTimerEvent(100, _Cvo_Shell_CheckStatus, shell, True);
    	}
	Cvo_ShellDoneEvent ev;
        ev.pid = shell->pid;
        shell->SendEvent(CvoShellDoneEvent, &ev);
    }
    CVO_VOID_RETURN
}

void
_Cvo_Shell_CheckStatus(EvTimerEvent *, void *vshell)
{
    Cvo_Shell *shell = (Cvo_Shell *)vshell;
    if (waitpid(shell->pid, &shell->status, 0) <= 0) {
	switch(errno) {
	case EINTR:
	    shell->status = 0;
	    new EvTimerEvent(100, _Cvo_Shell_CheckStatus, shell, True);
	    return;
	default:
	    shell->status = -1;
	    break;
    	}
    }
    shell->pid = 0;
    Cvo_ShellExitEvent ev;

    ev.status = shell->status;
    shell->SendEvent(CvoShellExitEvent, &ev);
}

int
Cvo_Shell::Wait()
{
    while (pid > 0) {
    	if (status) {
	    status = 0;
	    new EvTimerEvent(100, _Cvo_Shell_CheckStatus, this, True);
	}
    	Cvo_ScanInputs(False);
    }
    return(status);
}

void
Cvo_Shell::SendMouse(XEvent *ev, int, char **)
{   CVO_ENTER

    int x, y;
    FindCoordinates(ev, &x, &y);

    char buf[8];
    char *bp = buf;

    *bp++ = 'X' & 037;
    *bp++ = '_' & 037;
    *bp++ = '3';
    if (x >= 192) {
	*bp++ = 'B' & 037;
	x -= 192;
    } else if (x >= 96) {
	*bp++ = 'A' & 037;
	x -= 96;
    }
    *bp++ = ' ' + x;

    if (y >= 192) {
	*bp++ = 'B' & 037;
	y -= 192;
    } else if (y >= 96) {
	*bp++ = 'A' & 037;
	y -= 96;
    }
    *bp++ = ' ' + y;
    write(fd, buf, bp - buf);
}
