//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: ScrollBar.cc,v 1.16 1994/09/30 19:06:55 prb Exp $"); }
#include <stdio.h>
#include <Cvo/Window.h++>
#include <Cvo/ScrollBar.h++>
#include <string.h>
#include <unistd.h>
#if	defined(cray)
#include <time.h>
#endif
#if	defined(__NEED_BZERO_DEF__)
extern "C" int bzero(char *, unsigned int);
#endif

#define	ONESEC	1000000L

static Cvo_Default def[] = {
	"*CvoScrollBar.Cursor:SB Right Arrow",
	"*CvoScrollBar.up.Cursor:Based Arrow Up",
	"*CvoScrollBar.down.Cursor:Based Arrow Down",
	"*CvoScrollBar.left.Cursor:SB Left Arrow",
	"*CvoScrollBar.right.Cursor:SB Right Arrow",
	"*CvoScrollBar.vertThumb.Cursor:SB V Double Arrow",
	"*CvoScrollBar.horzThumb.Cursor:SB H Double Arrow",
	"*CvoScrollBar.Pad:0",
	"*CvoScrollBar.CvoAccessory.Chamfer:0",
	"*CvoScrollBar.CvoAccessory.Pad:0",
	"*CvoScrollBar.CvoAccessory.LayoutPad:0",
	"*CvoScrollBar.CvoThumb.LayoutPad:0",
	"*CvoScrollBar.CvoAccessory.InteralPad:0",
	"*CvoScrollBar.CvoThumb.InteralPad:0",
	"*CvoScrollBar.Sunken:True",
	"*CvoScrollBar.CvoAccessory.Sunken:True",
	"*CvoScrollBar.CvoAccessory.BorderWidth:0",
};

CVO_BEGIN_BIND(Cvo_ScrollBar)
CVO_DOBIND(Cvo_ScrollBar, "Move",	MoveTo)
CVO_DOBIND(Cvo_ScrollBar, "PageUp",	PageUp)
CVO_DOBIND(Cvo_ScrollBar, "PageDown",	PageDown)
CVO_DOBIND(Cvo_ScrollBar, "MotifMove",	MotifMove)
CVO_END_BIND(Cvo_ScrollBar, Cvo_SBBase)

CVO_BEGIN_BIND(Cvo_SBThumb) 
CVO_DOBIND(Cvo_SBThumb, "MoveThumb", Motion)
CVO_END_BIND(Cvo_SBThumb, Cvo_SBBase)

CVO_BEGIN_BIND(Cvo_SBAccessory) 
CVO_DOBIND(Cvo_SBAccessory, "Scroll", Down)
CVO_END_BIND(Cvo_SBAccessory, Cvo_SBBase)

static char *thumbtrans = "\
 	<ButtonPress>: MoveThumb()\n\
";

static char *accessorytrans = "\
 	<ButtonPress>: Scroll(1)\n\
";

static char *scrolltrans = "\
 	<Button1Press>: MotifMove()\n\
 	<Button2Press>: Move()\n\
";

CONSTRUCTORS(Cvo_SBBase, Cvo_Window, "CvoScrollBar")
CONSTRUCTORS_1ARG(Cvo_ScrollBar, Cvo_SBBase, "CvoScrollBar", int)
CONSTRUCTORS_1ARG(Cvo_SBAccessory, Cvo_SBBase, "CvoAccessory", int)
CONSTRUCTORS(Cvo_SBThumb, Cvo_SBBase, "CvoThumb")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_SBAccessory)

Cvo_ScrollBar::~Cvo_ScrollBar()
{   CVO_ENTER
    delete up;
    delete down;
    delete thumb;
    CVO_DONE
}

void
Cvo_ScrollBar::_Init(int orientation)
{   CVO_ENTER
    type = CvoT_ScrollBar;

    horiz = orientation == Cvo_HORIZONTAL;
    layout.internalPad = 0;
    layout.horizontalPad = 0;
    layout.verticalPad = 0;
    horizontalPad = chamfer + moat + moatChamfer + moatEdge;
    verticalPad = chamfer + moat + moatChamfer + moatEdge;
    scrolling = False;
    compress = False;
    scrolled = False;

    if (!horiz)
        VerticalChildren();

    up    = new Cvo_SBAccessory(horiz ? "right" : "up", this,
			        horiz ? Cvo_EAST : Cvo_NORTH);

    down  = new Cvo_SBAccessory(horiz ? "left" : "down", this,
			        horiz ? Cvo_WEST : Cvo_SOUTH);

    thumb = new Cvo_SBThumb(horiz ? "horzThumb" : "vertThumb", "Thumb", this);

    min = 0;
    max = 0;
    current = 0;
    last = -1;
    visible = 1;
    jump = 1;

    delay.tv_sec = 0;
    delay.tv_usec = ONESEC / 2;
    rate.tv_sec = 0;
    rate.tv_usec = ONESEC / 10;
    accel = 12;
    AddTranslations(scrolltrans);
    CVO_VOID_RETURN
}

void
Cvo_SBAccessory::_Init(int direction)
{   CVO_ENTER
    type = CvoT_SBAccessory;
    dir = direction;

    horizontalPad -= chamfer + moat + moatChamfer + moatEdge;
    verticalPad -= chamfer + moat + moatChamfer + moatEdge;
    chamfer = 0;
    moat = 0;
    moatChamfer = 0;
    moatEdge = 0;
    AddTranslations(accessorytrans);
    Register(Expose, &Cvo_SBAccessory::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_SBThumb::_Init()
{   CVO_ENTER
    type = CvoT_SBThumb;
    selectMask |= ButtonMotionMask|PointerMotionMask;
#if 0
    chamfer = Parent()->ToWindow()->Chamfer() - 1;
    if (chamfer < 0)
	chamfer = 0;
    else if (chamfer < 1)
	chamfer = 1;
#endif
    DontComputeMySize();
    AddTranslations(thumbtrans);
    CVO_VOID_RETURN
}

void
Cvo_SBAccessory::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    DrawArrow(dir, 0, 0, width, height);
    CVO_VOID_RETURN
}

int
Cvo_SBAccessory::StandardComputeLayoutSize(int)
{   CVO_ENTER
    Cvo_ScrollBar *sb = (Cvo_ScrollBar *)Parent();

    layout.minimum.width = sb->CalculateWidth();
    layout.desired.width = sb->CalculateWidth();
    layout.maximum.width = 0;
    layout.minimum.height = sb->CalculateHeight();
    layout.desired.height = sb->CalculateHeight();
    layout.maximum.height = 0;
    CVO_RETURN(1)
}


int
Cvo_ScrollBar::StandardComputeLayoutSize(int)
{   CVO_ENTER
    layout.minimum.width = CalculateWidth();
    layout.minimum.height = CalculateHeight();

    int rs = layout.ignoreshadow ? 0 : raise;

    if (layout.vertical) {
        layout.minimum.width += 2*(borderWidth + horizontalPad)+raise;
        layout.minimum.height += 2*(borderWidth + verticalPad)+rs;
    } else {
        layout.minimum.width += 2*(borderWidth + horizontalPad)+rs;
        layout.minimum.height += 2*(borderWidth + verticalPad)+raise;
    }

    layout.desired.width = layout.minimum.width;
    layout.desired.height = layout.minimum.height;

    layout.maximum.width = horiz ? 0 : layout.minimum.width;
    layout.maximum.height = horiz ? layout.minimum.height : 0;

    CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)
}

int
Cvo_SBThumb::StandardLayoutFunction(int rokay, int, int, int)
{   CVO_ENTER
    if (rokay == -1)
	CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)

    Cvo_ScrollBar *sb = (Cvo_ScrollBar *)parent;
    int size;	        // What size to resize the thumb to
    int avail;		// How man pixels on scroll bar
    int offset;		// Number of pixels to skip (the arrow)
    int padding;

    if (sb->horiz) {
        avail = sb->Width() - 2 * sb->Height();
        offset = sb->Height() + BorderWidth();
	padding = XWidth() - Width() + 2 * BorderWidth();
    } else {
        avail = sb->Height() - 2 * sb->Width();
        offset = sb->Width() + BorderWidth();
	padding = XHeight() - Height() + 2 * BorderWidth();
    }

    if (sb->visible == 0 && sb->max > sb->min) {
	size = sb->horiz ? sb->Height() : sb->Width();
    } else if (sb->visible < sb->max - sb->min) {
	size = (sb->visible * avail) / (sb->max - sb->min);
    } else {
	size = avail;
    }
    if (size < padding + 1) {
	size = padding + 1;
    }
    if (size > avail)
	size = avail; 
    avail -= size;
    size -= padding;


    if (sb->current > sb->max - sb->visible)
	sb->current = sb->max - sb->visible;
    if (sb->current < sb->min)
	sb->current = sb->min;


    if (size <= 0) {
	sb->SendScrollEvent();
	CVO_RETURN(1)
    }

    if (sb->visible < sb->max - sb->min)
	offset += ((sb->current - sb->min) * avail) /
		  (sb->max - sb->min - sb->visible);

    int x, y;

    x = sb->horiz ? offset : 0;
    y = sb->horiz ? 0 : offset;

    x += horizontalPad;
    y += verticalPad;

    if (!size)
	CVO_RETURN(1)
    if (sb->horiz) {
        ForceMoveForceResizeWindow(x, y, size, sb->Height() - (XWidth() - Width()), Cvo_LAYOUTTAG);
    } else {
        ForceMoveForceResizeWindow(x, y, sb->Width() - (XHeight() - Height()), size, Cvo_LAYOUTTAG);
    }
    sb->SendScrollEvent();
    CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)
}

int
Cvo_SBAccessory::StandardLayoutFunction(int rokay, int, int, int)
{   CVO_ENTER
    if (rokay == -1)
	CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)

    Cvo_ScrollBar *sb = (Cvo_ScrollBar *)parent;
    int size = 0;        // What size to resize the arrow to
    if (sb->horiz) {
        if (XHeight() + 2 * BorderWidth() != sb->Height())
            size = sb->Height();
    } else {
        if (XWidth() + 2 * BorderWidth() != sb->Width())
            size = sb->Width();
    }

    int x, y;

    switch (dir) {
    case Cvo_WEST:
    case Cvo_NORTH:
        x = 0;
        y = 0;
        break;
    case Cvo_SOUTH:
        x = 0;
        y = sb->Height() - (size ? size : sb->Width());
        break;
    case Cvo_EAST:
        y = 0;
        x = sb->Width() - (size ? size : sb->Height());
        break;
    }

    x += horizontalPad;
    y += verticalPad;

    if (size) {
//      size -= XWidth() - Width() + 2 * BorderWidth();
        ForceMoveForceResizeWindow(x, y, size, size, Cvo_LAYOUTTAG);
    } else {
        ForceMoveWindow(x, y);
    }
    CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)
}

void
Cvo_ScrollBar::MoveTo(XEvent *ev, int, char **)
{   CVO_ENTER
    if (ev->type != ButtonPress && ev->type != ButtonRelease)
	CVO_VOID_RETURN

    int avail;
    int request;
    XButtonEvent *be = (XButtonEvent *)ev;

    if (horiz) {
	request = be->x - Height();
        avail = Width() - 2 * Height() - thumb->XWidth();
    } else {
	request = be->y - Width();
        avail = Height() - 2 * Width() - thumb->XHeight();
    }

    int newcurrent = avail ? ((request * (max - min - visible)) / avail) : 0;
    if (current != newcurrent) {
	current = newcurrent;
	thumb->ReLayout();
    }

    if (ev->type == ButtonPress) {
	thumb->GrabPointer(ButtonMotionMask);
	thumb->Motion(ev, 0, 0);
	thumb->UngrabPointer();
    }
    CVO_VOID_RETURN
}

void
Cvo_ScrollBar::MotifMove(XEvent *ev, int, char **)
{
    if (ev->type != ButtonPress && ev->type != ButtonRelease)
	return;

    XButtonEvent *be = (XButtonEvent *)ev;

    int amt;
    if (visible) {
	amt = visible - 1;
    } else {
	amt = (max - min + 1) / 10;
	if (amt > 10)
	    amt = 10;
    }
    amt /= jump;
    if (amt < 1)
	amt = 1;

    int x, y;
    thumb->Origin(&x, &y);

    char *av[3];
    char buf[16];
    sprintf(buf, "%d", amt);
    av[0] = buf;
    av[1] = "<PARENT>";
    av[2] = 0;

    if (horiz && be->x > x || !horiz && be->y < y)
	up->Down(ev, 2, av);
    else
	down->Down(ev, 2, av);
}

void
Cvo_ScrollBar::PageUp(XEvent *ev, int, char **)
{   CVO_ENTER
    if (visible == 0) {
	MoveTo(ev, 0, 0);
	CVO_VOID_RETURN
    }

    if (current <= min)
	CVO_VOID_RETURN

    if (ev->type != ButtonPress && ev->type != ButtonRelease) {
	current -= visible;
	if (current < min)
	    current = min;
	thumb->ReLayout();
	CVO_VOID_RETURN
    }

    int avail;
    int request;
    XButtonEvent *be = (XButtonEvent *)ev;

    if (horiz) {
	request = be->x - Height();
        avail = Width() - 2 * Height();
    } else {
	request = be->y - Width();
        avail = Height() - 2 * Width();
    }

    current -= (visible * request + avail - 1) / avail;

    if (current < min)
	current = min;
    thumb->ReLayout();
    CVO_VOID_RETURN
}

void
Cvo_ScrollBar::PageDown(XEvent *ev, int, char **)
{   CVO_ENTER
    if (visible == 0) {
	MoveTo(ev, 0, 0);
	CVO_VOID_RETURN
    }

    if (current + visible >= max) {
	CVO_VOID_RETURN
    }

    if (ev->type != ButtonPress && ev->type != ButtonRelease) {
	current += visible;
	if (current + visible > max)
	    current = max - visible;
	thumb->ReLayout();
	CVO_VOID_RETURN
    }

    int avail;
    int request;
    XButtonEvent *be = (XButtonEvent *)ev;

    if (horiz) {
	request = be->x - Height();
        avail = Width() - 2 * Height();
    } else {
	request = be->y - Width();
        avail = Height() - 2 * Width();
    }

    current += (visible * request + avail - 1) / avail;
    if (current + visible > max)
	current = max - visible;
    thumb->ReLayout();
    CVO_VOID_RETURN
}

void
Cvo_SBThumb::Motion(XEvent *bev, int, char **)
{   CVO_ENTER
    Cvo_ScrollBar *sb = (Cvo_ScrollBar *)parent;

    int x, y;
    int ox, oy;
    int base;
    int avail;

    if (sb->horiz)
	avail = sb->Width() - 2 * sb->Height() - sb->thumb->XWidth();
    else
	avail = sb->Height() - 2 * sb->Width() - sb->thumb->XHeight();

    if (sb->visible >= sb->max - sb->min)
	CVO_VOID_RETURN

    base = avail * sb->current / (sb->max - sb->min - sb->visible);

    long mmask = ButtonMotionMask;

    if (bev->type == ButtonPress) {
	ox = bev->xbutton.x_root;
	oy = bev->xbutton.y_root;
    } else  {
	mmask |= PointerMotionMask;
	QueryMouseLocation(&x, &y, &ox, &oy);
    }

    sb->scrolling = True;
    for (;;) {
	XEvent ev;

	XMaskEvent(Dpy(),  mmask | ExposureMask | ButtonReleaseMask, &ev);

	if (ev.type == ButtonRelease || ev.type == MotionNotify) {
	    if (ev.type == MotionNotify) {
		while (XCheckMaskEvent(Dpy(), mmask, &ev))
			;
		x = ev.xmotion.x_root;
		y = ev.xmotion.y_root;
	    } else {
		x = ev.xbutton.x_root;
		y = ev.xbutton.y_root;
	    }

	    int where;

	    if (sb->horiz) {
		where = base + x - ox;
	    } else {
		where = base + y - oy;
	    }

	    int ocurrent = sb->current;

	    sb->current = (where * (sb->max - sb->min - sb->visible) + avail/2)
			  / avail;

	    if (sb->current > sb->max - sb->visible)
		sb->current = sb->max - sb->visible;
	    if (sb->current < sb->min)
		sb->current = sb->min;

	    if (ocurrent != sb->current)
		ReLayout();
	    if (ev.type == ButtonRelease) {
		sb->scrolling = False;
		sb->SendScrollEvent();
		CVO_VOID_RETURN
	    }
	} else {
	    _Cvo_event(&ev);
	}
    }
}

void
_Cvo_SB_CatchPressRelease(Cvo_Object *, XEvent *ev, void *vsb)
{   CVO_ENTER
    Cvo_ScrollBar *sb = (Cvo_ScrollBar *)vsb;
    sb->scrolling = False;
    ev->type = 0;
    CVO_VOID_RETURN
}

void
Cvo_SBAccessory::Down(XEvent *, int ac, char **av)
{   CVO_ENTER
    Cvo_ScrollBar *sb = (Cvo_ScrollBar *)parent;

    int amt = sb->jump;

    if (ac > 0) {
	int a = int(strtol(av[0], 0, 0));
	if (a > 0)
	    amt *= a;
    }

    int ocurrent = sb->current;

    if (dir == Cvo_SOUTH || dir == Cvo_EAST) {
	sb->current += amt;
    } else {
	sb->current -= amt;
    }

    if (sb->current > sb->max - sb->visible)
	sb->current = sb->max - sb->visible;
    if (sb->current < sb->min)
	sb->current = sb->min;

    Cvo_Registration *re;

    if (sb->visible < sb->max - sb->min && ocurrent != sb->current) {
	sb->scrolling = True;
	if (ac > 1 && !strcmp(av[1], "<PARENT>")) {
	    re = parent->Register(ButtonRelease,
			      _Cvo_SB_CatchPressRelease, sb);
	} else {
	    re =   this->Register(ButtonRelease,
			      _Cvo_SB_CatchPressRelease, sb);
	}
	re->MoveUp();
	sb->thumb->ReLayout();
    } else {
	CVO_VOID_RETURN
    }

    if (!Delay(sb->delay)) {
	delete re;
	sb->scrolling = False;
	sb->SendScrollEvent();
	CVO_VOID_RETURN
    }

    int cnt = 1;
    while (sb->scrolling) {
	XEvent ev;

	if (XCheckMaskEvent(Dpy(), ButtonReleaseMask, &ev)) {
	    delete re;
	    sb->scrolling = False;
	    sb->SendScrollEvent();
	    CVO_VOID_RETURN
	}
	while (XCheckMaskEvent(Dpy(), ExposureMask, &ev)) {
	    _Cvo_event(&ev);
	}

	ocurrent = sb->current;

	if (dir == Cvo_SOUTH || dir == Cvo_EAST) {
	    sb->current += amt;
	} else {
	    sb->current -= amt;
	}

	if (sb->current > sb->max - sb->visible)
	    sb->current = sb->max - sb->visible;
	if (sb->current < sb->min)
	    sb->current = sb->min;

	if (ocurrent == sb->current) {
	    while (XMaskEvent(Dpy(), ButtonReleaseMask|ExposureMask, &ev)) {
		if (ev.type == ButtonRelease) {
		    break;
		}
		_Cvo_event(&ev);
	    }
	    delete re;
	    sb->scrolling = False;
	    sb->SendScrollEvent();
	    CVO_VOID_RETURN
	}
	sb->thumb->ReLayout();
	if (sb->accel > 0 && ++cnt >= sb->accel)
	    continue;
	if (!Delay(sb->rate)) {
	//  UngrabPointer();
	    delete re;
	    sb->scrolling = False;
	    sb->SendScrollEvent();
	    CVO_VOID_RETURN
	}
    }
    sb->SendScrollEvent();
    delete re;
    CVO_VOID_RETURN
}

int
Cvo_SBAccessory::Delay(timeval &delay)
{   CVO_ENTER
    if (delay.tv_sec == 0 && delay.tv_usec == 0)
	CVO_RETURN(1)

    timeval done, now;
#if defined(__SYSV_GETTIMEOFDAY__)
    gettimeofday(&done);
#else
    gettimeofday(&done, 0);
#endif

    if ((done.tv_usec += delay.tv_usec) > ONESEC) {
	done.tv_usec -= ONESEC;
	done.tv_sec += 1;
    }
    done.tv_sec += delay.tv_sec;

    now = delay;

Cvo_ScrollBar *sb = (Cvo_ScrollBar *)parent;
    //
    // XXX - This is wrong!  Does not deal with multiple displays,
    //	     Does not deal with async stuff, all sorts of nasties.
    //
    while (now.tv_sec > 0 || (now.tv_sec == 0 && now.tv_usec > 0)) {
	fd_set r;
	FD_ZERO(&r);
	FD_SET(ConnectionNumber(Dpy()), &r);
	if (select(FD_SETSIZE, &r, 0, 0, &now) == 0)
	    break;

	XEvent ev;

	while (XCheckMaskEvent(Dpy(), ExposureMask, &ev)) {
	    _Cvo_event(&ev);
	}

	if (XCheckMaskEvent(Dpy(), ButtonReleaseMask, &ev)) {
	    CVO_RETURN(0)
	}

#if defined(__SYSV_GETTIMEOFDAY__)
	gettimeofday(&now);
#else
	gettimeofday(&now, 0);
#endif
	if (now.tv_usec > done.tv_usec) {
	    now.tv_sec = done.tv_sec - now.tv_sec - 1;
	    now.tv_usec = done.tv_usec - now.tv_usec + ONESEC;
	} else {
	    now.tv_sec = done.tv_sec - now.tv_sec;
	    now.tv_usec = done.tv_usec - now.tv_usec;
	}
    }
    CVO_RETURN(1)
}

CARD16
Cvo_ScrollBar::CalculateWidth()
{
    return(horiz ? 33 : 11);
}

CARD16
Cvo_ScrollBar::CalculateHeight()
{
    return(horiz ? 11 : 33);
}

void
Cvo_ScrollBar::SendScrollEvent()
{   CVO_ENTER
    if (compress && scrolling)
	CVO_VOID_RETURN
    if (current != last || (!scrolling && scrolled)) {
	last = current;
	Cvo_ScrollBarEvent ev;

	ev.value = current;
	ev.scrolling = scrolling;
	scrolled = scrolling;
	SendEvent(CvoScrollBarEvent, &ev);
    }
    CVO_VOID_RETURN
}
