//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: RootedList.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/_Machine.h++>
#include <stdlib.h>
#include <stddef.h>
#if	defined(__NEED_MALLOC__)
#include <malloc.h>
#endif
#include <Cvo/RootedList.h++>
#include <Cvo/util.h++>

Cvo_RootedList::Cvo_RootedList(Cvo_RootedList **root,
			       int (*sf)(Cvo_RootedList *, Cvo_RootedList *))
{   CVO_ENTER
    if (!root) {
	next =  prev = 0;
	CVO_VOID_RETURN
    }

    if (!*root) {
	next = 0;
	prev = this;
	*root = this;
	CVO_VOID_RETURN
    }

    if (sf)
	Insert(root, sf);
    else {
	next = 0;
	prev = (*root)->prev;
	prev->next = this;
	(*root)->prev = this;
    }
    CVO_VOID_RETURN
}

void
Cvo_RootedList::Insert(Cvo_RootedList **root,
		       int (*sf)(Cvo_RootedList *, Cvo_RootedList *))
{   CVO_ENTER
    Cvo_RootedList *n;

    if (!*root) {
	next = 0;
	prev = this;
	*root = this;
	CVO_VOID_RETURN
    }
    if (!sf) {
	next = 0;
	prev = (*root)->prev;
	prev->next = this;
	(*root)->prev = this;
	CVO_VOID_RETURN
    }
    n = *root;
    if ((*sf)(this, n) < 0) {
	prev = n->prev;
	next = n;
	n->prev = this;
	*root = this;
	CVO_VOID_RETURN
    }

    while (n = n->next) {
	if ((*sf)(this, n) < 0) {
	    next = n;
	    prev = n->prev;
	    next->prev = this;
	    prev->next = this;
	    CVO_VOID_RETURN
	}
    }
    n = (*root)->prev;
    n->next = this;
    this->prev = n;
    this->next = 0;
    (*root)->prev = this;
    CVO_VOID_RETURN
}

void
Cvo_RootedList::ReInsert(Cvo_RootedList **root,
		         int (*sf)(Cvo_RootedList *, Cvo_RootedList *))
{   CVO_ENTER
    if (!next && *root == this)
	CVO_VOID_RETURN

    Unlink(root);
    Insert(root, sf);
    CVO_VOID_RETURN
}

void
Cvo_RootedList::Unlink(Cvo_RootedList **root)
{   CVO_ENTER
    if (!root || !*root || !prev) {
	prev = 0;
	next = 0;
	return;
    }
    if (*root == this) {
	*root = next;
    } else {
	if ((*root)->prev == this)
	    (*root)->prev = prev;
	prev->next = next;
    }
    if (next)
	next->prev = prev;
    prev = 0;
    next = 0;
    CVO_VOID_RETURN
}

void
Cvo_RootedList_Sort(Cvo_RootedList **root, int (*sf)(Cvo_RootedList *,
						      Cvo_RootedList *))
{   CVO_ENTER
    Cvo_RootedList *rl;
    Cvo_RootedList *nr;
    Cvo_RootedList *ne;

    if (!*root || !(*root)->next)
	CVO_VOID_RETURN

    rl = *root;
    rl->prev = 0;
    ne = 0;

    nr = rl;
    rl = rl->next;
    nr->prev = nr;
    nr->next = 0;

    while (rl) {
	ne = rl->next;
	rl->Insert(&nr, sf);
	rl = ne;
    }
    *root = nr;
    CVO_VOID_RETURN
}
