//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Resource.cc,v 1.7 1994/09/06 18:30:08 prb Exp $"); }
#include <Cvo/Window.h++>
#include <memory.h>
#include <string.h>
#include <unistd.h>
#if defined(__USE_SYSINFO__)
#include <sys/systeminfo.h>
#define	gethostname(a,b)	sysinfo(SI_HOSTNAME, a, b)
#else
#include <netdb.h>	// This is for gethostname(), might not be portable
#if defined(__NEED_GETHOSTNAME_DEF__)
extern "C" int gethostname(char *, int);
#endif
#endif
#if	defined(__NEED_SYSENT__)
#include <sysent.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

static Cvo_OptionTable *UserOptions = 0;

static int _Cvo_abort(Display *dpy, XErrorEvent *err);
static void ReadArgs(int *pac, char ***pav);
static int IsMatch(char *s1, char *s2);
static void GetInitialResourceDatabase(Display *dpy, char *classname);
static void MergeCommandLine(Display *dpy, XrmDatabase rdb);
char *Cvo_ClassName::string = 0;
char *Cvo_ResourceName::string = 0;
char *Cvo_InstanceName::string = 0;


static onetime = 0;
static _printnames = 0;
static _printclasses = 0;
BOOL _cvo_debug_print_events = False;
BOOL _cvo_debug_mode = False;

#define	APPENDSTR(base, str)	{ register char *s = str; \
				  while (*base = *s++) ++base; }

static char *usage_args = 0;
static int usage_min = 0;
static int usage_max = 0;

void
Cvo_SetUsageArguments(char *s, int min, int max)
{
    delete [] usage_args;
    usage_args = new char [strlen(s) + 1];
    strcpy(usage_args, s);
    if (usage_min = min)
	++usage_min;
    usage_max = max + 1;
}

void
Cvo_Parse(int *ac, char ***av)
{   CVO_ENTER
    char buf[256];
    char buf2[256];
    register char *xbp;

    if (onetime++)
        CVO_VOID_RETURN

    Cvo_InitializeLocale();

    ((Cvo_OptimizeObjectCreation *)0)->CreateBlocks();

    _Cvo_Base.argv = new char *[_Cvo_Base.argc = *ac];

    memcpy((char *)_Cvo_Base.argv, (char *)*av, _Cvo_Base.argc * sizeof (char *));

    if (_Cvo_Base.ProgramName = strrchr((*av)[0], '/'))
        ++_Cvo_Base.ProgramName;
    else
        _Cvo_Base.ProgramName = (*av)[0];
    _Cvo_Base.QProgramName = XrmStringToQuark(_Cvo_Base.ProgramName);

    if (!(_Cvo_Base.ResourceName = getenv("RESOURCE_NAME"))) {
	if (!(_Cvo_Base.ResourceName = Cvo_ResourceName::string)) {
	    _Cvo_Base.ResourceName = strdup(_Cvo_Base.ProgramName);
  	    for (char *p = _Cvo_Base.ResourceName; *p; ++p) {
  		if (*p == '.')
  		    *p = '_';
  	    }
	}
    }

    _Cvo_Base.QResourceName = XrmStringToQuark(_Cvo_Base.ResourceName);

    if (!(_Cvo_Base.InstanceName = Cvo_InstanceName::string)) {
	_Cvo_Base.InstanceName = _Cvo_Base.ResourceName;
	_Cvo_Base.QInstanceName = _Cvo_Base.QResourceName;
    } else
	_Cvo_Base.QInstanceName = XrmStringToQuark(_Cvo_Base.InstanceName);

    if (!(_Cvo_Base.ClassName = Cvo_ClassName::string)) {
        _Cvo_Base.ClassName = strdup(_Cvo_Base.ProgramName);
        _Cvo_Base.ClassName[0] &= ~040;
        for (char *p = _Cvo_Base.ClassName; *p; ++p) {
            if (*p == '.')
                *p = '_';
        }
    }
    _Cvo_Base.QClassName = XrmStringToQuark(_Cvo_Base.ClassName);

    Cvo_Default *d = Cvo_Default::root;

    while (d) {
        XrmPutLineResource(&_Cvo_Base.ddb, d->res);
        d = d->next;
    }

    ReadArgs(ac, av);

    xbp = buf;
    APPENDSTR(xbp, _Cvo_Base.InstanceName);
    APPENDSTR(xbp, ".name");

    xbp = buf2;
    APPENDSTR(xbp, _Cvo_Base.ClassName);
    APPENDSTR(xbp, ".name");

    if (xbp = _Cvo_Base.GetResource(buf, buf2)) {
        _Cvo_Base.InstanceName = xbp;
	_Cvo_Base.QInstanceName = XrmStringToQuark(_Cvo_Base.InstanceName);
    }
    
    xbp = buf;
    APPENDSTR(xbp, _Cvo_Base.InstanceName);
    APPENDSTR(xbp, ".display");
    xbp = buf2;
    APPENDSTR(xbp, _Cvo_Base.ClassName);
    APPENDSTR(xbp, ".display");

    _Cvo_Base.DisplayName = _Cvo_Base.GetResource(buf, buf2);
    _Cvo_Base.QDisplayName = XrmStringToQuark(_Cvo_Base.DisplayName);

    CVO_VOID_RETURN
}

char *
Cvo_Base::GetOption(char *_name, char *_class)
{   CVO_ENTER
    char buf[256];
    char buf2[256];
    register char *p;

    if (!_name)
        CVO_RETURN(0)

    p = buf;
    APPENDSTR(p, InstanceName);
    *p++ = '.';
    APPENDSTR(p, _name);

    p = buf2;
    APPENDSTR(p, ClassName);
    *p++ = '.';
    APPENDSTR(p, _class ? _class : "no-class-given");

    CVO_RETURN(GetResource(buf, buf2))
}

char *
Cvo_Base::GetLocaleOption(char *_name, char *_class)
{   CVO_ENTER
    char buf[256];
    char buf2[256];
    register char *p;

    if (!_name)
        CVO_RETURN(0)

    p = buf;
    APPENDSTR(p, InstanceName);
    *p++ = '.';
    APPENDSTR(p, Locale);
    *p++ = '.';
    APPENDSTR(p, _name);

    p = buf2;
    APPENDSTR(p, ClassName);
    *p++ = '.';
    APPENDSTR(p, Locale);
    *p++ = '.';
    APPENDSTR(p, _class ? _class : "no-class-given");

    CVO_RETURN(GetResource(buf, buf2))
}

static int
_Cvo_abort(Display *dpy, XErrorEvent *err)
{   CVO_ENTER
    char message[100];
    XGetErrorText(dpy, err->error_code, message, sizeof(message));
    fprintf(stderr, "Cvo Error: %s\n", message);
    abort();
    CVO_RETURN(0)
}


inline BOOL
_cvo_truth(char *xrp, BOOL _default = False)
{
    if (xrp && xrp[0]) {
        xrp[0] |= 040;
        if (xrp[1])
            xrp[1] |= 040;
    }

    if (xrp && ( xrp[0] == 't' ||                       // True
                 xrp[0] == 'y' ||                       // Yes
                 xrp[0] == 'a' ||                       // Affermative
                (xrp[0] && xrp[1] == 'n')))             // oN
        _default = True;
    else if (xrp && ( xrp[0] == 'f' ||                  // False
                      xrp[0] == 'n' ||                  // No Negative
                     (xrp[0] && xrp[1] == 'f')))        // oFf
        _default = False;
    return(_default);
}

#if defined(X11R4)
#define	XrmSetDatabase(dpy, ddb)	(dpy->db = ddb)
#define	XrmGetDatabase(dpy)		(dpy->db)
#endif

static (*RealErrorHandler)(Display *, XErrorEvent *);

static int
IgnoreInputErrors(Display *dpy, XErrorEvent *ev)
{
    if (ev->request_code == 42)
        return(0);
    return(RealErrorHandler(dpy, ev));
}

void
Cvo_DisplayList::ReadResources()
{   CVO_ENTER
    char *xbp;

    XrmSetDatabase(dpy, _Cvo_Base.ddb);

    GetInitialResourceDatabase(dpy, _Cvo_Base.ClassName);

    if (_Cvo_Base.rdb) {
        MergeCommandLine(dpy, _Cvo_Base.rdb);
    }
    _Cvo_Base.rdb = XrmGetDatabase(dpy);

    if (xbp = _Cvo_Base.GetOption("name", "Name")) {
        _Cvo_Base.InstanceName = xbp;
	_Cvo_Base.QInstanceName = XrmStringToQuark(_Cvo_Base.InstanceName);
    }
    if (xbp = _Cvo_Base.GetOption("synchronous", "Synchronous")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't'))
            XSynchronize(dpy, 1);
    }
    if (xbp = _Cvo_Base.GetOption("debug", "Debug")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't')) {
            XSetIOErrorHandler((XIOErrorHandler)_Cvo_abort);
            XSetErrorHandler((XErrorHandler)_Cvo_abort);
	    _cvo_debug_mode = True;
        }
    }
    if (xbp = _Cvo_Base.GetOption("printdefaults", "Printdefaults")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't'))
	    Cvo_Default::Dump();
    }
    if (xbp = _Cvo_Base.GetOption("printnames", "Printnames")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't'))
            _printnames = 1;
    }
    if (xbp = _Cvo_Base.GetOption("printclasses", "Printclasses")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't'))
            _printclasses = 1;
    }
    if (xbp = _Cvo_Base.GetOption("printevents", "Printevents")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't'))
            _cvo_debug_print_events = True;
    }

    if (xbp = _Cvo_Base.GetOption("printoptimize", "Printoptimize")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't')) {
	    struct stat sb;
	    if (stat("Cvo_Optimize.cc", &sb) == 0) {
		fprintf(stderr, "Cvo_Optimize.cc already exists.\n");
	    } else
		_printoptimize = fopen("Cvo_Optimize.cc", "w");
	    if (_printoptimize) {
		fprintf(_printoptimize, "#include <Cvo/Object.h++>\n");
		fprintf(_printoptimize, "// This file was automatically created by the -printoptimize option.\n");
		fprintf(_printoptimize, "// It should not be hand edited.\n");
		fflush(_printoptimize);
	    }
        }
    }

    if (xbp = _Cvo_Base.GetOption("detach", "Detach")) {
        if (((xbp[0] | 040) == 'o' && (xbp[1]|040) == 'n') ||
            ((xbp[0] | 040) == 't')) {
                switch(fork()) {
                case 0:
                    break;
                case -1:
                    perror("fork");
                    break;
                default:
                    exit(0);
                    break;
                }
            }
    }

    for (Cvo_OptionTable *opts = UserOptions; opts; opts = opts->next) {
	char *xrp;

    	if (!opts->result)
	    continue;

	switch (opts->type) {
	case Cvo_OPT_NUMERIC:
	    if (xrp = _Cvo_Base.GetOption(opts->resource, opts->resource)) {
		char *e;
		INT v = INT(strtol(xrp, &e, 0));
		if (e && !*e && e != xrp)
		    *(INT *)opts->result = v;
	    }
	    break;
	case Cvo_OPT_STRING:
	    if (xrp = _Cvo_Base.GetOption(opts->resource, opts->resource))
		*(char **)opts->result = xrp;
	    break;
	case Cvo_OPT_BOOLEAN:
	    if (xrp = _Cvo_Base.GetOption(opts->resource, opts->resource))
		*(BOOL *)opts->result = _cvo_truth(xrp, *(BOOL *)opts->result);
	    break;
	}
    }

    RealErrorHandler = XSetErrorHandler(IgnoreInputErrors);

    CVO_VOID_RETURN
}

static Cvo_OptionTable BasicOpts[] = {
    { "+clicktotype",	"*clickToType",			"off",  },
    { "+debug",		"*debug",			"off",	},
    { "+printclasses",	"*printclasses",		"off",	},
    { "+printdefaults",	"*printdefaults",		"off",	},
    { "+printevents",	"*printevents",			"off",	},
    { "+printnames",	"*printnames",			"off",	},
    { "+reverse",	"*reverseVideo",		"off",	},
    { "+rv",		"*reverseVideo",		"off",
	"Unset Reverse Video",					},
    { "-background",	"*background",			0,	},
    { "-bd",		"*borderColor",			0,
	"Border Color",						},
    { "-bg",		"*background",			0,
	"Background Color",					},
    { "-bordercolor",	"*borderColor",			0,	},
    { "-borderwidth",	"*Application.borderWidth",	0,	},
    { "-bw",		"*Application.borderWidth",	0,
	"Border Width",						},
    { "-clicktotype",	"*clickToType",			"on",
	"Click to type mode",					},
    { "-debug",		"*debug",			"on",	},
    { "-detach",	"*detach",			"on",	},
    { "-display",	".display",			0,
	"Display to connect to",				},
    { "-ff",		"*fontFoundry",			0,	},
    { "-fg",		"*foreground",			0,
	"Foreground Color",					},
    { "-fm",		"*fontFamily",			0,	},
    { "-fn",		"*FONT",			0,	},
    { "-font",		"*FONT",			0,
	"Basic Font Name",					},
    { "-foreground",	"*foreground",			0,	},
    { "-fs",		"*fontSize",			0,
	"Basic Font Size",					},
    { "-fw",		"*fontWeight",			0,	},
    { "-geometry",	"*Application.geometry",	0,
	"Geometry",						},
    { "-icongeometry",	"*Application.iconGeometry",	0,
	"Position of icon",					},
    { "-iconic",	"*Application.iconic",		"on",
	"Start as an icon",					},
    { "-iconmask",	"*Application.iconMask",	0,
	"Mask for the icon",					},
    { "-iconpixmap",	"*Application.iconPixmap",	0,
	"Pixmap for the icon",					},
    { "-igeometry",	"*Application.iconGeometry",	0,	},
    { "-imask",		"*Application.iconMask",	0,	},
    { "-ipixmap",	"*Application.iconPixmap",	0,	},
    { "-mono",		"*monochrome",			"on",
	"Force Monochrome",					},
    { "-name",		".name",			0,
	"Name for Resources",					},
    { "-printclasses",	"*printclasses",		"on",	},
    { "-printdefaults",	"*printdefaults",		"on",	},
    { "-printevents",	"*printevents",			"on",	},
    { "-printnames",	"*printnames",			"on",	},
    { "-printoptimize",	"*printoptimize",		"on",	},
    { "-reverse",	"*reverseVideo",		"on",	},
    { "-rv",		"*reverseVideo",		"on",	
	"Set Reverse Video",					},
    { "-synchronous",	"*synchronous",			"on",	},
    { "-title",		"*Application.Title",		0,
	"Set Title",						},
    { "-xrm",		NULL,				0,	
	"Add Generic X Resource",				},
    { 0,						0,	},
};

static void
ReadArgs(int *pac, char ***pav)
{   CVO_ENTER
    char buf[1024];
    char *resbuf;
    char **av = *pav;
    int ac = *pac;

    strcpy(resbuf = buf, _Cvo_Base.ClassName);
    
    while (*resbuf)
        ++resbuf;

    while (*++av) {
        int c;
        int n = strlen(*av);
        Cvo_OptionTable *opts = 0;

        if (**av != '-' && **av != '+')
            break;

        --ac;

        if ((*av)[0] == (*av)[1] && !(*av)[2]) {
            ++av;
            break;
        }

        //
        // First we check in the users option table
        ///
  	if (UserOptions) {
	    opts = UserOptions;

	    while (opts && (c = strncmp(*av, opts->option, n)) > 0) {
		opts = opts->next;
	    }
	}

        //
        // If we can't find it there we check the default table
	// Note that the Cvo options use an array instead of the
	// linked list approach use by user options.
        //
	if (c || !opts) {
	    opts = BasicOpts;

	    while (opts->option && (c = strncmp(*av, opts->option, n)) > 0)
		++opts;
	}

        if (opts->option && !c) {
            register char *b;

            if (opts->resource) {
                strcpy(b = resbuf, opts->resource);
                while (*b)
                    ++b;

                *b++ = ':';
		switch (opts->type & ~Cvo_OPT_USED) {
		case Cvo_OPT_NUMERIC: {
		    if (!*++av)
			Cvo_usage();
		    --ac;
		    char *e;
		    INT v = INT(strtol(*av, &e, 0));
		    if (!e || *e || e == *av)
			Cvo_Failure(CvoE_FATAL, CvoE_NONUMERIC,
				    "Option %s passed none numeric value %s\n",
				     opts->option, *av);
		    sprintf(b, "%d", v);
		    if (opts->result)
			*(INT *)opts->result = v;
		    break;
		  }
		case Cvo_OPT_STRING: {
		    if (!*++av)
			Cvo_usage();
		    --ac;
		    strcpy(b, *av);
		    if (opts->result)
			*(char **)opts->result = *av;
		    break;
		  }
		case Cvo_OPT_SET: {
		    strcpy(b, opts->value);
		    if (opts->result)
			*(char **)opts->result = opts->value;
		    break;
		  }
		case Cvo_OPT_BOOLEAN: {
		    BOOL v;
		    char *xrp = opts->value;

		    v = _cvo_truth(xrp, opts->option[0] == '-' ? True : False);

		    sprintf(b, "%s", v ? "True" : "False");
		    if (opts->result)
			*(BOOL *)opts->result = v;
		    break;
		  }
		default:
		    if (opts->value) {
			strcpy(b, opts->value);
		    } else {
			if (!*++av)
			    Cvo_usage();
			--ac;
			strcpy(b, *av);
		    }
		}
		opts->type |= Cvo_OPT_USED;
                b = buf;
            } else {
                if (!*++av)
                    Cvo_usage();
                --ac;
//		if (**av == '.' || **av == '*') {
//		    strcpy(buf, _Cvo_Base.ClassName);
//		    strcat(b = buf, *av);
//		} else
		    b = *av;
            }
            XrmPutLineResource(&_Cvo_Base.rdb, b);
            continue;
        }
        Cvo_usage();
        break;
    }
    av[-1] = **pav;
    *pav = av - 1;
    *pac = ac;

    if (ac < usage_min || usage_max && ac > usage_max)
	Cvo_usage();

    CVO_VOID_RETURN
}

static int
IsMatch(char *s1, char *s2)
{   CVO_ENTER
    while (*s1 && *s1 == *s2)
        ++s1, ++s2;
    CVO_RETURN(*s1 == '\0')
}

typedef char *String;
static String XtGetRootDirName(String buf);
static XrmDatabase GetAppSystemDefaults(char *classname);
static XrmDatabase GetAppUserDefaults(char *classname);
static XrmDatabase GetUserDefaults(Display *dpy);
static XrmDatabase GetEnvironmentDefaults(Display *dpy);
static XrmDatabase GetConfiguredDefaults(Display *dpy, char *_class);

static String
XtGetRootDirName(String buf)
{   CVO_ENTER
     uid_t uid;
     struct passwd *pw;
     static char *ptr = NULL;

     if (ptr == NULL) {
    if((ptr = getenv("HOME")) == NULL) {
        if((ptr = getenv("USER")) != NULL) pw = getpwnam(ptr);
        else {
        uid = getuid();
 		pw = getpwuid(uid);
        }
        if (pw) ptr = pw->pw_dir;
        else {
        ptr = NULL;
        *buf = '\0';
        }
    }
     }

     if (ptr != NULL) 
 	(void) strcpy(buf, ptr);

     buf += strlen(buf);
     *buf = '/';
     buf++;
     *buf = '\0';
     CVO_RETURN(buf)
}

#ifndef	MAXPATHLEN
#define	MAXPATHLEN	1024
#endif
#ifndef XAPPLOADDIR
#define XAPPLOADDIR  "/usr/lib/X11/app-defaults/"
#endif
#ifndef XAPPLOADDIR2
#define XAPPLOADDIR2 "/home/sumac4/prb/lib/X11-Defaults/"
#endif

static XrmDatabase
GetAppSystemDefaults(char *classname)
{   CVO_ENTER
    XrmDatabase rdb;
    char	filenamebuf[MAXPATHLEN];
    char	*filename = &filenamebuf[0];

    (void) strcpy(filename, XAPPLOADDIR);
    (void) strcat(filename, classname);
    
    rdb = XrmGetFileDatabase(filename);
    if (!rdb) {
	(void) strcpy(filename, XAPPLOADDIR2);
	(void) strcat(filename, classname);
	
	rdb = XrmGetFileDatabase(filename);
    }

    CVO_RETURN(rdb)
}

static XrmDatabase
GetAppUserDefaults(char *classname)
{   CVO_ENTER
    XrmDatabase rdb;
    char	filenamebuf[MAXPATHLEN];
    char	*filename = &filenamebuf[0];

    if ((filename = getenv("XAPPLRESDIR")) == NULL)
        (void) XtGetRootDirName(filename = &filenamebuf[0]);
    else
        filename = strcpy(filenamebuf, filename);

    if (filenamebuf[0])
	strcat(filename, "/");

    (void) strcat(filename, classname);
    
    rdb = XrmGetFileDatabase(filename);

    CVO_RETURN(rdb)
}

static XrmDatabase
GetUserDefaults(Display *dpy)
{   CVO_ENTER
    XrmDatabase rdb;
    char	filenamebuf[MAXPATHLEN];
    char	*filename = &filenamebuf[0];

#if !defined(__NO_XDEFAULTS__)
    if (dpy->xdefaults != NULL) {
        rdb = XrmGetStringDatabase(dpy->xdefaults);
    } else
#endif
    {
        (void) XtGetRootDirName(filename);
        (void) strcat(filename, ".Xdefaults");
        rdb = XrmGetFileDatabase(filename);
    }

    CVO_RETURN(rdb)
}

static XrmDatabase
GetEnvironmentDefaults(Display *)
{   CVO_ENTER
    XrmDatabase rdb;
    char	filenamebuf[MAXPATHLEN];
    char	*filename = &filenamebuf[0];

    if ((filename = getenv("XENVIRONMENT")) == NULL) {
        int len;
        (void) XtGetRootDirName(filename = &filenamebuf[0]);
        (void) strcat(filename, ".Xdefaults-");
        len = strlen(filename);
        gethostname(filename+len, MAXPATHLEN-len);
    }

    rdb = XrmGetFileDatabase(filename);
    CVO_RETURN(rdb)
}

static XrmDatabase
GetConfiguredDefaults(Display *, char *_class)
{   CVO_ENTER
    XrmDatabase rdb;
    static char	filenamebuf[MAXPATHLEN];
    char	*filename = &filenamebuf[0];
    int len;

    (void) XtGetRootDirName(filename = &filenamebuf[0]);
    (void) strcat(filename, ".Xdefaults-");
    strcat(filename, _class);
    len = strlen(filename);

//	ConfigurationFile = filename;
    rdb = XrmGetFileDatabase(filename);
    CVO_RETURN(rdb)
}

static void
GetInitialResourceDatabase(Display *dpy, char *classname)
{   CVO_ENTER
    XrmDatabase rdb;
    XrmDatabase db = XrmGetDatabase(dpy);

    rdb = GetAppSystemDefaults(classname);
    if (rdb != NULL) XrmMergeDatabases(rdb, &db);

    rdb = GetAppUserDefaults(classname);
    if (rdb != NULL) XrmMergeDatabases(rdb, &db);

    rdb = GetUserDefaults(dpy);
    if (rdb != NULL) XrmMergeDatabases(rdb, &db);

    rdb = GetEnvironmentDefaults(dpy);
    if (rdb != NULL) XrmMergeDatabases(rdb, &db);

    rdb = GetConfiguredDefaults(dpy, classname);
    if (rdb != NULL) XrmMergeDatabases(rdb, &db);

    XrmSetDatabase(dpy, db);
    CVO_VOID_RETURN
}

static void
MergeCommandLine(Display *dpy, XrmDatabase rdb)
{   CVO_ENTER
    if (rdb != NULL) {
	XrmDatabase db = XrmGetDatabase(dpy);
        XrmMergeDatabases(rdb, &db);
	XrmSetDatabase(dpy, db);
    }
    CVO_VOID_RETURN
}

char *
Cvo_Object::GetNewResource(char *_name, char *_class, char *_default)
{   CVO_ENTER
    char *s = GetResource(_name, _class, _default);
    if (s) {
	char *r = new char[strlen(s)+1];
	if (r)
	    strcpy(r, s);
	CVO_RETURN(r)
    }
    CVO_RETURN(s)
}

char *
Cvo_Object::GetNewResource(XrmQuark _name, XrmQuark _class, char *_default)
{   CVO_ENTER
    char *s = GetResource(_name, _class, _default);
    if (s) {
	char *r = new char[strlen(s)+1];
	if (r)
	    strcpy(r, s);
	CVO_RETURN(r)
    }
    CVO_RETURN(s)
}

char *
Cvo_Object::GetResource(char *_name, char *_class, char *_default)
{   CVO_ENTER
    char *n, *c, *x = 0;

    _class = _class ? _class : "no-class-given";

    n = BuildName(_name);
    c = BuildClass(_class);
    if (monochrome) {
        x = Get(n, c, "mono", "Mono");
    } else {
        x = Get(n, c, "color", "Color");
    }
    if (!x && IsMain()) {
        if (monochrome)
            x = Get(_name, _class, "mono", "Mono");
        else
            x = Get(_name, _class, "color", "Color");
	if (!x)
            x = Get(_name, _class);
    }
    CVO_RETURN(x ? x : _default)
}

char *
Cvo_DisplayList::GetResource(char *_name, char *_class, char *_default)
{   CVO_ENTER
    XrmQuark n[8], c[8];

    _class = _class ? _class : "no-class-given";

    n[7] = 0;
    n[6] = XrmStringToQuark(_name);
    c[7] = 0;
    c[6] = XrmStringToQuark(_class);

    char *x = Get(&n[6], &c[6]);

    CVO_RETURN(x ? x : _default)
}

BOOL 
Cvo_DisplayList::GetResourceTruth(char *_name, char *_class, BOOL _default)
{   CVO_ENTER
    char *xrp = GetResource(_name, _class);

    CVO_RETURN(_cvo_truth(xrp, _default))
}

int 
Cvo_DisplayList::GetResourceInt(char *_name, char *_class, int _default)
{   CVO_ENTER
    char *xrp = GetResource(_name, _class);

    if (xrp) {
        char *e;
        long r = strtol(xrp, &e, 0);
        if (e && *e)
            CVO_RETURN(_default)
        CVO_RETURN((int)r)
    }
    CVO_RETURN(_default)
}

char *
Cvo_Object::GetResource(XrmQuark _name, XrmQuark _class, char *_def,
			XrmQuark nq, XrmQuark cq)
{   CVO_ENTER
    XrmQuarkList n, c;
    char *x = 0;

    if (!_class)
	_class = _QNoClass;

    if (nq) {
	n = BuildName(nq, _name);
	c = BuildClass(cq ? cq : nq, _class);
    } else {
	n = BuildName(_name);
	c = BuildClass(_class);
    }
    if (monochrome) {
        x = Get(n, c, _Qmono, _QMono);
    } else {
        x = Get(n, c, _Qcolor, _QColor);
    }
    if (!x && IsMain()) {
        if (monochrome)
            x = Get(_name, _class, _Qmono, _QMono);
        else
            x = Get(_name, _class, _Qcolor, _QColor);
	if (!x)
            x = Get(_name, _class);
    }
    CVO_RETURN(x ? x : _def)
}

int 
Cvo_Object::GetResourceInt(char *_name, char *_class, int _default)
{   CVO_ENTER
    char *xrp = GetResource(_name, _class);

    if (xrp) {
        char *e;
        long r = strtol(xrp, &e, 0);
        if (e && *e)
            CVO_RETURN(_default)
        CVO_RETURN((int)r)
    }
    CVO_RETURN(_default)
}

int 
Cvo_Object::GetResourceInt(XrmQuark _name, XrmQuark _class, int _default)
{   CVO_ENTER
    char *xrp = GetResource(_name, _class);

    if (xrp) {
        char *e;
        long r = strtol(xrp, &e, 0);
        if (e && *e)
            CVO_RETURN(_default)
        CVO_RETURN((int)r)
    }
    CVO_RETURN(_default)
}

BOOL 
Cvo_Object::GetResourceTruth(char *_name, char *_class, BOOL _default)
{   CVO_ENTER
    char *xrp = GetResource(_name, _class);

    if (xrp && xrp[0]) {
        xrp[0] |= 040;
        if (xrp[1])
            xrp[1] |= 040;
    }

    if (xrp && ( xrp[0] == 't' ||			// True
             xrp[0] == 'y' ||			// Yes
             xrp[0] == 'a' ||			// Affermative
            (xrp[0] && xrp[1] == 'n')))		// oN
        CVO_RETURN(True)
    else if (xrp && ( xrp[0] == 'f' ||		// False
              xrp[0] == 'n' ||		// No Negative
                 (xrp[0] && xrp[1] == 'f')))	// oFf
        CVO_RETURN(False)
    CVO_RETURN(_default)
}

BOOL 
Cvo_Object::GetResourceTruth(XrmQuark _name, XrmQuark _class, BOOL _default)
{   CVO_ENTER
    char *xrp = GetResource(_name, _class);

    if (xrp && xrp[0]) {
        xrp[0] |= 040;
        if (xrp[1])
            xrp[1] |= 040;
    }

    if (xrp && ( xrp[0] == 't' ||			// True
             xrp[0] == 'y' ||			// Yes
             xrp[0] == 'a' ||			// Affermative
            (xrp[0] && xrp[1] == 'n')))		// oN
        CVO_RETURN(True)
    else if (xrp && ( xrp[0] == 'f' ||		// False
              xrp[0] == 'n' ||		// No Negative
                 (xrp[0] && xrp[1] == 'f')))	// oFf
        CVO_RETURN(False)
    CVO_RETURN(_default)
}

char *
Cvo_Object::Get(XrmQuark qname, XrmQuark qclass,
		XrmQuark cname, XrmQuark cclass)
{   CVO_ENTER
    XrmQuark qnl[8];
    XrmQuark qcl[8];

    qnl[7] = 0;
    qcl[7] = 0;
    qnl[6] = qname;
    qcl[6] = qclass;
    CVO_RETURN(DisplayList()->Get(&qnl[6], &qcl[6], cname, cclass))
}

char *
Cvo_DisplayList::Get(XrmQuarkList qname, XrmQuarkList qclass,
		  XrmQuark cname, XrmQuark cclass)
{   CVO_ENTER
    XrmRepresentation type;
    XrmValue value;

    if (!qclass) {
	XrmQuark qcl[8];
	qcl[7] = 0;
	qcl[6] = _QNoClass;
	qclass = &qcl[6];
    }

    if (cname && cclass) {
	*--qname = cname;
	*--qclass = cclass;
    }

    if (_Cvo_Base.QLocale) {
	*--qname = _Cvo_Base.QLocale;
	*--qclass = _Cvo_Base.QLocale;
    }
    *--qname = _Cvo_Base.QInstanceName;
    *--qclass = _Cvo_Base.QClassName;

    char *ret = 0;
    
    if (XrmQGetResource(XrmGetDatabase(Dpy()), qname, qclass, &type, &value) == True)
	ret = (char *)value.addr;

    if (_printnames) {
	while (qname[0] && qname[1]) {
	    fprintf(stderr, "%s.", XrmQuarkToString(qname[0]));
	    ++qname;
	}
	fprintf(stderr, "%s::", XrmQuarkToString(qname[0]));
	if (ret)
	    fprintf(stderr, " %s\n", ret);
	else
	    fprintf(stderr, "\n", ret);
    }
    if (_printclasses) {
	while (qclass[0] && qclass[1]) {
	    fprintf(stderr, "%s.", XrmQuarkToString(qclass[0]));
	    ++qclass;
	}
	fprintf(stderr, "%s::", XrmQuarkToString(qclass[0]));
	if (ret)
	    fprintf(stderr, " %s\n", ret);
	else
	    fprintf(stderr, "\n", ret);
    }
    CVO_RETURN(ret)
}

char *
Cvo_Object::Get(char *_name, char *_class, char *cname, char *cclass)
{   CVO_ENTER
    static char aname[256];
    static char aclass[256];
    static char *ane = 0;
    static char *ace = 0;
    register char *p;
    char *type;
    XrmValue value;
    XrmDatabase db = XrmGetDatabase(Dpy());

    if (!_class)
        _class = "no-class-given";

    if (!ane) {
	p = aname;
	APPENDSTR(p, _Cvo_Base.InstanceName);
	*p++ = '.';
	APPENDSTR(p, _Cvo_Base.Locale);
	*p++ = '.';
	ane = p;

	p = aclass;
	APPENDSTR(p, _Cvo_Base.ClassName);
	*p++ = '.';
	APPENDSTR(p, _Cvo_Base.Locale);
	*p++ = '.';
	ace = p;
    }

    //
    // This check is true when we have specified Mono/Color.
    // This is always true.  It is unforutnate because it doubles the
    // number of checks we have to make.
    //
    if (cname && cclass) {
	p = ane;
	APPENDSTR(p, cname);
	*p++ = '.';
	APPENDSTR(p, _name);

	p = ace;
	APPENDSTR(p, cclass);
	*p++ = '.';
	APPENDSTR(p, _class);

        if (XrmGetResource(db, aname, aclass, &type, &value) == True) {
            if (_printnames)
                fprintf(stderr, "%s: %s\n", aname, (char *)value.addr);
            if (_printclasses)
                fprintf(stderr, "%s: %s\n", aclass, (char *)value.addr);

            CVO_RETURN((char *)value.addr)
        }
        if (_printnames)
            fprintf(stderr, "%s:\n", aname);
        if (_printclasses)
            fprintf(stderr, "%s:\n", aclass);
	// XXX - added in to speed this up... this might be bad.
        CVO_RETURN(0)
    }

    p = ane;
    APPENDSTR(p, _name);

    p = ace;
    APPENDSTR(p, _class);


    if (XrmGetResource(db, aname, aclass, &type, &value) == False) {
        if (_printnames)
            fprintf(stderr, "%s:\n", aname);
        if (_printclasses)
            fprintf(stderr, "%s:\n", aclass);
        CVO_RETURN(0)
    }
    if (_printnames)
        fprintf(stderr, "%s: %s\n", aname, (char *)value.addr);
    if (_printclasses)
        fprintf(stderr, "%s: %s\n", aclass, (char *)value.addr);

    CVO_RETURN((char *)value.addr)
}

char *
Cvo_Base::GetResource(char *_name, char *_class)
{   CVO_ENTER
    char *type;
    XrmValue value;

    _class = _class ? _class : "no-class-given";

    if (XrmGetResource(rdb, _name, _class, &type, &value) == False) {
        if (_printnames)
            fprintf(stderr, "%s:\n", _name);
        if (_printclasses)
            fprintf(stderr, "%s:\n", _class);
        CVO_RETURN(0)
    }
    if (_printnames)
        fprintf(stderr, "%s: %s\n", _name, (char *)value.addr);
    if (_printclasses)
        fprintf(stderr, "%s: %s\n", _class, (char *)value.addr);

    CVO_RETURN((char *)value.addr)
}

//
// BIG MAJOR WARNING!!!
// The routines which call the Build* routines expect to be able to
// prepend 3 quarks to the begining of the list.  You have been warned.
//

XrmQuarkList 
Cvo_Object::BuildName(XrmQuark q, XrmQuark q2)
{   CVO_ENTER
    static XrmQuark xrq[256] = { 0 };	// This seems pretty deep to me
    XrmQuarkList list = &xrq[254];

    if (q2)
	*list-- = q2;
    *list = q;

    for (Cvo_Object *w = this; w; w = w->Parent())
	*--list = w->QName();
    CVO_RETURN(list)
}

XrmQuarkList 
Cvo_Object::BuildClass(XrmQuark q, XrmQuark q2)
{   CVO_ENTER
    static XrmQuark xrq[256] = { 0 };	// This seems pretty deep to me
    XrmQuarkList list = &xrq[254];

    if (q2)
	*list-- = q2;
    *list = q;

    for (Cvo_Object *w = this; w; w = w->Parent())
	*--list = w->QClass();
    CVO_RETURN(list)
}

char *
Cvo_Object::BuildName(char *nm)
{   CVO_ENTER
    Cvo_Object *w;

    static char _name[1024];
    static char *lastp = 0;
    static long lastserial = 0;
    char *p;
    char *n;
    register tl;

    if (lastserial == serial) {
        if (nm) {
            lastp[-1] = '.';
            strcpy(lastp, nm);
        } else {
            lastp[-1] = '\0';
        }
        CVO_RETURN(_name)
    }

    lastserial = serial;

    w = this;

    tl = 0;

    while (w) {
	char *c;
        if (c = w->Name())
            tl += strlen(c) + 1;
        w = w->parent;
    }

    lastp = _name + tl;
    p = lastp;

    if (nm)
        while (*p++ = *nm++)
            ;

    p = lastp;

    w = this;
    while (w) {
	char *c;
        if ((c = w->Name()) && *c) {
            *--p = '.';
            n = c + strlen(c);
            while (n > c)
                *--p = *--n;
        }
        w = w->parent;
    }
    if (!nm)
        lastp[-1] = '\0';
    CVO_RETURN(_name)
}

char *
Cvo_Object::BuildClass(char *nm)
{   CVO_ENTER
    Cvo_Object *w;

    static char _class[1024];
    static char *lastp = 0;
    static long lastserial = 0;
    char *p;
    char *n;
    register tl;

    if (lastserial == serial) {
        strcpy(lastp, nm);
        CVO_RETURN(_class)
    }

    lastserial = serial;

    w = this;

    tl = 0;

    while (w) {
	char *c;
        if (c = w->Class())
            tl += strlen(c) + 1;
        w = w->parent;
    }

    lastp = _class + tl;
    p = lastp;

    while (*p++ = *nm++)
        ;

    p = lastp;

    w = this;
    while (w) {
	char *c;
        if ((c = w->Class()) && *c) {
            *--p = '.';
	    n = c + strlen(c);
            while (n > c)
                *--p = *--n;
        }
        w = w->parent;
    }
    CVO_RETURN(_class)
}

void
Cvo_usage()
{   CVO_ENTER
    fprintf(stderr, "Usage: %s", _Cvo_Base.ProgramName);
    if (UserOptions)
	fprintf(stderr, " [application options]");
    fprintf(stderr, " [cvo options]");
    if (usage_args)
	fprintf(stderr, " %s\n", usage_args);
    fprintf(stderr, "\n");

    int needh = True;

    while (UserOptions) {
	if (UserOptions->help) {
	    if (needh) {
		needh = False;
		fprintf(stderr, "Application Specific options:\n");
	    }
	    fprintf(stderr, "%-16s %s\n", UserOptions->option,
					  UserOptions->help);
	}
	UserOptions = UserOptions->next;
    }

    fprintf(stderr, "Standard Cvo options:\n");
    for (Cvo_OptionTable *opts = BasicOpts; opts->option; ++opts)
	if (opts->help)
	    fprintf(stderr, "%-16s %s\n", opts->option, opts->help);
    exit(1);
}

Cvo_Default *Cvo_Default::root = 0;

Cvo_Default::Cvo_Default(char *str)
{   CVO_ENTER
    if (str) {
	next = root;
	root = this;
	res = str;
    }
    CVO_VOID_RETURN
}

Cvo_Default::Cvo_Default(Cvo_Default const &d)
{
    if (root == &d)
	root = this;
    next = d.next;
    res = d.res;
}

void
Cvo_Default::Dump()
{
    Cvo_Default *defs = root;

    while (defs) {
	fprintf(stderr, "%s\n", defs->res);
	defs = defs->next;
    }
}

void
_Cvo_InsertUserOption(Cvo_OptionTable *opt)
{
    if (!UserOptions) {
	UserOptions = opt;
	opt->next = 0;
	return;
    }

    Cvo_OptionTable *last = 0;
    Cvo_OptionTable *uopts = UserOptions;
    while (uopts && strcmp(uopts->option, opt->option) < 0) {
	last = uopts;
	uopts = uopts->next;
    }
    if (last) {
	opt->next = last->next;
	last->next = opt;
    } else {
	opt->next = UserOptions;
	UserOptions = opt;
    }
}

Cvo_NumericOption::Cvo_NumericOption(char *opt, char *res, char *h, INT *data)
{
    option = opt;
    resource = res;
    value = 0;
    help = h;
    type = Cvo_OPT_NUMERIC;
    result = data;
    _Cvo_InsertUserOption(this);
}

Cvo_StringOption::Cvo_StringOption(char *opt, char *res, char *h, char **data)
{
    option = opt;
    resource = res;
    value = 0;
    help = h;
    type = Cvo_OPT_STRING;
    result = data;
    _Cvo_InsertUserOption(this);
}

Cvo_SetOption::Cvo_SetOption(char *opt, char *res, char *v, char *h, char **d)
{
    option = opt;
    resource = res;
    value = v;
    help = h;
    type = Cvo_OPT_SET;
    result = d;
    _Cvo_InsertUserOption(this);
}

Cvo_BooleanOption::Cvo_BooleanOption(char *opt, char *res, char *h,
				     BOOL *data, char *def)
{
    option = opt;
    resource = res;
    value = def;
    help = h;
    type = Cvo_OPT_BOOLEAN;
    result = data;
    _Cvo_InsertUserOption(this);
}
