//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Register.cc,v 1.5 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/InputContext.h++>
#include <string.h>

//
// PASSON are the sets of masks that need to be passed on to the parent
// window that the window manager shoved under us.
//

#define	PASSON			StructureNotifyMask

static CARD32 EventTypes[Cvo_MaxEvent] = {
	/* 0  ScrollBarChange	 */	NoEventMask,
	/* 1  EnterInput	 */	NoEventMask,
	/* 2  KeyPress		 */	KeyPressMask,
	/* 3  KeyRelease	 */	KeyReleaseMask,
	/* 4  ButtonPress	 */	ButtonPressMask|ButtonReleaseMask,
	/* 5  ButtonRelease	 */	ButtonReleaseMask|ButtonPressMask,
	/* 6  MotionNotify	 */	ButtonMotionMask,
					/* PointerMotionHintMask */
					/* PointerMotionMask */
					/* Button1MotionMask */
					/* Button2MotionMask */
					/* Button3MotionMask */
					/* Button4MotionMask */
					/* Button5MotionMask */
	/* 7  EnterNotify	 */	EnterWindowMask,
	/* 8  LeaveNotify	 */	LeaveWindowMask,
	/* 9  FocusIn		 */	FocusChangeMask,
	/* 10 FocusOut		 */	FocusChangeMask,
	/* 11 KeymapNotify	 */	KeymapStateMask,
	/* 12 Expose		 */	ExposureMask,
	/* 13 GraphicsExpose	 */	ExposureMask,
	/* 14 NoExpose		 */	ExposureMask,
	/* 15 VisibilityNotify	 */	VisibilityChangeMask,
	/* 16 CreateNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 17 DestroyNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 18 UnmapNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 19 MapNotify		 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 20 MapRequest	 */	SubstructureRedirectMask,
	/* 21 ReparentNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 22 ConfigureNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 23 ConfigureRequest	 */	SubstructureRedirectMask,
	/* 24 GravityNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 25 ResizeRequest	 */	ResizeRedirectMask,
	/* 26 CirculateNotify	 */	StructureNotifyMask,
					/* SubstructureNotifyMask */
	/* 27 CirculateRequest	 */	SubstructureRedirectMask,
	/* 28 PropertyNotify	 */	PropertyChangeMask,
	/* 29 SelectionClear	 */	NoEventMask,
	/* 30 SelectionRequest	 */	NoEventMask,
	/* 31 SelectionNotify	 */	NoEventMask,
	/* 32 ColormapNotify	 */	ColormapChangeMask,
	/* 33 ClientMessage	 */	NoEventMask,
	/* 34 MappingNotify	 */	NoEventMask,
	/* 35 reserved		 */	NoEventMask,
	/* 36 reserved		 */	NoEventMask,
	/* 37 reserved		 */	NoEventMask,
	/* 38 reserved		 */	NoEventMask,
	/* 39 reserved		 */	NoEventMask,
	/* 40 reserved		 */	NoEventMask,
	/* 41 reserved		 */	NoEventMask,
	/* 42 reserved		 */	NoEventMask,
	/* 43 reserved		 */	NoEventMask,
	/* 44 reserved		 */	NoEventMask,
	/* 46 reserved		 */	NoEventMask,
	/* 47 reserved		 */	NoEventMask,
	/* InternalEvent0	 */	NoEventMask,
	/* InternalEvent1	 */	NoEventMask,
	/* InternalEvent2	 */	NoEventMask,
	/* InternalEvent3	 */	NoEventMask,
	/* InternalEvent4	 */	NoEventMask,
	/* InternalEvent5	 */	NoEventMask,
	/* InternalEvent6	 */	NoEventMask,
	/* InternalEvent7	 */	NoEventMask,
	/* InternalEvent8	 */	NoEventMask,
	/* InternalEvent9	 */	NoEventMask,
	/* InternalEvent10	 */	NoEventMask,
	/* InternalEvent11	 */	NoEventMask,
	/* InternalEvent12	 */	NoEventMask,
	/* InternalEvent13	 */	NoEventMask,
	/* InternalEvent14	 */	NoEventMask,
	/* InternalEvent15	 */	NoEventMask,
};

Cvo_Registration *
Cvo_Object::Register(CARD32 e, CARD16 m, Cvo_EvFunc f, void *d, KeySym k)
{
    Cvo_InternalRegistration *dh = new Cvo_InternalRegistration(this, e, m, k, f, d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

Cvo_Registration *
Cvo_Object::RegisterKey(KeySym k, CARD16 m, Cvo_EvFunc f, void *d)
{
    Cvo_InternalRegistration *dh = new Cvo_InternalRegistration(this,KeyPress,m,k,f,d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

Cvo_Registration *
Cvo_Object::Register(CARD32 e, CARD16 m, Cvo_ExtEvFunc f, void *d, KeySym k)
{
    Cvo_ExternalRegistration *dh = new Cvo_ExternalRegistration(this, e, m, k, f, d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

Cvo_Registration *
Cvo_Object::RegisterKey(KeySym k, CARD16 m, Cvo_ExtEvFunc f, void *d)
{
    Cvo_ExternalRegistration *dh = new Cvo_ExternalRegistration(this,KeyPress,m,k,f,d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

void
Cvo_Object::AddRegistrationReference(Cvo_Registration *r)
{
    Cvo_RegReferences *rf = new Cvo_RegReferences;
    rf->reg = r;
    rf->next = regreferences;
    regreferences = rf;
}

void
Cvo_Object::RemoveRegistrationReference(Cvo_Registration *r)
{
    Cvo_RegReferences *rf = regreferences;
    Cvo_RegReferences *lrf = 0;

    while (rf && rf->reg != r) {
	lrf = rf;
	rf = rf->next;
    }

    if (rf) {
	if (lrf)
	    lrf->next = rf->next;
	else
	    regreferences = rf->next;
	delete rf;
    }
}

void
Cvo_Object::_PassOnSelectMask(CARD32 /* newmask */)
{   CVO_ENTER
//
//  XXX -
//  Currently I am going to NOP this, but leave the calls to it in.
//  This is to allow selecting events on the window created by the
//  window manager.  Since I am not sure we want to do that, I am
//  taking it out for now.
//
//  if (PWin() && ((newmask & selectMask) & PASSON)) {
//	XSelectInput(Dpy(), PWin(), (PASSON & selectMask & newmask));
//  }
    CVO_VOID_RETURN
}

void
Cvo_Object::_AddSelectMask(CARD32 newmask)
{   CVO_ENTER
    if ((newmask & selectMask) != newmask) {
	selectMask |= newmask;
	if (Object()) {
	    XSelectInput(Dpy(), Object(), selectMask);
	    _PassOnSelectMask(newmask);
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::EventHandler(XEvent *ev)
{   CVO_ENTER
    CARD16 state;
    CARD32 key_button;
    CARD32 event = ev->type & Cvo_EventMask;

    if (event < 0 || event > Cvo_MaxEvent ||
        !registration || !registration[event]) {
        CVO_VOID_RETURN
    }

    switch (event) {
    case ButtonPress: {
	//
	// On a button press we must look to see if the application
	// wants to recieve motion events while this button is down.
	// If so, change the grab to contain PointerMotionMask events
	//
	Cvo_Registration *reg = registration[MotionNotify];
	while (reg) {
	    if (reg->Type() == MotionNotify && 
		(reg->State() & (1 << (ev->xbutton.button + 7)))) {

		XChangeActivePointerGrab(Dpy(),
					 (unsigned int)(ButtonPressMask |
							ButtonReleaseMask |
							PointerMotionMask),
					 None, CurrentTime);
		break;
	    }
	    reg = reg->Next();
	}
      }
    case ButtonRelease:
        state = ev->xbutton.state;
        state |= 1 << (ev->xbutton.button + 7);
        key_button = ((_Cvo_XButtonEvent *)ev)->count;
        break;
    case MotionNotify: {
	//
	// Squeeze out extra MotionNotify events that follow this one and
	// have already been read.  This still allows events through, but
	// will reduce the count some what
	//
	XEvent nev;
	while (QLength(Dpy()) > 0 && XPeekEvent(Dpy(), &nev) &&
	       nev.type == ev->type && ev->xmotion.state == nev.xmotion.state) {
	    XNextEvent(Dpy(), ev);
	}
        state = ev->xmotion.state;
        key_button = 0;
        break;
      }
    case CvoKeyTextEvent: {
	Cvo_KeyTextEvent *kte = (Cvo_KeyTextEvent *)ev;
        state = kte->state;
	key_button = kte->have_sym ? kte->keysym : XK_VoidSymbol;
	break;
      }
    case KeyPress:
    case KeyRelease:
        //
        // XXX -
        // We really do not want index 1 on a CapsLock, it depends
        // on what key is pressed.  For instance, a -> A but 1 stays
        // at 1.  Oh well.
        //
        state = ev->xkey.state;

	//
	// If the keycode is set to 0, then this is probably came from
	// an X input method.  Set it to XK_VoidSymbol so that it will
	// match a default "any key" translation.
	//
	if (!ev->xkey.keycode)
	    key_button = XK_VoidSymbol;
	else {
	    key_button = (CARD32)XKeycodeToKeysym(Dpy(),
		       ev->xkey.keycode,
		       ((ev->xkey.state&(ShiftMask|LockMask)) ? 1
					  : 0));
	    if (key_button == (CARD32)NoSymbol)
		key_button = (CARD32)XKeycodeToKeysym(Dpy(),
					     ev->xkey.keycode,
				      0);
	}
        break;
    case EnterNotify:
    case LeaveNotify:
        state = ev->xbutton.state;
        key_button = 0;
        break;
    default:
        state = 0;
        key_button = 0;
        break;
    }
    registration[event & Cvo_EventMask]->Handler(ev, state, key_button);
    CVO_VOID_RETURN
}

Cvo_Registration::Cvo_Registration(Cvo_Object *win,
				   CARD32 _event,
				   CARD16 _mask,
				   KeySym _key)
{
    deletedp = 0;
    object = win;
    mask = _mask;
    type = int(_event);
    key_button = 0;

    //
    // First disect the incoming event into its components
    //
    switch (_event & Cvo_EventMask) {
    case CvoKeyTextEvent:
	//
	// We need to produce the Cvo KeyTextEvent event, which involves
	// an XwcLookupString, which is why we keep track of it here.
	// If the application does not ask for a KeyTextEvent then we
	// do not have to do the XwcLookupString.
	//
	if (!win->input_context)
	    win->NeedInputContext();
	win->dokeytext = True;
        state = (CARD16)((_event & 0x00ffff00) >> 8);
        state = ((state & 0xff) << 8) | ((state >> 8) & 0xff);
        key_button = _key;
        mask |= state;
        mask &= 0xffff;

	win->_AddSelectMask(KeyPressMask);

	break;
    case ButtonPress:
    case ButtonRelease:
        state = (CARD16)((_event & 0x00ffff00) >> 8);
        state = ((state & 0xff) << 8) | ((state >> 8) & 0xff);
        if ((_event >> 24) & 7)
            state |= (CARD16)(1 << (((_event>>24) & 7) + 7));
	key_button = (_event >> ButtonCountShift) & 0xf;

        mask |= state;
        mask &= 0xffff;

        break;
    case MotionNotify:
        state = (CARD16)((_event & 0x00ffff00) >> 8);
        state = ((state & 0xff) << 8) | ((state >> 8) & 0xff);
        if ((_event >> 24) & 7)
            state |= (CARD16)(1 << (((_event>>24) & 7) + 7));
	key_button = 0;

        mask |= state;
        mask &= 0xffff;

        break;
    case KeyPress:
    case KeyRelease:
        state = (CARD16)((_event & 0x00ffff00) >> 8);
        state = ((state & 0xff) << 8) | ((state >> 8) & 0xff);
        key_button = _key;
        mask |= state;
        mask &= 0xffff;
        break;
    case EnterNotify:
    case LeaveNotify:
        state = (CARD16)((_event & 0x00ffff00) >> 8);
        state = ((state & 0xff) << 8) | ((state >> 8) & 0xff);
        key_button = 0;

        mask |= state;
        mask &= 0xffff;
        break;
    default:
        mask = 0;
        key_button = 0;
        state = 0;
        break;
    }

    _event &= Cvo_EventMask;

    if (_event < InternalEvent0)
        type = int(_event);

    if (_event > Cvo_MaxEvent) {
        Cvo_Failure(CvoE_WARN, CvoE_BADEVENT,
		    "%d is an invalid event number\n", _event);
	object = 0;
	CVO_VOID_RETURN
    }

    //
    // Deal with special case Cvo Events which actually need an X Event
    // to be triggered.
    //
    switch (type) {
    case CvoMovedEvent:
    case CvoResizeEvent:
	win->_AddSelectMask(StructureNotifyMask);

	break;
    }

    if (EventTypes[_event] != NoEventMask)
	win->_AddSelectMask(EventTypes[_event]);

    dependents = 0;

    switch (type & Cvo_EventMask) {
    case ButtonRelease:
    case ButtonPress:
	if (win->maxbuttoncnt < key_button)
	    win->maxbuttoncnt = int(key_button);
	    
    }

    _event &= Cvo_EventMask;

    if (!win->registration)
        win->registration = AllocateArray();

    rootp = &(win->registration[_event]);
    if (!win->registration[_event]) {
        next = 0;
        prev = this;
        *rootp = this;
        CVO_VOID_RETURN
    }

    prev = (*rootp)->prev;
    prev->next = this;
    next = 0;
    (*rootp)->prev = this;
    CVO_VOID_RETURN
}

Cvo_Registration **Cvo_Registration::freelist = 0;

Cvo_Registration **
Cvo_Registration::AllocateArray()
{   CVO_ENTER
    Cvo_Registration **ret;

    if (freelist) {
	ret = freelist;
	freelist = *(Cvo_Registration ***)freelist;
    } else {
	static int cnt = 0;
	if (_printoptimize) {
	    fprintf(_printoptimize, "Cvo_RegistrationArray ___reg%d;\n", cnt++);
	    fflush(_printoptimize);
	}
        ret = new Cvo_Registration * [Cvo_MaxEvent+1];
    }
    memset(ret, 0, sizeof(Cvo_Registration *) * (Cvo_MaxEvent+1));
    CVO_RETURN(ret)
}

Cvo_Registration::~Cvo_Registration()
{   CVO_ENTER

    if (deletedp)
	*deletedp = True;
    object = 0;

    if (this == *rootp) {
        *rootp = next;
        if (next)
            next->prev = prev;
    } else if (this == (*rootp)->prev) {
        (*rootp)->prev = prev;
        prev->next = 0;
    } else {
        prev->next = next;
        next->prev = prev;
    }

    while (dependents) {
	Cvo_RegDependents *rd = dependents->next;
	dependents->object->RemoveRegistrationReference(this);
	delete dependents;
	dependents = rd;
    }

    CVO_DONE
}

void
Cvo_Registration::AddDependent(Cvo_Object *obj)
{
    Cvo_RegDependents *rd = new Cvo_RegDependents;
    rd->object = obj;
    rd->next = dependents;
    dependents = rd;
    obj->AddRegistrationReference(this);
}

void
Cvo_Registration::MoveUp(Cvo_Registration *other)
{   CVO_ENTER
    if (!other)
	other = *rootp;

    if (   this == other
	|| other->object != object)
	CVO_VOID_RETURN

    if (this == (*rootp)->prev) {
	(*rootp)->prev = prev;
	prev->next = 0;
    } else {
	prev->next = next;
	next->prev = prev;
    }

    next = other;
    prev = other->prev;
    other->prev = this;
    if (other == *rootp) {
	*rootp = this;
    } else {
	prev->next = this;
    }
    CVO_VOID_RETURN
}

void
Cvo_Registration::Handler(XEvent *ev, CARD16 _state, CARD32 _key_button)
{   CVO_ENTER
    Cvo_Registration *r = this;

    BOOL *odeletedp = deletedp;
    BOOL deleted = False;	// This gets set True when I am deleted
    deletedp = &deleted;

    while (!deleted && r) {
        if (   (ev->type == r->type)
            && (_state & r->mask) == r->state
	    && (   r->key_button == XK_VoidSymbol
		|| _key_button == r->key_button)) {
	    r->event = ev;

	    BOOL *rodeletedp = r->deletedp;
	    BOOL rdeleted = False;
	    r->deletedp = &rdeleted;

	    r->function();

	    if (rdeleted) {
	    	if (r == this)
		    return;
		break;
	    } else
		r->deletedp = rodeletedp;

	    if (deleted || !ev->type)
		break;
        }
	r = r->next;
    }
    if (!deleted)
	deletedp = odeletedp;
    CVO_VOID_RETURN
}

Cvo_ExternalRegistration::Cvo_ExternalRegistration(Cvo_Object *win,
						   CARD32 _type,
						   CARD16 _mask,
						   KeySym _key,
						   Cvo_ExtEvFunc _func,
						   void *_data)
		        : Cvo_Registration(win, _type, _mask, _key)
{
    func = _func;
    data = _data;
}

void
Cvo_ExternalRegistration::function()
{
    (*func)(object, event, data);
}

Cvo_OneTimeRegistration::Cvo_OneTimeRegistration(Cvo_Object *win,
                            CARD32 _type,
                            Cvo_ExtEvFunc _func,
                            void *_data)
	: Cvo_ExternalRegistration(win, _type, 0, XK_VoidSymbol, _func, _data)
{
	;
}

void
Cvo_OneTimeRegistration::function()
{
    Cvo_ExternalRegistration::function();
    delete this;
}


Cvo_InternalRegistration::Cvo_InternalRegistration(Cvo_Object *win,
						   CARD32 _type,
						   CARD16 _mask,
						   KeySym _key,
						   Cvo_EvFunc _func,
						   void *_data)
		        : Cvo_Registration(win, _type, _mask, _key)
{
    func = _func;
    data = _data;
}

void
Cvo_InternalRegistration::function()
{
    (object->*func)(event, data);
}


//
// These next 4 routines are depricated.  They should be
// removed, but lots of code currently uses them.
//
Cvo_Registration *
Cvo_RegisterKey(Cvo_Object *w, KeySym k, CARD16 m, Cvo_ExtEvFunc f, void *d)
{
    Cvo_ExternalRegistration *dh = new Cvo_ExternalRegistration(w, KeyPress, m, k, f, d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

Cvo_Registration *
Cvo_Register(Cvo_Object *w, CARD32 e, CARD16 m, Cvo_ExtEvFunc f,
	     void *d, KeySym k)
{
    Cvo_ExternalRegistration *dh = new Cvo_ExternalRegistration(w, e, m, k, f, d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

Cvo_Registration *
Cvo_RegisterKey(Cvo_Object *w, KeySym k, Cvo_ExtEvFunc f, void *d)
{
    Cvo_ExternalRegistration *dh = new Cvo_ExternalRegistration(w, KeyPress, 0, k, f, d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}

Cvo_Registration *
Cvo_Register(Cvo_Object *w, CARD32 e, Cvo_ExtEvFunc f, void *d, KeySym k)
{
    Cvo_ExternalRegistration *dh = new Cvo_ExternalRegistration(w, e, 0, k, f, d);
    if (!dh->Registered()) {
	delete dh;
	return(0);
    } else
	return(dh);
}
