//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: PopupLayout.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <string.h>

int
Cvo_LayoutWindow::PopupLayoutFunction(int force, int, int, int)
{   CVO_ENTER
    if (force == -1)
	CVO_RETURN(CvoL_FOREWARD)

    int nw = width;
    int nh = height;
    //
    // If rokay is set then it is okay to resize this window to accommodate
    // the default sizes of our children.  If not, we will not resize ourself
    // and we will try to fit our children into the allocated space.
    // We turn this on if we currently have no size or we have not been
    // created yet.
    //
    // The missing arugment is the "child" argument, which has no meaning
    // for a TopLevel Object.
    //
    // Force is set to some combination of Cvo_FORCE_MINIMUM_WIDTH and
    // Cvo_FORCE_MINIMUM_HEIGHT, which do what you think.  It is silly
    // to set this and not rokay, but someone may choose to do that.
    // 
    // Olay is which overlay we are currently working on.
    //
    // The last two arguments are normally the width and height of the area
    // allocated for this Object.  Since this concept has no meaning for a
    // TopLevel Object, we ignore them.
    //

    //
    // If we have no width or height specified, start with the default
    // size for ourself.  Note that this may still be 0 if not was given.
    //
    if (!nw || !nh) {
        force |= 1;
        Cvo_FrameSize m, d;

        ComputeUserSizes(m, d);
        nw = d.width;
        nh = d.height;
    }

    //
    // Now we are ready to compute the potential size of ourself and of
    // all our children.  This will establish min/des/max sizes for us
    // and all our children.
    //
    ComputeLayoutSize(force);

    //
    // Okay, if we are allowed to resize ourself, (i.e. we were not resized
    // by the user) calculate what size we should be.
    // Also, we move ourself to where we are supposed to be on the screen.
    // If we are already there, the MoveWindow() request will do nothing
    // so it is safe to always call it.
    //
    if (force) {
	int mnw = layout.minimum.width - 2 * (borderWidth +
					      horizontalPad) - raise;
	int mnh = layout.minimum.height - 2 * (borderWidth +
					       verticalPad) - raise;
	int dsw = layout.desired.width - 2 * (borderWidth +
					      horizontalPad) - raise;
	int dsh = layout.desired.height - 2 * (borderWidth +
					       verticalPad) - raise;
	int mxw = layout.maximum.width;
	int mxh = layout.maximum.height;

	if (mxw)
	    mxw -= 2 * (borderWidth + horizontalPad) + raise;
	if (mxh)
	    mxh -= 2 * (borderWidth + verticalPad) + raise;

	if (!nw)
	    nw = dsw;
	if (!nh)
	    nh = dsh;

	if (mxw && mxw < nw)
	    nw = mxw;
	if (mxh && mxh < nh)
	    nh = mxh;

        if (force & Cvo_FORCE_DESIRED_WIDTH)
            nw = dsw;
        if (force & Cvo_FORCE_DESIRED_HEIGHT)
            nh = dsh;

	if (nw < mnw || (force & Cvo_FORCE_MINIMUM_WIDTH))
	    nw = mnw;
	if (nh < mnh || (force & Cvo_FORCE_MINIMUM_HEIGHT))
	    nh = mnh;

#define SHei    HeightOfScreen(DefaultScreenOfDisplay(Dpy()))
#define SWid    WidthOfScreen(DefaultScreenOfDisplay(Dpy()))
    
	ToXExtCoord(&layout.x, &layout.y);

	if (layout.y + nh + 2 * (borderWidth + verticalPad) > SHei)
	    layout.y = SHei - (nh + 2 * (borderWidth + verticalPad));

	if (layout.x + nw + 2 * (borderWidth + horizontalPad) > SWid)
	    layout.x = SWid - (nw + 2 * (borderWidth + horizontalPad));

	if (layout.y < 0)
	    layout.y = 0;

	if (layout.x < 0)
	    layout.x = 0;

	FromXExtCoord(&layout.x, &layout.y);
	MoveResizeWindow(layout.x, layout.y, nw, nh, Cvo_LAYOUTTAG);
    } else {
	ToXExtCoord(&layout.x, &layout.y);

	if (layout.y + XHeight() > SHei)
	    layout.y = SHei - XHeight();

	if (layout.x + XWidth() > SWid)
	    layout.x = SWid - XWidth();

	if (layout.y < 0)
	    layout.y = 0;

	if (layout.x < 0)
	    layout.x = 0;

	FromXExtCoord(&layout.x, &layout.y);
	MoveWindow(layout.x, layout.y, Cvo_LAYOUTTAG);
    }

    //
    // Okay, now we are ready to call the function to layout our children.
    // Our size has been fixed, as it alway must be prior to calling
    // the LayoutChildren method.
    //
    for (int o = 0; o < Cvo_NOVERLAYS; ++o)
	LayoutChildren(force, o);
    CVO_RETURN(CvoL_FOREWARD)
}
