//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Pin.cc,v 1.6 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Pin.h++>
#include <Cvo/pin.h>

static Cvo_Default defs[] = {
	"*CvoPin.Chamfer:0",
	"*CvoPin.BorderWidth:0",
	"*CvoPin.Pad:0",
	"*CvoPin.Cursor:Top Left Arrow",
};

CVO_BEGIN_BIND(Cvo_Pin)
CVO_DOBIND(Cvo_Pin, "Enter",    Enter)
CVO_DOBIND(Cvo_Pin, "Leave",    Leave)
CVO_END_BIND(Cvo_Pin, Cvo_BasicButton)

static char *trans = "\
    <EnterWindow>: Enter()\n\
    <LeaveWindow>: Leave()\n\
";

CONSTRUCTORS(Cvo_Pin, Cvo_BasicButton, "CvoPin")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Pin)

void
Cvo_Pin::_Init()
{   CVO_ENTER
    type = CvoT_Pin;
    pushed = 0;
    chamfer = 0;
    moat = 0;
    moatChamfer = 0;
    moatEdge = 0;
    horizontalPad = 0;
    verticalPad = 0;
    AddTranslations(trans);
    SetMaxPixelSize(_cvo_pin_width, _cvo_pin_height);
    Register(Expose, &Cvo_Pin::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_Pin::LocalDown(XEvent *, int, char **)
{   CVO_ENTER
    oldpushed = pushed;
    pushed ^= 1;
    GrabPointerForSelf(EnterWindowMask | LeaveWindowMask);
    ExposureHandler();
    Flush();

    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_Pin::LocalUp(XEvent *, int, char **)
{   CVO_ENTER
    UngrabPointer();
    if (pushed != oldpushed) {
	Cvo_ButtonEvent bev;
	bev.value = pushed;
	bev.button = 0;

	SendEvent(pushed ? CvoButtonDownEvent : CvoButtonUpEvent, &bev);
    }
    CVO_VOID_RETURN
}

void
Cvo_Pin::Enter(XEvent *, int, char **)
{   CVO_ENTER
    if (cnt > 0) {
	pushed ^= 1;
	ExposureHandler();
	Flush();
    }
    CVO_VOID_RETURN
}

void
Cvo_Pin::Leave(XEvent *, int, char **)
{   CVO_ENTER
    if (cnt > 0) {
	pushed ^= 1;
	ExposureHandler();
	Flush();
    }
    CVO_VOID_RETURN
}

static Cvo_Atom uina;
static Cvo_Atom uouta;
static Cvo_Atom lina;
static Cvo_Atom louta;

#define	UINA	DisplayData()[uina]
#define	UOUTA	DisplayData()[uouta]
#define	LINA	DisplayData()[lina]
#define	LOUTA	DisplayData()[louta]

void
Cvo_Pin::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    if (!Object())
        CVO_VOID_RETURN

    if (Atom(uina) == Atom(-1)) {
	uina = "upper_pin_in";
	uouta = "upper_pin_out";
	lina = "lower_pin_in";
	louta = "lower_pin_out";
    }

    if (!long(UINA)) {
	UINA = XCreatePixmapFromBitmapData(Dpy(), Root(),
					   (char*)in_light_bits,
					   _cvo_pin_width, _cvo_pin_height,
					   1, 0, 1);

	LINA = XCreatePixmapFromBitmapData(Dpy(), Root(),
					   (char*)in_dark_bits,
					   _cvo_pin_width, _cvo_pin_height,
					   1, 0, 1);

	UOUTA = XCreatePixmapFromBitmapData(Dpy(), Root(),
					    (char*)out_light_bits,
					    _cvo_pin_width, _cvo_pin_height,
					    1, 0, 1);

	LOUTA = XCreatePixmapFromBitmapData(Dpy(), Root(),
					    (char*)out_dark_bits,
					    _cvo_pin_width, _cvo_pin_height,
					    1, 0, 1);
    }

    ClearArea(0, 0, Width(), Height(), False);

    SetFillStyle(FillStippled);
    if (pushed) {
	SetForegroundOnly(CurrentBackground()->Upper());
	SetStipple(UINA);
	FillRectangle(0, 0, Width(), Height());

	SetForegroundOnly(CurrentBackground()->Lower());
	SetStipple(LINA);
	FillRectangle(0, 0, Width(), Height());
    } else {
	SetForegroundOnly(CurrentBackground()->Upper());
	SetStipple(UOUTA);
	FillRectangle(0, 0, Width(), Height());

	SetForegroundOnly(CurrentBackground()->Lower());
	SetStipple(LOUTA);
	FillRectangle(0, 0, Width(), Height());
    }
    CVO_VOID_RETURN
}
