//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: OptionMenu.cc,v 1.13 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/OptionMenu.h++>
#include <string.h>

static Cvo_Default defs[] = {
    "*CvoOptionMenu.option_dimple.Chamfer: 2",
    "*CvoOptionMenu.Cursor:Top Left Arrow",
    "*CvoOptionMenu.Pad:2",
    "*CvoOptionMenu.Etched: True",
    "*CvoOptionMenu.FontWeight:Bold",
    "*CvoOptionMenuMenu.LayoutPad: 0",
    "*CvoOptionMenuMenu.InternalPad: 0",
};

static char *trans = "\
    <ButtonPress>: Press()\n\
    <ButtonRelease>: Release()\n\
";


CONSTRUCTORS_1ARG(Cvo_OptionMenu, Cvo_Window, "CvoOptionMenu", Cvo_MenuItem *)

CVO_BEGIN_BIND(Cvo_OptionMenu)
CVO_DOBIND(Cvo_OptionMenu, "Press", Down)
CVO_DOBIND(Cvo_OptionMenu, "Release", Down)
CVO_END_BIND(Cvo_OptionMenu, Cvo_Window)


void
Cvo_OptionMenu::_Init(Cvo_MenuItem *mi)
{   CVO_ENTER
    type = CvoT_Button;
    LoadFont();
    this->HorizontalChildren();

    dimple = new Cvo_Window("option_dimple", this);
    dimple->LayOpposite();

    int ow = TextAttribute()->MHeight();
    dimple->SetMinPixelSize(ow, ow/2);
    dimple->SetMaxPixelSize(ow, ow/2);

    menu = new Cvo_Menu("menu", "CvoOptionMenuMenu", Cvo_MAINWINDOW, mi);
    menu->Owner(this);
    Cvo_MenuEntry *ml = menu->MenuEntries();

    //
    // This bit of weirdness is to make sure the MenuLabel reads the same
    // resources as that are read when it is created on the Menu itself.
    //
    if (ml) {
	mb = new Cvo_MenuLabel(ml->label->Name(), menu, (char *)0, ml->flags|CvoM_ALWAYSFLAT);
	mb->Reparent(this);
    } else
	mb = new Cvo_MenuLabel(" ", this, (char *)0, CvoM_ALWAYSFLAT);

    menu->CreateAll();

    current = 0;

    mwidth = 0;
    while (ml) {
	ml->SetInternalFunc(_Cvo_OptionMenu_Handler);
	if (ml->label->Width() > mwidth) {
	    mwidth = ml->label->Width();
	}
	ml = ml->next;
    }

    mb->SetMaxPixelSize(mwidth, 0);
    mb->SetMinPixelSize(mwidth, 0);
    menu->Register(CvoNewMenuItemEvent,
		   _Cvo_OptionMenu_NewItem, this)->AddDependent(this);
    AddTranslations(trans);
    MakeCurrent(menu->MenuEntries());
    CVO_VOID_RETURN
}

void
_Cvo_OptionMenu_NewItem(Cvo_Object *, XEvent *ev, void *vom)
{   CVO_ENTER
    Cvo_OptionMenu *om = (Cvo_OptionMenu *)vom;
    Cvo_NewMenuItemEvent *nmie = (Cvo_NewMenuItemEvent *)ev;
    Cvo_MenuEntry *ml = nmie->item;
    Cvo_MenuLabel *mb = om->mb;

    ml->SetInternalFunc(_Cvo_OptionMenu_Handler);
    ml->label->CreateAll();

    if (ml->label->Width() > om->mwidth) {
    	om->mwidth = ml->label->Width();
	mb->SetMaxPixelSize(om->mwidth, 0);
	mb->SetMinPixelSize(om->mwidth, 0);
	Cvo_Object *obj = om;
	while (obj->Parent() && obj->Parent()->ToLayoutWindow())
	    obj = obj->Parent();
	obj->ToLayoutWindow()->ReLayout(1);
    }
    CVO_VOID_RETURN
}

void
Cvo_OptionMenu::Down(XEvent *ev, int, char **)
{   CVO_ENTER
    if (!Sensitive()) {
	CVO_VOID_RETURN
    }

    Cvo_Window *win = current ? current->label : menu->MenuEntries()->label;

    if (ev->type == ButtonPress && ev->xbutton.x > win->Width()) {
	CVO_VOID_RETURN;
    }
    int x, y;
    int cx, cy;

    XOrigin(&x, &y);

    mb->XOrigin(&cx, &cy);

    x += cx;
    y += cy;

    win->XOrigin(&cx, &cy);
    y -= cy;
    x -= win->BorderWidth();
    y += Chamfer();
    x += Chamfer();

    if (Parent()) {
	Window child;
        XTranslateCoordinates(Dpy(), Parent()->Win(), Root(),
                              x, y, &x, &y, &child);
    }

    if (current) {
	menu->Current() = current;
	win->Unflatten();
	win->Redraw();
    }

    menu->Start(ev->type == ButtonRelease ? 0 : 1, x, y);
    CVO_VOID_RETURN
}

void
Cvo_OptionMenu::MakeCurrent(Cvo_MenuEntry *ml, BOOL call)
{   CVO_ENTER
    if (current = ml) {
	Cvo_CharacterBuffer cb;
	((Cvo_MenuLabel *)current->label)->GetText(cb);
	mb->SetText(cb.wcValue());
	mb->SetMinPixelSize(mwidth, 0);
	mb->SetMaxPixelSize(mwidth, 0);
	if (call && ml->func) {
	    Cvo_Object *w = RootObject();

	    Cvo_MenuEvent me;
	    me.menu = menu;
	    me.item = ml;
	    me.type = CvoMenuEvent;
	    me.serial = 0;
	    me.send_event = True;
	    me.display = w->Dpy();
	    me.window = w->Win();
	    me.win = w;

	    ml->func(w, (XEvent *)&me, ml->data);
	}
    }
    CVO_VOID_RETURN
}

void
_Cvo_OptionMenu_Handler(Cvo_Object *, XEvent *ev, void *)
{   CVO_ENTER
    Cvo_MenuEvent *me = (Cvo_MenuEvent *)ev;
    Cvo_OptionMenu *om = (Cvo_OptionMenu *)me->menu->Owner();

    if (om->current != me->item) {
	Cvo_CharacterBuffer cb;
	om->current = me->item;
	((Cvo_MenuLabel *)om->current->label)->GetText(cb);
	om->mb->SetText(cb.wcValue());
	om->mb->SetMinPixelSize(om->mwidth, 0);
	om->mb->SetMaxPixelSize(om->mwidth, 0);
    }
    CVO_VOID_RETURN
}
