//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Move.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>

#define	SETUP_RE(_w, _h) \
	Cvo_ResizeEvent re; \
	re.old_width = width; \
	re.old_height = height; \
	width = _w; \
	height = _h;

#define	SEND_RE(_t) \
	if (!sentresize || re.old_width != width || re.old_height != height) { \
	    sentresize = True; \
	    re.tag = _t; \
	    re.new_width = width; \
	    re.new_height = height; \
	    SendEvent(CvoResizeEvent, &re); \
	}

#define	SETUP_ME(_x, _y) \
	Cvo_MovedEvent me; \
	Origin(&me.old_x, &me.old_y); \
	SetPosition(_x, _y);

#define	SEND_ME(_t) \
	if (!sentmoved || me.old_x != position.x || me.old_y != position.y) { \
	    sentmoved = True; \
	    me.tag = _t; \
	    Origin(&me.new_x, &me.new_y); \
	    SendEvent(CvoMovedEvent, &me); \
	}

#define	DOQUE() \
	if (!Parent()) \
	    _Cvo_QueueConfigure(this, width, height)

void
Cvo_Object::MoveResizeWindow(int x, int y, int w, int h, int tag)
{   CVO_ENTER
    SETUP_ME(x, y)
    SETUP_RE(w, h)
    SetNormalHints(w, h);

    if (Object()) {
	DOQUE();
	XMoveResizeWindow(Dpy(), Object(), x, y, w, h);
    }

    SEND_ME(tag)
    SEND_RE(tag)
    CVO_VOID_RETURN
}

void
Cvo_Object::MoveWindow(int x, int y, int tag)
{   CVO_ENTER
    SETUP_ME(x, y)

    if (Object())
	XMoveWindow(Dpy(), Object(), x, y);

    SEND_ME(tag)
    CVO_VOID_RETURN
}

void
Cvo_Object::ResizeWindow(int w, int h, int tag)
{   CVO_ENTER
    SETUP_RE(w, h)

    SetNormalHints(w, h);
    if (Object()) {
	DOQUE();
	XResizeWindow(Dpy(), Object(), w, h);
    }

    SEND_RE(tag)
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ForceMoveForceResizeWindow(int x, int y, int w, int h, int tag)
{   CVO_ENTER
    int dr = layout.dontresize;
    int dp = layout.dontposition;

    layout.dontresize = 0;
    layout.dontposition = 0;
    MoveResizeWindow(x, y, w, h, tag);
    layout.dontresize = dr;
    layout.dontposition = dp;
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ForceMoveResizeWindow(int x, int y, int w, int h, int tag)
{   CVO_ENTER
    int dp = layout.dontposition;

    layout.dontposition = 0;
    MoveResizeWindow(x, y, w, h, tag);
    layout.dontposition = dp;
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::MoveForceResizeWindow(int x, int y, int w, int h, int tag)
{   CVO_ENTER
    int dr = layout.dontresize;

    layout.dontresize = 0;
    MoveResizeWindow(x, y, w, h, tag);
    layout.dontresize = dr;
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ForceResizeWindow(int w, int h, int tag)
{   CVO_ENTER
    int dr = layout.dontresize;

    layout.dontresize = 0;
    ResizeWindow(w, h, tag);
    layout.dontresize = dr;
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ForceMoveWindow(int x, int y, int tag)
{   CVO_ENTER
    int dp = layout.dontposition;

    layout.dontposition = 0;
    MoveWindow(x, y, tag);
    layout.dontposition = dp;
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ForceMoveWindow(int xc, int yc, int x, int y, int flags, int tag)
{   CVO_ENTER
    int dp = layout.dontposition;

    layout.dontposition = 0;
    MoveWindow(xc, yc, x, y, flags, tag);
    layout.dontposition = dp;
    CVO_VOID_RETURN
}


void
Cvo_LayoutWindow::MoveResizeWindow(int x, int y, int w, int h, int tag)
{   CVO_ENTER
    if (layout.dontposition && layout.dontresize)
	CVO_VOID_RETURN
    if (layout.dontposition) {
	ResizeWindow(w, h, tag);
    } else if (layout.dontresize) {
	MoveWindow(x, y, tag);
    } else {
	positioned = True;

	SETUP_ME(x, y)
	SETUP_RE(w, h)

	h += 2 * horizontalPad;
	w += 2 * verticalPad;
	layout.x = x;
	layout.y = y;
	SetNormalHints(w, h);
	if (parent)
	    ToXExtCoord(&x, &y);

	if (Object()) {
	    DOQUE();
	    XMoveResizeWindow(Dpy(), Object(), x, y, w, h);
	}

	SEND_ME(tag)
	SEND_RE(tag)
    }
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::MoveWindow(int x, int y, int tag)
{   CVO_ENTER
    if (layout.dontposition)
	CVO_VOID_RETURN

    positioned = True;

    SETUP_ME(x, y)                                                          

    layout.usecharpos = False;
    layout.x = x;
    layout.y = y;

    if (parent)
	ToXExtCoord(&x, &y);
    if (Object())
	XMoveWindow(Dpy(), Object(), x, y);

    SEND_ME(tag)

    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::MoveWindow(int xc, int yc, int x, int y, int flags, int tag)
{   CVO_ENTER
    if (layout.dontposition)
	CVO_VOID_RETURN


    positioned = True;
    layout.x = x;
    layout.y = y;
    layout.xchars = xc;
    layout.ychars = yc;
    layout.xnegative = (flags & XNegative) ? True : False;
    layout.ynegative = (flags & YNegative) ? True : False;

    layout.usecharpos = True;

    ComputeLocation();
    x = layout.x;
    y = layout.y;

    SETUP_ME(x, y)

    if (Object()) {
	if (parent)
	    ToXExtCoord(&x, &y);
	XMoveWindow(Dpy(), Object(), x, y);
    }

    SEND_ME(tag)

    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ResizeWindow(int w, int h, int tag)
{   CVO_ENTER
    if (layout.dontresize)
	CVO_VOID_RETURN

    SETUP_RE(w, h)

    h += 2 * horizontalPad;
    w += 2 * verticalPad;
    SetNormalHints(w, h);

    if (Object()) {
	DOQUE();
	XResizeWindow(Dpy(), Object(), w, h);
    }

    SEND_RE(tag)
    CVO_VOID_RETURN
}

void
Cvo_Window::MoveResizeWindow(int x, int y, int w, int h, int tag)
{   CVO_ENTER
    if (layout.dontposition && layout.dontresize)
	CVO_VOID_RETURN
    if (layout.dontposition) {
	ResizeWindow(w, h, tag);
    } else if (layout.dontresize) {
	MoveWindow(x, y, tag);
    } else {
	positioned = True;

	SETUP_ME(x, y)
	SETUP_RE(w, h)

	h += 2 * horizontalPad;
	w += 2 * verticalPad;
	layout.x = x;
	layout.y = y;
	SetNormalHints(w, h);

	if (parent)
	    ToXExtCoord(&x, &y);

	if (shadow)
	    XMoveResizeWindow(Dpy(), shadow, x+raise, y+raise, w, h);
	if (Object()) {
	    DOQUE();
	    XMoveResizeWindow(Dpy(), Object(), x, y, w, h);
	}
	SEND_ME(tag)
	SEND_RE(tag)
    }
    CVO_VOID_RETURN
}

void
Cvo_Window::MoveWindow(int x, int y, int tag)
{   CVO_ENTER
    if (layout.dontposition)
	CVO_VOID_RETURN

    SETUP_ME(x, y)

    positioned = True;
    layout.x = x;
    layout.y = y;
    if (parent)
	ToXExtCoord(&x, &y);
    if (shadow)
	XMoveWindow(Dpy(), shadow, x+raise, y+raise);
    if (Object()) {
	XMoveWindow(Dpy(), Object(), x, y);
    }
    SEND_ME(tag)
    CVO_VOID_RETURN
}

void
Cvo_Window::MoveWindow(int xc, int yc, int x, int y, int flags, int tag)
{   CVO_ENTER
    if (layout.dontposition)
	CVO_VOID_RETURN
    Cvo_LayoutWindow::MoveWindow(xc, yc, x, y, flags, tag);

    if (shadow) {
	x = layout.x;
	y = layout.y;

	if (parent)
	    ToXExtCoord(&x, &y);
	XMoveWindow(Dpy(), shadow, x+raise, y+raise);
    }
    CVO_VOID_RETURN
}

void
Cvo_Window::ResizeWindow(int w, int h, int tag)
{   CVO_ENTER
    if (layout.dontresize)
	CVO_VOID_RETURN

    SETUP_RE(w, h)

    h += 2 * horizontalPad;
    w += 2 * verticalPad;
    SetNormalHints(w, h);

    if (shadow)
	XResizeWindow(Dpy(), shadow, w, h);
    if (Object()) {
	DOQUE();
	XResizeWindow(Dpy(), Object(), w, h);
    }

    SEND_RE(tag)
    CVO_VOID_RETURN
}
