//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: MonoColors.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <string.h>

#define LEVEL0		 0,  0,  0,  0,  8, 16, 12,
#define LEVEL1		 1,  1,  1,  1,  8,  0, 12,
#define LEVEL2		 2,  2,  2,  2,  8,  0, 12,
#define LEVEL3		 3,  3,  3,  3,  8,  0, 12,
#define LEVEL4		 4,  4,  4,  4,  8,  0, 12,
#define LEVEL5		 5,  5,  5,  5,  8,  0, 12,
#define LEVEL6		 6,  6,  6,  6,  8,  0, 12,
#define LEVEL7		 7,  7,  7,  7,  8,  0, 12,
#define LEVEL8		 8,  8,  8,  8,  8,  0, 12,
#define LEVEL9		 9,  9,  9,  9,  8,  0, 14,
#define LEVEL10		10, 10, 10, 10,  8,  0, 14,
#define LEVEL11		11, 11, 11, 11,  8,  0, 14,
#define LEVEL12		12, 12, 12, 12,  8,  0, 14,
#define LEVEL13		13, 13, 13, 13,  8,  0, 14,
#define LEVEL14		14, 14, 14, 14,  8,  0, 14,
#define LEVEL15		15, 15, 15, 15,  8,  0, 14,
#define LEVEL16		16, 16, 16, 16,  8,  0, 14,

#define LEVEL17		17, 17, 17, 17, 21, 19, 17,
#define LEVEL18		18, 18, 18, 18, 19, 22, 18,
#define LEVEL19		19, 19, 19, 19, 18, 17, 19,
#define LEVEL20		20, 20, 20, 20, 17, 21, 20,

#define LEVEL21		21, 21, 21, 21, 21, 23, 21,
#define LEVEL22		22, 22, 22, 22, 23, 22, 22,
#define LEVEL23		23, 23, 23, 23, 22, 24, 23,
#define LEVEL24		24, 24, 24, 24, 24, 21, 24,

static _Cvo_MonoColorDatabase levels[] = {
    { "level0",		LEVEL0 },
    { "level1",		LEVEL1 },
    { "level2",		LEVEL2 },
    { "level3",		LEVEL3 },
    { "level4",		LEVEL4 },
    { "level5",		LEVEL5 },
    { "level6",		LEVEL6 },
    { "level7",		LEVEL7 },
    { "level8",		LEVEL8 },
    { "level9",		LEVEL9 },
    { "level10",	LEVEL10 },
    { "level11",	LEVEL11 },
    { "level12",	LEVEL12 },
    { "level13",	LEVEL13 },
    { "level14",	LEVEL14 },
    { "level15",	LEVEL15 },
    { "level16",	LEVEL16 },
    { "level17",	LEVEL17 },
    { "level18",	LEVEL18 },
    { "level19",	LEVEL19 },
    { "level20",	LEVEL20 },
    { "level21",	LEVEL21 },
    { "level22",	LEVEL22 },
    { "level23",	LEVEL23 },
    { "level24",	LEVEL24 },
};

static _Cvo_MonoColorDatabase colors[] = {
    { "aliceblue",                     240, 255, 248,  16, },
    { "antiquewhite",                  250, 215, 235,  15, },
    { "antiquewhite1",                 255, 219, 239,  15, },
    { "antiquewhite2",                 238, 204, 223,  14, },
    { "antiquewhite3",                 205, 176, 192,  12, },
    { "antiquewhite4",                 139, 120, 131,   8, },
    { "aquamarine",                    127, 212, 255,  12, },
    { "aquamarine1",                   127, 212, 255,  12, },
    { "aquamarine2",                   118, 198, 238,  11, },
    { "aquamarine3",                   102, 170, 205,  10, },
    { "aquamarine4",                    69, 116, 139,   7, },
    { "azure",                         240, 255, 255,  16, },
    { "azure1",                        240, 255, 255,  16, },
    { "azure2",                        224, 238, 238,  14, },
    { "azure3",                        193, 205, 205,  12, },
    { "azure4",                        131, 139, 139,   8, },
    { "beige",                         245, 220, 245,  15, },
    { "bisque",                        255, 196, 228,  14, },
    { "bisque1",                       255, 196, 228,  14, },
    { "bisque2",                       238, 183, 213,  13, },
    { "bisque3",                       205, 158, 183,  11, },
    { "bisque4",                       139, 107, 125,   8, },
    { "black",                         LEVEL0 },
    { "blanchedalmond",                255, 205, 235,  14, },
    { "blue",                            0, 255,   0,   8, },
    { "blue1",                           0, 255,   0,   8, },
    { "blue2",                           0, 238,   0,   7, },
    { "blue3",                           0, 205,   0,   6, },
    { "blue4",                           0, 139,   0,   4, },
    { "blueviolet",                    138, 226,  43,   8, },
    { "brown",                         165,  42,  42,   6, },
    { "brown1",                        255,  64,  64,  10, },
    { "brown2",                        238,  59,  59,   9, },
    { "brown3",                        205,  51,  51,   8, },
    { "brown4",                        139,  35,  35,   5, },
    { "burlywood",                     222, 135, 184,  11, },
    { "burlywood1",                    255, 155, 211,  13, },
    { "burlywood2",                    238, 145, 197,  12, },
    { "burlywood3",                    205, 125, 170,  10, },
    { "burlywood4",                    139,  85, 115,   7, },
    { "cadetblue",                      95, 160, 158,   8, },
    { "cadetblue1",                    152, 255, 245,  13, },
    { "cadetblue2",                    142, 238, 229,  12, },
    { "cadetblue3",                    122, 205, 197,  10, },
    { "cadetblue4",                     83, 139, 134,   7, },
    { "chartreuse",                    127,   0, 255,   8, },
    { "chartreuse1",                   127,   0, 255,   8, },
    { "chartreuse2",                   118,   0, 238,   7, },
    { "chartreuse3",                   102,   0, 205,   6, },
    { "chartreuse4",                    69,   0, 139,   4, },
    { "chocolate",                     210,  30, 105,   8, },
    { "chocolate1",                    255,  36, 127,   9, },
    { "chocolate2",                    238,  33, 118,   9, },
    { "chocolate3",                    205,  29, 102,   7, },
    { "chocolate4",                    139,  19,  69,   5, },
    { "coral",                         255,  80, 127,  11, },
    { "coral1",                        255,  86, 114,  11, },
    { "coral2",                        238,  80, 106,  10, },
    { "coral3",                        205,  69,  91,   9, },
    { "coral4",                        139,  47,  62,   6, },
    { "cornflowerblue",                100, 237, 149,  11, },
    { "cornsilk",                      255, 220, 248,  15, },
    { "cornsilk1",                     255, 220, 248,  15, },
    { "cornsilk2",                     238, 205, 232,  14, },
    { "cornsilk3",                     205, 177, 200,  12, },
    { "cornsilk4",                     139, 120, 136,   8, },
    { "cyan",                            0, 255, 255,   8, },
    { "cyan1",                           0, 255, 255,   8, },
    { "cyan2",                           0, 238, 238,   7, },
    { "cyan3",                           0, 205, 205,   6, },
    { "cyan4",                           0, 139, 139,   4, },
    { "darkgoldenrod",                 184,  11, 134,   6, },
    { "darkgoldenrod1",                255,  15, 185,   8, },
    { "darkgoldenrod2",                238,  14, 173,   8, },
    { "darkgoldenrod3",                205,  12, 149,   7, },
    { "darkgoldenrod4",                139,   8, 101,   5, },
    { "darkgreen",                       0,   0, 100,   3, },
    { "darkkhaki",                     189, 107, 183,   9, },
    { "darkolivegreen",                 85,  47, 107,   5, },
    { "darkolivegreen1",               202, 112, 255,  12, },
    { "darkolivegreen2",               188, 104, 238,  11, },
    { "darkolivegreen3",               162,  90, 205,   9, },
    { "darkolivegreen4",               110,  61, 139,   6, },
    { "darkorange",                    255,   0, 140,   8, },
    { "darkorange1",                   255,   0, 127,   8, },
    { "darkorange2",                   238,   0, 118,   7, },
    { "darkorange3",                   205,   0, 102,   6, },
    { "darkorange4",                   139,   0,  69,   4, },
    { "darkorchid",                    153, 204,  50,   8, },
    { "darkorchid1",                   191, 255,  62,  10, },
    { "darkorchid2",                   178, 238,  58,   9, },
    { "darkorchid3",                   154, 205,  50,   8, },
    { "darkorchid4",                   104, 139,  34,   5, },
    { "darksalmon",                    233, 122, 150,  11, },
    { "darkseagreen",                  143, 143, 188,  10, },
    { "darkseagreen1",                 193, 193, 255,  14, },
    { "darkseagreen2",                 180, 180, 238,  13, },
    { "darkseagreen3",                 155, 155, 205,  11, },
    { "darkseagreen4",                 105, 105, 139,   8, },
    { "darkslateblue",                  72, 139,  61,   6, },
    { "darkslategray",                  47,  79,  79,   4, },
    { "darkslategray1",                151, 255, 255,  13, },
    { "darkslategray2",                141, 238, 238,  12, },
    { "darkslategray3",                121, 205, 205,  10, },
    { "darkslategray4",                 82, 139, 139,   7, },
    { "darkslategrey",                  47,  79,  79,   4, },
    { "darkturquoise",                   0, 209, 206,   7, },
    { "darkviolet",                    148, 211,   0,   7, },
    { "deeppink",                      255, 147,  20,   9, },
    { "deeppink1",                     255, 147,  20,   9, },
    { "deeppink2",                     238, 137,  18,   8, },
    { "deeppink3",                     205, 118,  16,   7, },
    { "deeppink4",                     139,  80,  10,   5, },
    { "deepskyblue",                     0, 255, 191,   8, },
    { "deepskyblue1",                    0, 255, 191,   8, },
    { "deepskyblue2",                    0, 238, 178,   7, },
    { "deepskyblue3",                    0, 205, 154,   6, },
    { "deepskyblue4",                    0, 139, 104,   4, },
    { "dimgray",                       105, 105, 105,   7, },
    { "dimgrey",                       105, 105, 105,   7, },
    { "dodgerblue",                     30, 255, 144,   9, },
    { "dodgerblue1",                    30, 255, 144,   9, },
    { "dodgerblue2",                    28, 238, 134,   8, },
    { "dodgerblue3",                    24, 205, 116,   7, },
    { "dodgerblue4",                    16, 139,  78,   5, },
    { "firebrick",                     178,  34,  34,   7, },
    { "firebrick1",                    255,  48,  48,  10, },
    { "firebrick2",                    238,  44,  44,   9, },
    { "firebrick3",                    205,  38,  38,   8, },
    { "firebrick4",                    139,  26,  26,   5, },
    { "floralwhite",                   255, 240, 250,  16, },
    { "forestgreen",                    34,  34, 139,   5, },
    { "gainsboro",                     220, 220, 220,  14, },
    { "ghostwhite",                    248, 255, 248,  16, },
    { "gold",                          255,   0, 215,   8, },
    { "gold1",                         255,   0, 215,   8, },
    { "gold2",                         238,   0, 201,   7, },
    { "gold3",                         205,   0, 173,   6, },
    { "gold4",                         139,   0, 117,   4, },
    { "goldenrod",                     218,  32, 165,   8, },
    { "goldenrod1",                    255,  37, 193,   9, },
    { "goldenrod2",                    238,  34, 180,   9, },
    { "goldenrod3",                    205,  29, 155,   7, },
    { "goldenrod4",                    139,  20, 105,   5, },
//  { "gray",                          190, 190, 190,  12, },
    { "gray",                          LEVEL8 },
    { "gray0",                           0,   0,   0,   0, },
    { "gray1",                           3,   3,   3,   0, },
    { "gray10",                         26,  26,  26,   2, },
    { "gray100",                       255, 255, 255,  16, },
    { "gray11",                         28,  28,  28,   2, },
    { "gray12",                         31,  31,  31,   2, },
    { "gray13",                         33,  33,  33,   2, },
    { "gray14",                         36,  36,  36,   2, },
    { "gray15",                         38,  38,  38,   2, },
    { "gray16",                         41,  41,  41,   3, },
    { "gray17",                         43,  43,  43,   3, },
    { "gray18",                         46,  46,  46,   3, },
    { "gray19",                         48,  48,  48,   3, },
    { "gray2",                           5,   5,   5,   0, },
    { "gray20",                         51,  51,  51,   3, },
    { "gray21",                         54,  54,  54,   3, },
    { "gray22",                         56,  56,  56,   4, },
    { "gray23",                         59,  59,  59,   4, },
    { "gray24",                         61,  61,  61,   4, },
    { "gray25",                         64,  64,  64,   4, },
    { "gray26",                         66,  66,  66,   4, },
    { "gray27",                         69,  69,  69,   4, },
    { "gray28",                         71,  71,  71,   4, },
    { "gray29",                         74,  74,  74,   5, },
    { "gray3",                           8,   8,   8,   1, },
    { "gray30",                         77,  77,  77,   5, },
    { "gray31",                         79,  79,  79,   5, },
    { "gray32",                         82,  82,  82,   5, },
    { "gray33",                         84,  84,  84,   5, },
    { "gray34",                         87,  87,  87,   5, },
    { "gray35",                         89,  89,  89,   6, },
    { "gray36",                         92,  92,  92,   6, },
    { "gray37",                         94,  94,  94,   6, },
    { "gray38",                         97,  97,  97,   6, },
    { "gray39",                         99,  99,  99,   6, },
    { "gray4",                          10,  10,  10,   1, },
    { "gray40",                        102, 102, 102,   6, },
    { "gray41",                        105, 105, 105,   7, },
    { "gray42",                        107, 107, 107,   7, },
    { "gray43",                        110, 110, 110,   7, },
    { "gray44",                        112, 112, 112,   7, },
    { "gray45",                        115, 115, 115,   7, },
    { "gray46",                        117, 117, 117,   7, },
    { "gray47",                        120, 120, 120,   8, },
    { "gray48",                        122, 122, 122,   8, },
    { "gray49",                        125, 125, 125,   8, },
    { "gray5",                          13,  13,  13,   1, },
    { "gray50",                        127, 127, 127,   8, },
    { "gray51",                        130, 130, 130,   8, },
    { "gray52",                        133, 133, 133,   8, },
    { "gray53",                        135, 135, 135,   8, },
    { "gray54",                        138, 138, 138,   9, },
    { "gray55",                        140, 140, 140,   9, },
    { "gray56",                        143, 143, 143,   9, },
    { "gray57",                        145, 145, 145,   9, },
    { "gray58",                        148, 148, 148,   9, },
    { "gray59",                        150, 150, 150,   9, },
    { "gray6",                          15,  15,  15,   1, },
    { "gray60",                        153, 153, 153,  10, },
    { "gray61",                        156, 156, 156,  10, },
    { "gray62",                        158, 158, 158,  10, },
    { "gray63",                        161, 161, 161,  10, },
    { "gray64",                        163, 163, 163,  10, },
    { "gray65",                        166, 166, 166,  10, },
    { "gray66",                        168, 168, 168,  11, },
    { "gray67",                        171, 171, 171,  11, },
    { "gray68",                        173, 173, 173,  11, },
    { "gray69",                        176, 176, 176,  11, },
    { "gray7",                          18,  18,  18,   1, },
    { "gray70",                        179, 179, 179,  11, },
    { "gray71",                        181, 181, 181,  11, },
    { "gray72",                        184, 184, 184,  12, },
    { "gray73",                        186, 186, 186,  12, },
    { "gray74",                        189, 189, 189,  12, },
    { "gray75",                        191, 191, 191,  12, },
    { "gray76",                        194, 194, 194,  12, },
    { "gray77",                        196, 196, 196,  12, },
    { "gray78",                        199, 199, 199,  12, },
    { "gray79",                        201, 201, 201,  13, },
    { "gray8",                          20,  20,  20,   1, },
    { "gray80",                        204, 204, 204,  13, },
    { "gray81",                        207, 207, 207,  13, },
    { "gray82",                        209, 209, 209,  13, },
    { "gray83",                        212, 212, 212,  13, },
    { "gray84",                        214, 214, 214,  13, },
    { "gray85",                        217, 217, 217,  14, },
    { "gray86",                        219, 219, 219,  14, },
    { "gray87",                        222, 222, 222,  14, },
    { "gray88",                        224, 224, 224,  14, },
    { "gray89",                        227, 227, 227,  14, },
    { "gray9",                          23,  23,  23,   1, },
    { "gray90",                        229, 229, 229,  14, },
    { "gray91",                        232, 232, 232,  15, },
    { "gray92",                        235, 235, 235,  15, },
    { "gray93",                        237, 237, 237,  15, },
    { "gray94",                        240, 240, 240,  15, },
    { "gray95",                        242, 242, 242,  15, },
    { "gray96",                        245, 245, 245,  15, },
    { "gray97",                        247, 247, 247,  15, },
    { "gray98",                        250, 250, 250,  16, },
    { "gray99",                        252, 252, 252,  16, },
    { "green",                           0,   0, 255,   8, },
    { "green1",                          0,   0, 255,   8, },
    { "green2",                          0,   0, 238,   7, },
    { "green3",                          0,   0, 205,   6, },
    { "green4",                          0,   0, 139,   4, },
    { "greenyellow",                   173,  47, 255,   9, },
//  { "grey",                          190, 190, 190,  12, },
    { "grey",                          LEVEL8 },
    { "grey0",                           0,   0,   0,   0, },
    { "grey1",                           3,   3,   3,   0, },
    { "grey10",                         26,  26,  26,   2, },
    { "grey100",                       255, 255, 255,  16, },
    { "grey11",                         28,  28,  28,   2, },
    { "grey12",                         31,  31,  31,   2, },
    { "grey13",                         33,  33,  33,   2, },
    { "grey14",                         36,  36,  36,   2, },
    { "grey15",                         38,  38,  38,   2, },
    { "grey16",                         41,  41,  41,   3, },
    { "grey17",                         43,  43,  43,   3, },
    { "grey18",                         46,  46,  46,   3, },
    { "grey19",                         48,  48,  48,   3, },
    { "grey2",                           5,   5,   5,   0, },
    { "grey20",                         51,  51,  51,   3, },
    { "grey21",                         54,  54,  54,   3, },
    { "grey22",                         56,  56,  56,   4, },
    { "grey23",                         59,  59,  59,   4, },
    { "grey24",                         61,  61,  61,   4, },
    { "grey25",                         64,  64,  64,   4, },
    { "grey26",                         66,  66,  66,   4, },
    { "grey27",                         69,  69,  69,   4, },
    { "grey28",                         71,  71,  71,   4, },
    { "grey29",                         74,  74,  74,   5, },
    { "grey3",                           8,   8,   8,   1, },
    { "grey30",                         77,  77,  77,   5, },
    { "grey31",                         79,  79,  79,   5, },
    { "grey32",                         82,  82,  82,   5, },
    { "grey33",                         84,  84,  84,   5, },
    { "grey34",                         87,  87,  87,   5, },
    { "grey35",                         89,  89,  89,   6, },
    { "grey36",                         92,  92,  92,   6, },
    { "grey37",                         94,  94,  94,   6, },
    { "grey38",                         97,  97,  97,   6, },
    { "grey39",                         99,  99,  99,   6, },
    { "grey4",                          10,  10,  10,   1, },
    { "grey40",                        102, 102, 102,   6, },
    { "grey41",                        105, 105, 105,   7, },
    { "grey42",                        107, 107, 107,   7, },
    { "grey43",                        110, 110, 110,   7, },
    { "grey44",                        112, 112, 112,   7, },
    { "grey45",                        115, 115, 115,   7, },
    { "grey46",                        117, 117, 117,   7, },
    { "grey47",                        120, 120, 120,   8, },
    { "grey48",                        122, 122, 122,   8, },
    { "grey49",                        125, 125, 125,   8, },
    { "grey5",                          13,  13,  13,   1, },
    { "grey50",                        127, 127, 127,   8, },
    { "grey51",                        130, 130, 130,   8, },
    { "grey52",                        133, 133, 133,   8, },
    { "grey53",                        135, 135, 135,   8, },
    { "grey54",                        138, 138, 138,   9, },
    { "grey55",                        140, 140, 140,   9, },
    { "grey56",                        143, 143, 143,   9, },
    { "grey57",                        145, 145, 145,   9, },
    { "grey58",                        148, 148, 148,   9, },
    { "grey59",                        150, 150, 150,   9, },
    { "grey6",                          15,  15,  15,   1, },
    { "grey60",                        153, 153, 153,  10, },
    { "grey61",                        156, 156, 156,  10, },
    { "grey62",                        158, 158, 158,  10, },
    { "grey63",                        161, 161, 161,  10, },
    { "grey64",                        163, 163, 163,  10, },
    { "grey65",                        166, 166, 166,  10, },
    { "grey66",                        168, 168, 168,  11, },
    { "grey67",                        171, 171, 171,  11, },
    { "grey68",                        173, 173, 173,  11, },
    { "grey69",                        176, 176, 176,  11, },
    { "grey7",                          18,  18,  18,   1, },
    { "grey70",                        179, 179, 179,  11, },
    { "grey71",                        181, 181, 181,  11, },
    { "grey72",                        184, 184, 184,  12, },
    { "grey73",                        186, 186, 186,  12, },
    { "grey74",                        189, 189, 189,  12, },
    { "grey75",                        191, 191, 191,  12, },
    { "grey76",                        194, 194, 194,  12, },
    { "grey77",                        196, 196, 196,  12, },
    { "grey78",                        199, 199, 199,  12, },
    { "grey79",                        201, 201, 201,  13, },
    { "grey8",                          20,  20,  20,   1, },
    { "grey80",                        204, 204, 204,  13, },
    { "grey81",                        207, 207, 207,  13, },
    { "grey82",                        209, 209, 209,  13, },
    { "grey83",                        212, 212, 212,  13, },
    { "grey84",                        214, 214, 214,  13, },
    { "grey85",                        217, 217, 217,  14, },
    { "grey86",                        219, 219, 219,  14, },
    { "grey87",                        222, 222, 222,  14, },
    { "grey88",                        224, 224, 224,  14, },
    { "grey89",                        227, 227, 227,  14, },
    { "grey9",                          23,  23,  23,   1, },
    { "grey90",                        229, 229, 229,  14, },
    { "grey91",                        232, 232, 232,  15, },
    { "grey92",                        235, 235, 235,  15, },
    { "grey93",                        237, 237, 237,  15, },
    { "grey94",                        240, 240, 240,  15, },
    { "grey95",                        242, 242, 242,  15, },
    { "grey96",                        245, 245, 245,  15, },
    { "grey97",                        247, 247, 247,  15, },
    { "grey98",                        250, 250, 250,  16, },
    { "grey99",                        252, 252, 252,  16, },
    { "honeydew",                      240, 240, 255,  16, },
    { "honeydew1",                     240, 240, 255,  16, },
    { "honeydew2",                     224, 224, 238,  14, },
    { "honeydew3",                     193, 193, 205,  12, },
    { "honeydew4",                     131, 131, 139,   8, },
    { "hotpink",                       255, 180, 105,  11, },
    { "hotpink1",                      255, 180, 110,  11, },
    { "hotpink2",                      238, 167, 106,  11, },
    { "hotpink3",                      205, 144,  96,   9, },
    { "hotpink4",                      139,  98,  58,   6, },
    { "indianred",                     205,  92,  92,   9, },
    { "indianred1",                    255, 106, 106,  11, },
    { "indianred2",                    238,  99,  99,  11, },
    { "indianred3",                    205,  85,  85,   9, },
    { "indianred4",                    139,  58,  58,   6, },
    { "ivory",                         255, 240, 255,  16, },
    { "ivory1",                        255, 240, 255,  16, },
    { "ivory2",                        238, 224, 238,  14, },
    { "ivory3",                        205, 193, 205,  12, },
    { "ivory4",                        139, 131, 139,   8, },
    { "khaki",                         240, 140, 230,  12, },
    { "khaki1",                        255, 143, 246,  12, },
    { "khaki2",                        238, 133, 230,  12, },
    { "khaki3",                        205, 115, 198,  10, },
    { "khaki4",                        139,  78, 134,   7, },
    { "lavender",                      230, 250, 230,  15, },
    { "lavenderblush",                 255, 245, 240,  16, },
    { "lavenderblush1",                255, 245, 240,  16, },
    { "lavenderblush2",                238, 229, 224,  14, },
    { "lavenderblush3",                205, 197, 193,  12, },
    { "lavenderblush4",                139, 134, 131,   8, },
    { "lawngreen",                     124,   0, 252,   8, },
    { "lemonchiffon",                  255, 205, 250,  14, },
    { "lemonchiffon1",                 255, 205, 250,  14, },
    { "lemonchiffon2",                 238, 191, 233,  13, },
    { "lemonchiffon3",                 205, 165, 201,  12, },
    { "lemonchiffon4",                 139, 112, 137,   8, },
    { "lightblue",                     173, 230, 216,  13, },
    { "lightblue1",                    191, 255, 239,  14, },
    { "lightblue2",                    178, 238, 223,  13, },
    { "lightblue3",                    154, 205, 192,  11, },
    { "lightblue4",                    104, 139, 131,   8, },
    { "lightcoral",                    240, 128, 128,  12, },
    { "lightcyan",                     224, 255, 255,  15, },
    { "lightcyan1",                    224, 255, 255,  15, },
    { "lightcyan2",                    209, 238, 238,  14, },
    { "lightcyan3",                    180, 205, 205,  12, },
    { "lightcyan4",                    122, 139, 139,   8, },
    { "lightgoldenrod",                238, 130, 221,  12, },
    { "lightgoldenrod1",               255, 139, 236,  12, },
    { "lightgoldenrod2",               238, 130, 220,  12, },
    { "lightgoldenrod3",               205, 112, 190,  10, },
    { "lightgoldenrod4",               139,  76, 129,   7, },
    { "lightgoldenrodyellow",          250, 210, 250,  14, },
    { "lightgray",                     211, 211, 211,  13, },
    { "lightgrey",                     211, 211, 211,  13, },
    { "lightpink",                     255, 193, 182,  14, },
    { "lightpink1",                    255, 185, 174,  13, },
    { "lightpink2",                    238, 173, 162,  13, },
    { "lightpink3",                    205, 149, 140,  11, },
    { "lightpink4",                    139, 101,  95,   7, },
    { "lightsalmon",                   255, 122, 160,  12, },
    { "lightsalmon1",                  255, 122, 160,  12, },
    { "lightsalmon2",                  238, 114, 149,  11, },
    { "lightsalmon3",                  205,  98, 129,  10, },
    { "lightsalmon4",                  139,  66,  87,   6, },
    { "lightseagreen",                  32, 170, 178,   7, },
    { "lightskyblue",                  135, 250, 206,  12, },
    { "lightskyblue1",                 176, 255, 226,  14, },
    { "lightskyblue2",                 164, 238, 211,  13, },
    { "lightskyblue3",                 141, 205, 182,  11, },
    { "lightskyblue4",                  96, 139, 123,   7, },
    { "lightslateblue",                132, 255, 112,  12, },
    { "lightslategray",                119, 153, 136,   9, },
    { "lightslategrey",                119, 153, 136,   9, },
    { "lightsteelblue",                176, 222, 196,  12, },
    { "lightsteelblue1",               202, 255, 225,  14, },
    { "lightsteelblue2",               188, 238, 210,  13, },
    { "lightsteelblue3",               162, 205, 181,  12, },
    { "lightsteelblue4",               110, 139, 123,   8, },
    { "lightyellow",                   255, 224, 255,  15, },
    { "lightyellow1",                  255, 224, 255,  15, },
    { "lightyellow2",                  238, 209, 238,  14, },
    { "lightyellow3",                  205, 180, 205,  12, },
    { "lightyellow4",                  139, 122, 139,   8, },
    { "limegreen",                      50,  50, 205,   8, },
    { "linen",                         250, 230, 240,  15, },
    { "magenta",                       255, 255,   0,   8, },
    { "magenta1",                      255, 255,   0,   8, },
    { "magenta2",                      238, 238,   0,   7, },
    { "magenta3",                      205, 205,   0,   6, },
    { "magenta4",                      139, 139,   0,   4, },
    { "maroon",                        176,  96,  48,   7, },
    { "maroon1",                       255, 179,  52,  10, },
    { "maroon2",                       238, 167,  48,   9, },
    { "maroon3",                       205, 144,  41,   8, },
    { "maroon4",                       139,  98,  28,   5, },
    { "mediumaquamarine",              102, 170, 205,  10, },
    { "mediumblue",                      0, 205,   0,   6, },
    { "mediumorchid",                  186, 211,  85,   9, },
    { "mediumorchid1",                 224, 255, 102,  11, },
    { "mediumorchid2",                 209, 238,  95,  10, },
    { "mediumorchid3",                 180, 205,  82,   9, },
    { "mediumorchid4",                 122, 139,  55,   6, },
    { "mediumpurple",                  147, 219, 112,  10, },
    { "mediumpurple1",                 171, 255, 130,  12, },
    { "mediumpurple2",                 159, 238, 121,  11, },
    { "mediumpurple3",                 137, 205, 104,  10, },
    { "mediumpurple4",                  93, 139,  71,   7, },
    { "mediumseagreen",                 60, 113, 179,   7, },
    { "mediumslateblue",               123, 238, 104,  11, },
    { "mediumspringgreen",               0, 154, 250,   8, },
    { "mediumturquoise",                72, 204, 209,   9, },
    { "mediumvioletred",               199, 133,  21,   7, },
    { "midnightblue",                   25, 112,  25,   4, },
    { "mintcream",                     245, 250, 255,  16, },
    { "mistyrose",                     255, 225, 228,  15, },
    { "mistyrose1",                    255, 225, 228,  15, },
    { "mistyrose2",                    238, 210, 213,  14, },
    { "mistyrose3",                    205, 181, 183,  12, },
    { "mistyrose4",                    139, 123, 125,   8, },
    { "moccasin",                      255, 181, 228,  14, },
    { "mono0",			       LEVEL0 },
    { "mono1",			       LEVEL1 },
    { "mono10",			       LEVEL10 },
    { "mono11",			       LEVEL11 },
    { "mono12",			       LEVEL12 },
    { "mono13",			       LEVEL13 },
    { "mono14",			       LEVEL14 },
    { "mono15",			       LEVEL15 },
    { "mono16",			       LEVEL15 },
    { "mono2",			       LEVEL2 },
    { "mono3",			       LEVEL3 },
    { "mono4",			       LEVEL4 },
    { "mono5",			       LEVEL5 },
    { "mono6",			       LEVEL6 },
    { "mono7",			       LEVEL7 },
    { "mono8",			       LEVEL8 },
    { "mono9",			       LEVEL9 },
    { "navajowhite",                   255, 173, 222,  13, },
    { "navajowhite1",                  255, 173, 222,  13, },
    { "navajowhite2",                  238, 161, 207,  13, },
    { "navajowhite3",                  205, 139, 179,  11, },
    { "navajowhite4",                  139,  94, 121,   7, },
    { "navy",                            0, 128,   0,   4, },
    { "navyblue",                        0, 128,   0,   4, },
    { "oldlace",                       253, 230, 245,  15, },
    { "olivedrab",                     107,  35, 142,   6, },
    { "olivedrab1",                    192,  62, 255,  10, },
    { "olivedrab2",                    179,  58, 238,   9, },
    { "olivedrab3",                    154,  50, 205,   8, },
    { "olivedrab4",                    105,  34, 139,   5, },
    { "orange",                        255,   0, 165,   8, },
    { "orange1",                       255,   0, 165,   8, },
    { "orange2",                       238,   0, 154,   7, },
    { "orange3",                       205,   0, 133,   6, },
    { "orange4",                       139,   0,  90,   4, },
    { "orangered",                     255,   0,  69,   8, },
    { "orangered1",                    255,   0,  69,   8, },
    { "orangered2",                    238,   0,  64,   7, },
    { "orangered3",                    205,   0,  55,   6, },
    { "orangered4",                    139,   0,  37,   4, },
    { "orchid",                        218, 214, 112,  10, },
    { "orchid1",                       255, 250, 131,  12, },
    { "orchid2",                       238, 233, 122,  11, },
    { "orchid3",                       205, 201, 105,  10, },
    { "orchid4",                       139, 137,  71,   7, },
    { "palegoldenrod",                 238, 170, 232,  13, },
    { "palegreen",                     152, 152, 251,  13, },
    { "palegreen1",                    154, 154, 255,  13, },
    { "palegreen2",                    144, 144, 238,  12, },
    { "palegreen3",                    124, 124, 205,  10, },
    { "palegreen4",                     84,  84, 139,   7, },
    { "paleturquoise",                 175, 238, 238,  13, },
    { "paleturquoise1",                187, 255, 255,  14, },
    { "paleturquoise2",                174, 238, 238,  13, },
    { "paleturquoise3",                150, 205, 205,  11, },
    { "paleturquoise4",                102, 139, 139,   8, },
    { "palevioletred",                 219, 147, 112,  10, },
    { "palevioletred1",                255, 171, 130,  12, },
    { "palevioletred2",                238, 159, 121,  11, },
    { "palevioletred3",                205, 137, 104,  10, },
    { "palevioletred4",                139,  93,  71,   7, },

    { "pattern0",		       LEVEL17 },
    { "pattern1",		       LEVEL18 },
    { "pattern2",		       LEVEL19 },
    { "pattern3",		       LEVEL20 },
    { "pattern4",		       LEVEL21 },
    { "pattern5",		       LEVEL22 },
    { "pattern6",		       LEVEL23 },
    { "pattern7",		       LEVEL24 },

    { "papayawhip",                    255, 213, 239,  15, },
    { "peachpuff",                     255, 185, 218,  14, },
    { "peachpuff1",                    255, 185, 218,  14, },
    { "peachpuff2",                    238, 173, 203,  13, },
    { "peachpuff3",                    205, 149, 175,  11, },
    { "peachpuff4",                    139, 101, 119,   8, },
    { "peru",                          205,  63, 133,   8, },
    { "pink",                          255, 203, 192,  14, },
    { "pink1",                         255, 197, 181,  14, },
    { "pink2",                         238, 184, 169,  13, },
    { "pink3",                         205, 158, 145,  11, },
    { "pink4",                         139, 108,  99,   7, },
    { "plum",                          221, 221, 160,  12, },
    { "plum1",                         255, 255, 187,  14, },
    { "plum2",                         238, 238, 174,  13, },
    { "plum3",                         205, 205, 150,  11, },
    { "plum4",                         139, 139, 102,   8, },
    { "powderblue",                    176, 230, 224,  13, },
    { "purple",                        160, 240,  32,   9, },
    { "purple1",                       155, 255,  48,  10, },
    { "purple2",                       145, 238,  44,   9, },
    { "purple3",                       125, 205,  38,   8, },
    { "purple4",                        85, 139,  26,   5, },
    { "red",                           255,   0,   0,   8, },
    { "red1",                          255,   0,   0,   8, },
    { "red2",                          238,   0,   0,   7, },
    { "red3",                          205,   0,   0,   6, },
    { "red4",                          139,   0,   0,   4, },
    { "rosybrown",                     188, 143, 143,  10, },
    { "rosybrown1",                    255, 193, 193,  14, },
    { "rosybrown2",                    238, 180, 180,  13, },
    { "rosybrown3",                    205, 155, 155,  11, },
    { "rosybrown4",                    139, 105, 105,   8, },
    { "royalblue",                      65, 225, 105,   9, },
    { "royalblue1",                     72, 255, 118,  10, },
    { "royalblue2",                     67, 238, 110,  10, },
    { "royalblue3",                     58, 205,  95,   8, },
    { "royalblue4",                     39, 139,  64,   6, },
    { "saddlebrown",                   139,  19,  69,   5, },
    { "salmon",                        250, 114, 128,  11, },
    { "salmon1",                       255, 105, 140,  11, },
    { "salmon2",                       238,  98, 130,  11, },
    { "salmon3",                       205,  84, 112,   9, },
    { "salmon4",                       139,  57,  76,   6, },
    { "sandybrown",                    244,  96, 164,  11, },
    { "seagreen",                       46,  87, 139,   6, },
    { "seagreen1",                      84, 159, 255,  11, },
    { "seagreen2",                      78, 148, 238,  10, },
    { "seagreen3",                      67, 128, 205,   9, },
    { "seagreen4",                      46,  87, 139,   6, },
    { "seashell",                      255, 238, 245,  15, },
    { "seashell1",                     255, 238, 245,  15, },
    { "seashell2",                     238, 222, 229,  14, },
    { "seashell3",                     205, 191, 197,  12, },
    { "seashell4",                     139, 130, 134,   8, },
    { "sienna",                        160,  45,  82,   6, },
    { "sienna1",                       255,  71, 130,  10, },
    { "sienna2",                       238,  66, 121,  10, },
    { "sienna3",                       205,  57, 104,   8, },
    { "sienna4",                       139,  38,  71,   6, },
    { "skyblue",                       135, 235, 206,  12, },
    { "skyblue1",                      135, 255, 206,  12, },
    { "skyblue2",                      126, 238, 192,  11, },
    { "skyblue3",                      108, 205, 166,  10, },
    { "skyblue4",                       74, 139, 112,   7, },
    { "slateblue",                     106, 205,  90,   9, },
    { "slateblue1",                    131, 255, 111,  11, },
    { "slateblue2",                    122, 238, 103,  11, },
    { "slateblue3",                    105, 205,  89,   9, },
    { "slateblue4",                     71, 139,  60,   6, },
    { "slategray",                     112, 144, 128,   8, },
    { "slategray1",                    198, 255, 226,  14, },
    { "slategray2",                    185, 238, 211,  13, },
    { "slategray3",                    159, 205, 182,  11, },
    { "slategray4",                    108, 139, 123,   8, },
    { "slategrey",                     112, 144, 128,   8, },
    { "snow",                          255, 250, 250,  16, },
    { "snow1",                         255, 250, 250,  16, },
    { "snow2",                         238, 233, 233,  15, },
    { "snow3",                         205, 201, 201,  13, },
    { "snow4",                         139, 137, 137,   9, },
    { "springgreen",                     0, 127, 255,   8, },
    { "springgreen1",                    0, 127, 255,   8, },
    { "springgreen2",                    0, 118, 238,   7, },
    { "springgreen3",                    0, 102, 205,   6, },
    { "springgreen4",                    0,  69, 139,   4, },
    { "steelblue",                      70, 180, 130,   8, },
    { "steelblue1",                     99, 255, 184,  11, },
    { "steelblue2",                     92, 238, 172,  10, },
    { "steelblue3",                     79, 205, 148,   9, },
    { "steelblue4",                     54, 139, 100,   6, },
    { "tan",                           210, 140, 180,  11, },
    { "tan1",                          255,  79, 165,  10, },
    { "tan2",                          238,  73, 154,  10, },
    { "tan3",                          205,  63, 133,   8, },
    { "tan4",                          139,  43,  90,   6, },
    { "thistle",                       216, 216, 191,  13, },
    { "thistle1",                      255, 255, 225,  15, },
    { "thistle2",                      238, 238, 210,  14, },
    { "thistle3",                      205, 205, 181,  12, },
    { "thistle4",                      139, 139, 123,   8, },
    { "tomato",                        255,  71,  99,  10, },
    { "tomato1",                       255,  71,  99,  10, },
    { "tomato2",                       238,  66,  92,  10, },
    { "tomato3",                       205,  57,  79,   8, },
    { "tomato4",                       139,  38,  54,   6, },
    { "turquoise",                      64, 208, 224,   9, },
    { "turquoise1",                      0, 255, 245,   8, },
    { "turquoise2",                      0, 238, 229,   7, },
    { "turquoise3",                      0, 205, 197,   6, },
    { "turquoise4",                      0, 139, 134,   4, },
    { "violet",                        238, 238, 130,  12, },
    { "violetred",                     208, 144,  32,   8, },
    { "violetred1",                    255, 150,  62,  10, },
    { "violetred2",                    238, 140,  58,   9, },
    { "violetred3",                    205, 120,  50,   8, },
    { "violetred4",                    139,  82,  34,   5, },
    { "wheat",                         245, 179, 222,  13, },
    { "wheat1",                        255, 186, 231,  14, },
    { "wheat2",                        238, 174, 216,  13, },
    { "wheat3",                        205, 150, 186,  11, },
    { "wheat4",                        139, 102, 126,   8, },
    { "white",                         255, 255, 255,  16, 0,  8, 2, },
    { "whitesmoke",                    245, 245, 245,  15, },
    { "yellow",                        255,   0, 255,   8, },
    { "yellow1",                       255,   0, 255,   8, },
    { "yellow2",                       238,   0, 238,   7, },
    { "yellow3",                       205,   0, 205,   6, },
    { "yellow4",                       139,   0, 139,   4, },
    { "yellowgreen",                   154,  50, 205,   8, },
};

static int ncolors = sizeof(colors)/sizeof(_Cvo_MonoColorDatabase);

static _Cvo_MonoColorDatabase white =
    { "white",                         255, 255, 255,  16, 0,  8, 2, };
static _Cvo_MonoColorDatabase black =
    { "black",                           0,   0,   0,   0, 8, 16, 2, };

_Cvo_MonoColorDatabase *
_Cvo_FindMonoColor(int level)
{   CVO_ENTER
    if (level < 0)
	level = 0;
    if (level >= sizeof(levels)/sizeof(_Cvo_MonoColorDatabase))
	level = sizeof(levels)/sizeof(_Cvo_MonoColorDatabase) - 1;
    CVO_RETURN(&levels[level])
}

_Cvo_MonoColorDatabase *
_Cvo_FindMonoColor(char *s, int back)
{   CVO_ENTER
    if (strlen(s) > 31)
	CVO_RETURN(back ? &white : &black)

    char ns[32];
    char *ss = ns;
    while (*s) {
	if (*s == ' ' || *s == '\t')
	    ++s;
	else if (*s >= 'A' || *s <= 'B')
	    *ss++ = *s++ | 040;
	else
	    *ss++ = *s++;
    }
    *ss = 0;

    int lo = 0;
    int hi = ncolors - 1;

    if (!strcmp(ns, colors[lo].name))
	CVO_RETURN(&colors[lo])

    if (!strcmp(ns, colors[hi].name))
	CVO_RETURN(&colors[hi])

    while (hi > lo + 4) {
	int mid = (hi - lo) / 2 + lo;
	int r = strcmp(ns, colors[mid].name);
	if (r == 0)
	    CVO_RETURN(&colors[mid])
	if (r < 0)
	    hi = mid;
	else
	    lo = mid;
    }
    while (++lo < hi) {
	if (!strcmp(ns, colors[lo].name))
	    CVO_RETURN(&colors[lo])
    }
    CVO_RETURN(back ? &white : &black)
}
