//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: MenuBar.cc,v 1.7 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/ButtonMenu.h++>
#include <Cvo/Picture.h++>
#include <string.h>
#include <Cvo/cray_logo.xpm>

static Cvo_Default def[] = {
        "*CvoMenuBar.InternalPad:10",
        "*CvoMenuBar.Cursor:Top Left Arrow",
        "*CvoMenuBar.LayoutPad:0",
        "*CvoMenuBar.InternalPad:0",
        "*CvoMenuBar.Pad:2",
	"*CvoMenuBar.logo.Chamfer:0",
	"*CvoMenuBar.logo.Pad:0",
	"*CvoMenuBar.logo.BorderWidth:0",
};

CONSTRUCTORS_1ARG(Cvo_MenuBar, Cvo_Window, "CvoMenuBar", Cvo_MenuBarList *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_MenuBar)

extern void Cvo_MenuIconify(Cvo_Object *, XEvent *, void *);

void
Cvo_MenuBar::_Init(Cvo_MenuBarList *ml)
{   CVO_ENTER
    type = CvoT_MenuBar;

    menus = 0;

    Register(CvoCreatedChildEvent, &Cvo_MenuBar::NewChild);
    Register(CvoDestroyedChildEvent, &Cvo_MenuBar::DeadChild);

    while (ml->resource) {
	Cvo_ButtonMenu *m = new Cvo_ButtonMenu(ml->resource, this,
					       ml->items, this);
	m->SetText(GetResource(XrmStringToQuark(ml->resource),
				       _QLabel, ml->resource));
    	m->Compact();
    	m->Accelerate();

	if (!strcmp(ml->resource, CvoMB_Help))
	    m->LayOpposite();
	ml->menu = m->Menu();
	ml->button = m;
	++ml;
    }
    if (GetResourceTruth("showLogo", "ShowLogo", True)) {
	Cvo_Picture *pict;

	pict = new Cvo_Picture("logo", this, cray_logo_width, cray_logo_height,
					     cray_logo_ncolors,
					     cray_logo_chars_per_pixel,
					     cray_logo_colors,
					     cray_logo_pixels);
	pict->LayOpposite();
	pict->SetMinPixelSize(pict->CalculateWidth(), pict->CalculateHeight());
	pict->SetMaxPixelSize(pict->CalculateWidth(), pict->CalculateHeight());
	pict->ExpandFrame();
	pict->SetGravity(Cvo_EAST);
    }
    CVO_VOID_RETURN
}

void
Cvo_MenuBar::_Create()
{   CVO_ENTER
    if (Object())
	CVO_VOID_RETURN

    Cvo_Window::_Create();

    Cvo_Object *c = children;

    while (c) {
	Cvo_Window *cw = c->ToWindow();
	if (cw) {
	    cw->SetWindowBackground(background);
	    cw->SetWindowForeground(foreground);
	}
	c = c->Sibling();
    }
    CVO_VOID_RETURN
}

void
Cvo_MenuBar::NewChild(XEvent *ev, void *)
{
    Cvo_CreatedChildEvent *cce = (Cvo_CreatedChildEvent *)ev;

    if (cce->child->Type() != CvoT_ButtonMenu)
	return;

    Cvo_ButtonMenu *menu = (Cvo_ButtonMenu *)(cce->child);

    Cvo_MenuBarEntries *mbe = new Cvo_MenuBarEntries;

    mbe->menu = menu->Menu();
    mbe->button = menu;
    mbe->prev = mbe->next = 0;

    if (!menus) {
	menus = mbe;
	return;
    }

    int cnt = 0;

    Cvo_Object *child = Children();

    while (child) {
	if (child->Win() && child->Type() == CvoT_ButtonMenu) {
	    ++cnt;
    	}
	child = child->Sibling();
    }

    struct MBE {
    	Cvo_MenuBarEntries	*e;
	Cvo_Object		*o;
    };

    MBE *e = new MBE[cnt];

    child = Children();

    int f = 0;
    int t = cnt;

    while (child) {
	if (child->Win() && child->Type() == CvoT_ButtonMenu) {
	    if (child->ToLayoutWindow()->GetLayOpposite()) {
		e[--t].o = child;
	    } else {
		e[f++].o = child;
	    }
	}
	child = child->Sibling();
    }

    if (f != t) {
	fprintf(stderr, "%s:%d Assertion failure\n", __FILE__, __LINE__);
	exit(1);
    }

    for (f = 0; f < cnt; ++f) {
    	if (e[f].o == menu) {
	    e[f].e = mbe;
	} else {
	    Cvo_MenuBarEntries *m = menus;

    	    while (m && m->button != e[f].o) {
	    	m = m->next;
	    }

    	    if (!m) {
		fprintf(stderr, "%s:%d Assertion failure\n", __FILE__,__LINE__);
		exit(1);
    	    }
    	    e[f].e = m;
	}
    }

    e[0].e->prev = 0;
    e[0].e->next = e[1].e;

    e[--cnt].e->next = 0;
    e[cnt].e->prev = e[cnt - 1].e;

    for (f = 1; f < cnt; ++f) {
	e[f].e->prev = e[f-1].e;
	e[f].e->next = e[f+1].e;
    }

    menus = e[0].e;

    delete [] e;
}

void
Cvo_MenuBar::DeadChild(XEvent *, void *)
{
}
