//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: List.cc,v 1.9 1994/09/21 18:40:50 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/List.h++>

static Cvo_Default defaults[] = {
    "*CvoList.CvoFrame.CvoCRT.Cursor:Top Left Arrow",
    "*CvoList.BorderWidth: 0",
};

CVO_BEGIN_BIND(Cvo_List)
CVO_DOBIND(Cvo_List, "Press",   Down)
CVO_DOBIND(Cvo_List, "Release", Up)
CVO_END_BIND(Cvo_List, Cvo_TextViewPort)

static char *trans = "\
        <Button1>: Press(1,0)\n\
        <Button2>: Press(2,0)\n\
        <Button3>: Press(3,0)\n\
        <ButtonRelease>: Release(0)\n\
        <Button1>(2): Press(1,1)\n\
        <Button2>(2): Press(2,1)\n\
        <Button3>(2): Press(3,1)\n\
        <ButtonRelease>(2): Release(1)\n\
";

CONSTRUCTORS_1ARG_PASS(Cvo_List, Cvo_TextViewPort, "CvoList", Cvo_Page *)


void
Cvo_List::_Init(Cvo_Page *)
{   CVO_ENTER
    type = CvoT_List;
    current = -1;
    text->SetExtraPad(4);
    text->NoTranslations();
    text->Register(CvoPageChangedEvent, &Cvo_List_PageChanged, this);
    jumptoend = False;
    AddTranslations(trans);
    radiostyle = False;
    reselect = True;
    CVO_VOID_RETURN
}

void
Cvo_List::Down(XEvent *ev, int ac, char **av)
{   CVO_ENTER
    int x = 0, y = 0;
    for (Cvo_Object *w = text; w && w != this; w = w->Parent()) {
	int ox, oy;
	w->Origin(&ox, &oy);
	x -= ox;
	y -= oy;
    }

    switch (ev->type ) {
    case ButtonPress:
    case ButtonRelease:
	x += ev->xbutton.x;
	y += ev->xbutton.y;
	break;
    case KeyPress:
    case KeyRelease:
	x += ev->xkey.x;
	y += ev->xkey.y;
	break;
    default:
	CVO_VOID_RETURN
    }

    if (x < 0 || x > text->Width() ||
        y < 0 || y > text->Height()) {
	CVO_VOID_RETURN
    }
    
    int nc = text->FindLine(y) + firstline;
    if (nc >= page->NumberLines()) {
	XBell(Dpy(), 0);
	CVO_VOID_RETURN
    }

    Select(nc, (ac > 1) ? atoi(av[1]) : 0, (ac > 0) ? atoi(av[0]) : 0);
}

void
Cvo_List::Select(int nc, int count, int button)
{   CVO_ENTER
    if (nc >= page->NumberLines())
	CVO_VOID_RETURN

    if (nc < firstline)
	GotoLine(nc);
    else if (nc >= lastline)
	GotoLine(nc - text->Rows() + 1);

    Cvo_ListItemSelectedEvent lise;
    lise.oldline = current;

    lise.count = count;

    if (nc != current) {
	if (current >= firstline && current <= lastline)
	    text->FlattenLine(current-firstline);
	current = nc;
	if (current >= firstline && current <= lastline)
	    text->RaiseLine(current-firstline);
    } else if (!radiostyle && lise.count == 0) {
    	if (reselect) {
	    lise.count++;
	} else {
	    text->FlattenLine(current-firstline);
	    current = -1;
    	}
    } else if (lise.count == 0) {
	if (!reselect)
	    CVO_VOID_RETURN
	lise.count++;
    }

    lise.line = current;
    lise.item = page;
    lise.button = button;
    SendEvent(CvoListItemSelectedEvent, &lise);
    CVO_VOID_RETURN
}

void
Cvo_List::Up(XEvent *, int, char **)
{   CVO_ENTER
    CVO_VOID_RETURN
}


void
Cvo_List_PageChanged(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo_List *cl = (Cvo_List *)w;
    cl->current = -1;
    CVO_VOID_RETURN
}
