//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: LayoutWindow.cc,v 1.3 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/LayoutWindow.h++>
#include <memory.h>
#if	!defined(X11R4)
#include <X11/Xlocale.h>
#endif
#include <stdio.h>

CONSTRUCTORS(Cvo_LayoutWindow, Cvo_Object, "CvoLayoutWindow")

void
Cvo_LayoutWindow::_Init()
{   CVO_ENTER
    _cvo_debug(CvoDebug_New, "_Init(%s, %s)\n", Name(), Class());

    type = CvoT_LayoutWindow;
    cvo_level = _CVO_LAYOUT_WINDOW;

    raise = 0;
    memset(&minSize,  0, sizeof(minSize));
    memset(&maxSize,  0, sizeof(maxSize));
    memset(&defSize,  0, sizeof(defSize));
    memset(&layout,   0, sizeof(layout));

    DoLayout();
    DoLayoutChildren();
    DoComputeSize();

    horizontalPad = GetResourceInt(_QhorizontalPad, _QPad, 0);
    verticalPad = GetResourceInt(_QverticalPad, _QPad, 0);

#if 0
    layout.expand = GetResourceInt(_QexpandLayout, _QExpandLayout, 0);
    layout.fillh = GetResourceTruth(_QfillHorizontally, _QFillFrame, 1);
    layout.fillw = GetResourceTruth(_QfillVertically, _QFillFrame, 1);
    layout.vertical = GetResourceTruth(_QverticalLayout, _QVerticalLayout);
#else
    layout.expand = 0;
    layout.fillh = 1;
    layout.fillw = 1;
    layout.vertical = False;
#endif

    layout.ignoreshadow = GetResourceTruth(_QignoreShadow, _QIgnoreShadow);
    layout.verticalPad = GetResourceInt(_QverticalLayoutPad, _QLayoutPad, 0);
    layout.horizontalPad = GetResourceInt(_QhorizontalLayoutPad, _QLayoutPad, 0);
    layout.internalPad = GetResourceInt(_QinternalPad, _QInternalPad, 0);
    transient = 0;

    char *geom = GetResource(_Qgeometry, _QGeometry);
    if (geom) {
	int x, y;
	unsigned int w, h;
	int flags = XParseGeometry(geom, &x, &y, &w, &h);

	if (flags & (WidthValue|HeightValue)) {
	    if (!(flags & WidthValue))
		w = 0;
	    if (!(flags & HeightValue))
		h = 0;

	    SetDefPixelSize(w, h);
	}
    }
    if (!parent)
	DontPosition();

    //
    // Top level windows to not automatically reposition themselves.
    //
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::Create()
{
    _Create();
    Cvo_AnyEvent ev;
    SendEvent(CvoCreatedEvent, &ev);

    Cvo_Object *obj = Parent();

    while (obj) {
	Cvo_CreatedChildEvent cev;
	cev.child = this;
	obj->SendEvent(CvoCreatedChildEvent, &cev);
	if (!obj->ToLayoutWindow() && !obj->ToLayoutWindow()->LayoutBackward())
	    break;
	obj = obj->Parent();
    }
}

Cvo_LayoutWindow::~Cvo_LayoutWindow()
{
    ;
}

void
Cvo_LayoutWindow::GetXOrigin(int *x, int *y)
{   CVO_ENTER
    if (!Object()) {
	XOrigin(x, y);
	CVO_VOID_RETURN
    }

    Window w;
    unsigned int ui;
    XGetGeometry(Dpy(), PWin() ? PWin() : Object(),
		 &w, x, y, &ui, &ui, &ui, &ui);
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::GetXOrigin(short *sx, short *sy)
{   CVO_ENTER
    int x, y;

    if (!Object()) {
	XOrigin(&x, &y);
    } else {
	Window w;
	unsigned int ui;
	XGetGeometry(Dpy(), PWin() ? PWin() : Object(),
		     &w, &x, &y, &ui, &ui, &ui, &ui);
    }

    *sx = x;
    *sy = y;
    CVO_VOID_RETURN
}

CARD16
Cvo_LayoutWindow::CalculateWidth()
{   CVO_ENTER
    CVO_RETURN(1)
}

CARD16
Cvo_LayoutWindow::CalculateHeight()
{   CVO_ENTER
    CVO_RETURN(1)
}
