//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: InputRing.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/InputRing.h++>

Cvo_InputRing::~Cvo_InputRing()
{
    while (ring)
	delete ring;
}

Cvo_InputRingElement::Cvo_InputRingElement(Cvo_InputRing *_root,
					   Cvo_Object *obj)
{
    root = _root;
    object = obj;

    if (!root->ring) {
	root->ring = next = prev = this;
    } else {
	next = root->ring;
	prev = root->ring->prev;
	next->prev = this;
	prev->next = this;
    }

    tabreg = object->RegisterKey(XK_Tab, _Cvo_InputRingElementNext, this);
    tabreg->MoveUp();

    focusreg = object->Register(CvoFocusInEvent, _Cvo_InputRingElementIn, this);
    object->Register(CvoDestroyedEvent, _Cvo_InputRingElementDestroyed, this);
}

Cvo_InputRingElement::~Cvo_InputRingElement()
{
    delete tabreg;
    delete focusreg;

    if (object->DisplayList()->Focus() == object)
	Tab();
    if (next == prev)
	root->ring = 0;
    else {
	if (this == root->ring)
	    root->ring = next;
	next->prev = prev;
	prev->next = next;
    }
}

void
Cvo_InputRingElement::Tab()
{
    Cvo_InputRingElement *nxt = Next();
    while (nxt != this) {
	if (nxt->object->Mapped()) {
	    nxt->object->TakeFocus();
	    break;
	}
	nxt = nxt->Next();
    }
}

void
Cvo_InputRingElement::BackTab()
{
    Cvo_InputRingElement *nxt = Prev();
    while (nxt != this) {
	if (nxt->object->Mapped()) {
	    nxt->object->TakeFocus();
	    break;
	}
	nxt = nxt->Prev();
    }
}

void
_Cvo_InputRingElementIn(Cvo_Object *, XEvent *, void *data)
{
    Cvo_InputRingElement *re = (Cvo_InputRingElement *)data;

    re->root->current = re;
}

void
_Cvo_InputRingElementNext(Cvo_Object *, XEvent *ev, void *data)
{
    Cvo_InputRingElement *re = (Cvo_InputRingElement *)data;
    ev->type = 0;
    
    if (ev->xkey.state & ShiftMask)
	re->BackTab();
    else
	re->Tab();
}

void
_Cvo_InputRingElementDestroyed(Cvo_Object *, XEvent *, void *data)
{
    Cvo_InputRingElement *re = (Cvo_InputRingElement *)data;
    
    re->tabreg = 0;
    re->focusreg = 0;
    delete re;
}
