//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Inform.cc,v 1.8 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Inform.h++>
#include <Cvo/Label.h++>
#include <Cvo/Button.h++>

static Cvo_Default def[] = {
    "*CvoInform.Pad:10",
    "*CvoInform.InternalPad:10",
    "*Color*CvoInform.Raise:",

    // Below are Mono options

    "*CvoInform.Raise:10",
};

CONSTRUCTORS_2ARG(Cvo__Inform, Cvo_Window, "CvoInform", char *, va_list)
static XEvent * _Cvo_InformFilter(Cvo_Object *, XEvent *, void *);

void
Cvo__Inform::_Init(char *fmt, va_list ap)
{   CVO_ENTER

    char *xrp;

    if (xrp = GetResource(_Qlabel, _QLabel, fmt ? fmt : Name()))
	fmt = xrp;

    char buf[1024];
    vsprintf(buf, fmt, ap);

    new Cvo_Label("label", this, buf);

    FillFrame(False);
    VerticalChildren();
    okay = 0;
    type = CvoT__Inform;

    Cvo_Button *button = new Cvo_Button("inform", this);
    button->SetText(GetResource(_Qdismiss, _QMessage, "Dismiss"));
    button->FillFrame(False);
    button->Register(CvoButtonUpEvent, &Cvo__Inform_Okay, this);
    CVO_VOID_RETURN
}

void
Cvo__Inform_Okay(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo__Inform *cc = (Cvo__Inform *)w;
    cc->okay = 1;
    CVO_VOID_RETURN
}

void
Cvo_Inform(char *_name, Cvo_Object *w, char *fmt, ...)
{   CVO_ENTER

    va_list ap;
    va_start(ap, fmt);

    Cvo__Inform *cc = new Cvo__Inform(_name, w, fmt, ap);
    Cvo_Inform(cc);

    va_end(ap);
    CVO_VOID_RETURN
}

void
Cvo_Inform(Cvo__Inform *cc)
{   CVO_ENTER
    while (cc->ExclusiveGrabbed())
	Cvo_ScanInputs(True);

    cc->ExpandFrame();
    cc->MakeOverlay();
    cc->Map();
    cc->RootObject()->RaiseWindow();
    cc->Flush();
    Cvo_PushEventFilter(_Cvo_InformFilter, 0, cc);

    while (!cc->okay)
	Cvo_ScanInputs(True);
    Cvo_PopEventFilter();

    delete cc;
    CVO_VOID_RETURN
}

static XEvent *
_Cvo_InformFilter(Cvo_Object *win, XEvent *ev, void *cco)
{   CVO_ENTER
    switch (ev->type) {
    case CvoKeyTextEvent:
    case KeyPress:
    case KeyRelease:
    case ButtonPress:
    case ButtonRelease:
    case MotionNotify:
	while (win && win != (Cvo_Object *)cco)
	    win = win->Parent();
	if (!win)
	    CVO_RETURN(0)
	CVO_RETURN(ev)
    default:
	CVO_RETURN(ev)
    }
}
