//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: FileProto.cc,v 1.5 1994/08/10 17:54:53 prb Exp $"); }
/*****************************************************************************/
/*  FileProto.cc - 							     */
/*  Date of origin: September 93 					     */
/*                                                                           */
/*  History:                                                                 */
/*     Author       Date    Comments                                         */
/*     ------       ----    --------                                         */
/*     Paul Algren   9-93   Initial implementation 			     */
/*                                                                           */
/*  Portions of this software may still be in development.  The existence of */
/*  the software still in development is not a commitment of actual release  */
/*  or support by Cray Research, Inc.  If it is released, the final form of  */
/*  the product and the time of official release is at the discretion of     */
/*  Cray Research, Inc.                                                      */
/*                                                                           */
/*****************************************************************************/
#include <Cvo/FileProto.h++>
#include <Cvo/convert.h++>
#include <sys/param.h>

#if !defined(MAXPATHLEN)
#define	MAXPATHLEN 1024
#endif

void cm();

void
Cvo_CddDrop_FLP::Process(XEvent* ev)
{
    char* hostname;
    char* file;
    short ix, iy;
    int rx, ry;
    int slen;
    int status;
    Window parent;
    Window child;

    Cvo_CddDrop_Protocol::Process(ev);

    unsigned char* ptr = data;

    short pieces = Cvo_read16(ptr);
    ptr += 2;

    parent = DefaultRootWindow(obj->Dpy());
    XTranslateCoordinates(obj->Dpy(), parent, obj->Win(),
			      x, y, &rx, &ry, &child);
    flp->x = rx;
    flp->y = ry;
    /*
     *	Skip 2 bytes used for sanity checks. The second
     *	byte should be 13.
     */
    ptr += 2;

    /*
     *	Now get down to business.
     */
    for (int i = 0; i < pieces; i++) {
	status = (int) *ptr++;

	ix = Cvo_read16(ptr);
	ptr += 2;
	iy = Cvo_read16(ptr);
	ptr += 2;
	
	if (status & 0x2)
	    ix = -ix;
	if (status & 0x1)
	    iy = -iy;

	slen = (int)Cvo_read32(ptr);
	ptr += 4;

	char *df = file = new char[slen + 1];
	strncpy(file, (char*)ptr, slen);
	file[slen] = 0;

	if ((hostname = strtok(file, ":")) == 0) { delete [] df; continue;} 

	if ((file = strtok((char*)0, "")) == 0) { delete [] df; continue;} 

	new Cvo_FileItem(&flp->files, file, hostname,
			 flp->x + ix, flp->y + iy);
	
	delete [] df;

	ptr += slen;
    }

    flp->Process();

    while (flp->files) 
	delete flp->files;
}

BOOL
Cvo_CddDrop_FLP::Send(Display* dpy, Window to)
{
    char filename[MAXPATHLEN];
    int slen;
    int status=0;
    int alloc = 512;
    char* buf = new char[alloc];
    char* tmpbuf;
    char* ptr = buf;
    int count = 0;

    if (!flp->files) {
	return (False);
    } 

    for (Cvo_FileItem *item = flp->files; item; item = item->Next()) {
	count++;
    }

    Cvo_store16(count, ptr);
    ptr+=2;

    // Sanity space ?
    Cvo_store16((short)13, ptr);
    ptr+=2;
   
    for (item = flp->files; item; item = item->Next()) {
	status = (char)((item->X() < 0) ? 0x2 : 0x0)
	             | ((item->Y() < 0) ? 0x1 : 0x0);
	*ptr = (char) (status & 0xff);
	ptr++;
    
	Cvo_store16(abs(item->X()), ptr);
	ptr+=2;

	Cvo_store16(abs(item->Y()), ptr);
	ptr+=2;

	slen = strlen(item->Hostname()) + strlen(item->Filename()) + 1;

	Cvo_store32(slen, ptr);
	ptr+=4;
	
	if ((ptr - buf) + 9 + slen > alloc) {
	    alloc += 512;
	    tmpbuf = new char[alloc];
	    memcpy(tmpbuf, buf, alloc-512);
	    int bytes = ptr - buf;
	    delete [] buf;
	    buf = tmpbuf;
	    ptr = buf + bytes;
	} 
	    
	strcpy(filename, item->Hostname());
	strcat(filename, ":");
	strcat(filename, item->Filename());

	strcpy(ptr, filename);
	ptr+= slen;
    }

    data = (unsigned char*)buf;
    size = ptr - buf + 1;
    
    BOOL ret = Cvo_CddDrop_Protocol::Send(dpy, to);

    delete [] buf;
    return (ret);
}

void
Cvo_IXI_FLP::Process(XEvent* ev)
{
    Window parent;
    Window child;
    char* hostname;
    char* file;
    int rx, ry;

    Cvo_IXI_Protocol::Process(ev);

    unsigned char* ptr = data;
    parent = DefaultRootWindow(obj->Dpy());
    XTranslateCoordinates(obj->Dpy(), parent, obj->Win(),
			      x, y, &rx, &ry, &child);
    flp->x = rx;
    flp->y = ry;

    hostname = new char[strlen((char*)ptr) + 1];
    strcpy(hostname,(char*)ptr);
    ptr += (strlen((char*)ptr) + 1);
    /*
     *
     */
    while (*ptr) {
	file = new char[strlen((char*)ptr) + 1];
	strcpy(file, (char*)ptr);
	ptr += (strlen((char*)ptr) + 1);

	new Cvo_FileItem(&flp->files, file, hostname,
			 flp->x, flp->y);
	delete [] file;
    }
    flp->Process();

    delete [] hostname;
}

BOOL
Cvo_IXI_FLP::Send(Display* dpy, Window to)
{
    char filename[MAXPATHLEN];
    int slen;
    int alloc = 512;
    char* buf = new char[alloc];
    char* tmpbuf;
    char* ptr = buf;

    if (!flp->files) {
	return (False);
    } 

    for (Cvo_FileItem *item = flp->files; item; item = item->Next()) {
	slen = strlen(item->Filename()) + 1;
	
	if ((ptr - buf) + 1 + slen > alloc) {
	    alloc += 512;
	    tmpbuf = new char[alloc];
	    memcpy(tmpbuf, buf, alloc-512);
	    int bytes = ptr - buf;
	    delete [] buf;
	    buf = tmpbuf;
	    ptr = buf + bytes;
	} 
	
	strcpy(ptr, item->Filename());
	ptr+= slen + 1;
    }
    *ptr = 0;  			// add extra null to end of list
    ptr++;

    data = (unsigned char*)buf;
    size = ptr - buf + 1;
    
    BOOL ret = Cvo_IXI_Protocol::Send(dpy, to);

    delete [] buf;
    return (ret);
}

void
Cvo_HostAndFile_FLP::Process(XEvent* ev)
{
    Window parent;
    Window child;
    char* hostname;
    char* file;
    int rx, ry;

    Cvo_HostAndFile_Protocol::Process(ev);

    unsigned char* ptr = data;

    parent = DefaultRootWindow(obj->Dpy());
    XTranslateCoordinates(obj->Dpy(), parent, obj->Win(),
			      x, y, &rx, &ry, &child);
    flp->x = rx;
    flp->y = ry;

    hostname = new char[strlen((char*)ptr) + 1];
    strcpy(hostname,(char*)ptr);
    ptr += (strlen((char*)ptr) + 1);
    /*
     *
     */
    while (*ptr) {
	file = new char[strlen((char*)ptr) + 1];
	strcpy(file, (char*)ptr);
	ptr += (strlen((char*)ptr) + 1);

	new Cvo_FileItem(&flp->files, file, hostname,
			 flp->x, flp->y);
	delete [] file;
    }
    flp->Process();
    delete [] hostname;
}

BOOL
Cvo_HostAndFile_FLP::Send(Display* dpy, Window to)
{
    char filename[MAXPATHLEN];
    int slen;
    int alloc = 512;
    char* buf = new char[alloc];
    char* tmpbuf;
    char* ptr = buf;

    if (!flp->files) {
	return (False);
    } 

    for (Cvo_FileItem *item = flp->files; item; item = item->Next()) {
	slen = strlen(item->Filename()) + 1;
	
	if ((ptr - buf) + 1 + slen > alloc) {
	    alloc += 512;
	    tmpbuf = new char[alloc];
	    memcpy(tmpbuf, buf, alloc-512);
	    int bytes = ptr - buf;
	    delete [] buf;
	    buf = tmpbuf;
	    ptr = buf + bytes;
	} 
	
	strcpy(ptr, item->Filename());
	ptr+= slen + 1;
    }
    *ptr = 0;  			// add extra null to end of list
    ptr++;

    data = (unsigned char*)buf;
    size = ptr - buf + 1;
    
    BOOL ret = Cvo_HostAndFile_Protocol::Send(dpy, to);

    delete [] buf;
    return (ret);
}

void
Cvo_SunLdFiles_FLP::Process(XEvent* ev)
{
    Cvo_SunLdFiles_Protocol::Process(ev);
    new Cvo_FileItem(&flp->files, (char*)data, "", 1, 1);
    flp->Process();
}

BOOL
Cvo_SunLdFiles_FLP::Send(Display* dpy, Window to)
{
    char* buf;

    if (!flp->files) {
	return (False);
    } 

    Cvo_FileItem *item = flp->files;
    size =  strlen(item->Filename()) + 1;

    buf = new char[size];
    strcpy(buf, item->Filename());

    data = (unsigned char*)buf;
    
    BOOL ret = Cvo_SunLdFiles_Protocol::Send(dpy, to);

    delete [] buf;
    return (ret);
}

void
Cvo_SunCpFiles_FLP::Process(XEvent* ev)
{
    Cvo_SunCpFiles_Protocol::Process(ev);
    new Cvo_FileItem(&flp->files, (char*)data, "", 1, 1);
    flp->Process();
}

BOOL
Cvo_SunCpFiles_FLP::Send(Display* dpy, Window to)
{
    char* buf;

    if (!flp->files) {
	return (False);
    } 

    Cvo_FileItem *item = flp->files;
    size =  strlen(item->Filename()) + 1;

    buf = new char[size];
    strcpy(buf, item->Filename());

    data = (unsigned char*)buf;
    
    BOOL ret = Cvo_SunCpFiles_Protocol::Send(dpy, to);

    delete [] buf;
    return (ret);
}

void
Cvo_SunMvFiles_FLP::Process(XEvent* ev)
{
    Cvo_SunMvFiles_Protocol::Process(ev);
    new Cvo_FileItem(&flp->files, (char*)data, "", 1, 1);
    flp->Process();
}

BOOL
Cvo_SunMvFiles_FLP::Send(Display* dpy, Window to)
{
    char* buf;

    if (!flp->files) {
	return (False);
    } 

    Cvo_FileItem *item = flp->files;
    size =  strlen(item->Filename()) + 1;

    buf = new char[size];
    strcpy(buf, item->Filename());

    data = (unsigned char*)buf;
    
    BOOL ret = Cvo_SunMvFiles_Protocol::Send(dpy, to);

    delete [] buf;
    return (ret);
}

Cvo_FileItem::Cvo_FileItem(Cvo_FileItem **r, char *file,
			   char* host, int ix, int iy)
            : Cvo_RootedList((Cvo_RootedList**) r)
{
    root = r;

    next = NULL;

    x = ix;
    y = iy;

    filename = new char[strlen(file) + 1];
    strcpy(filename, file);
    
    hostname = new char[strlen(host) + 1];
    strcpy(hostname, host);
};

Cvo_FileItem::~Cvo_FileItem()
{
    delete [] hostname;
    delete [] filename;
    Unlink((Cvo_RootedList **)root);
}

Cvo_FileList_Protocol::Cvo_FileList_Protocol(Cvo_Object* o)
{
    cdd = new Cvo_CddDrop_FLP(this, o);
    ixi = new Cvo_IXI_FLP(this, o);
    haf = new Cvo_HostAndFile_FLP(this, o);
    sunmv = new Cvo_SunMvFiles_FLP(this, o);
    suncp = new Cvo_SunCpFiles_FLP(this, o);
    sunld = new Cvo_SunLdFiles_FLP(this, o);

    sendor = x = y = 0;
    time = 0;

    files = 0;
}

Cvo_FileList_Protocol::~Cvo_FileList_Protocol()
{
    delete cdd;
    delete ixi;
    delete haf;
    delete sunmv;
    delete suncp;
    delete sunld;

    while (files)
	delete files;
}

BOOL
Cvo_FileList_Protocol::Send(Display* dpy)
{
    if (!files) {
	fprintf(stderr, "No files in list\n");
	return (False);
    } 

    Cvo_Drop_Protocol* proto = 0;
    Window t_window = 0;

    if (t_window = cdd->FindDropTarget(dpy, x, y)) {
	proto = cdd;
	cdd->key	= 1000;
	cdd->time = time;
	cdd->sendor = sendor;
    } else if (t_window = ixi->FindDropTarget(dpy, x, y)) {
	proto = ixi;
	ixi->time = time;
    } else if (t_window = haf->FindDropTarget(dpy, x, y)) {
	proto = haf;
	haf->time = time;
    } else if (t_window = sunmv->FindDropTarget(dpy, x, y)) {
	proto = sunmv;
	sunmv->sendor = sendor;
    } else if (!(t_window = suncp->FindDropTarget(dpy, x, y))) {
	proto = suncp;
	suncp->sendor = sendor;
    } else if (!(t_window = sunld->FindDropTarget(dpy, x, y))) {
	proto = sunld;
	sunld->sendor = sendor;
    } else {
	fprintf(stderr, "Couldn't find a receptor window!\n");
	return (False);		// No window to drop to
    }

    return (proto->Send(dpy, t_window));
}
