//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: FdSet.cc,v 1.4 1994/08/10 17:54:53 prb Exp $"); }
#include <unistd.h>
#include <stdlib.h>
#include <Cvo/FdSet.h++>

#include <sys/param.h>
#if defined(__NEED_GETDTABLESIZE_DEF__)
extern "C" int getdtablesize();
#endif

int EvFdSet::fd_set_size   = 0;
int EvFdSet::fd_array_size = 0;

//
// The standard fd_set definition cannot be used as that is determined
// at compile time (FD_SETSIZE) which might not match the runtime value.
//

void
EvFdSet::InitFdSetSize()
{
    if (fd_set_size == 0) {
#if defined(_SC_OPEN_MAX)
	fd_set_size = int(sysconf(_SC_OPEN_MAX));
#else
#if defined(__NO_GETDTABLESIZE__)
	fd_set_size = FOPEN_MAX;
#else
	fd_set_size = getdtablesize();
#endif
#endif
        fd_array_size = (fd_set_size + sizeof(fd_mask) - 1) / sizeof(fd_mask);
    }
}


EvFdSet::EvFdSet()
{
    InitFdSetSize();
    fdset = (struct fd_set *) new fd_mask[fd_array_size];
    Zero();
}

EvFdSet::EvFdSet(const EvFdSet &x)
{
    InitFdSetSize();
    fdset = (struct fd_set *) new fd_mask[fd_array_size];
    Copy(x.fdset);
}

int
EvFdSet::NbrSet() const
{
    int cnt = 0;
    for (int fd = 0; fd < fd_set_size; fd++) {
	if (IsSet(fd))
	    cnt++;
    }
    return(cnt);
}
