//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: ExpandPage.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/ExpandPage.h++>

Cvo_ExpandPageLine *
Cvo_ExpandPageSet::AppendItem(char *t, int n, void *v)
{
    static Cvo_CharacterBuffer cb;
    cb.Set(t, n);
    return(AppendItem(cb.wcValue(), cb.wcLength(), v));
}

void *
Cvo_ExpandPage::GetAssociatedData(CARD n)
{
    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);
    return(item ? item->GetAssociatedData() : 0);
}

#define	MHEIGHT (win->TextAttribute()->MHeight())

void
Cvo_ExpandPage::Draw(CARD n, const XRectangle &clip, int x, int y)
{
    if (!win || !win->Object())
	return;

    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);

    if (item) {
	XRectangle r = clip;

	int sa = level * (MHEIGHT + win->InternalPad());

	r.x += sa;
	r.width -= sa;

	if (item->SubPage()) {
	    win->SetClipRectangles(0, 0, &clip, 1, Unsorted);
	    if (item->Closed())
		win->DrawRightArrow(r.x - x, r.y, MHEIGHT);
	    else
		win->DrawDownArrow(r.x - x, r.y, MHEIGHT);
	    win->SetClipMask(None);
	}

	sa += MHEIGHT + win->InternalPad();

	if (x > sa) {
	    r.x = clip.x;
	    r.width = clip.width;
	    x -= sa;
	} else {
	    r.x = clip.x + sa - x;
	    r.width = clip.width - sa + x;
	    x = 0;
	}

	DrawText(win->TextAttribute(), item->Text(), item->Length(), r, x, y);
    }
}

BOOL
Cvo_ExpandPage::HandlePress(CARD n, int x, int, XEvent *)
{
    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);

    if (   item
	&& item->SubPage()
	&& x < MHEIGHT +
	       level * (MHEIGHT + win->InternalPad())) {
	item->Close(item->Closed() ? False : True);
	if (item->Closed())
	    removedlines = True;
	else
	    newlines = True;
	SendPageEvent();
	return(True);
    }
    return(False);
}


CARD
Cvo_ExpandPage::Width(CARD n)
{
    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);

    int w = 0;

    if (item)
	w = WidthText(win->TextAttribute(), item->Text(), item->Length());
    w += (level + 1) * (MHEIGHT + win->InternalPad());


    return(w);
}

CARD
Cvo_ExpandPage::Height(CARD n)
{
    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);

    int h = 0;

    if (item) {
	h = HeightText(win->TextAttribute(), item->Text(), item->Length());
	if (item->SubPage()) {
	    if (h < MHEIGHT)
		h = MHEIGHT;
	}
    }
    return(h);
}

void *
Cvo_ExpandPage::GetLine(CARD n)
{
    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);

    return(item);
}

void *
Cvo_ExpandPage::GetLine(CARD n, Cvo_CharacterBuffer *cb)
{
    CARD level = 0;
    Cvo_ExpandPageLine *item = hierarchy.Item(n, level);
    if (item)
	cb->Set(item->Text(), item->Length());

    return(item);
}


Cvo_ExpandPageLine *
Cvo_ExpandPageSet::Item(CARD &index, CARD &level)
{
    for (CARD x = 0; x < nitems; ++x) {

	if (items[x].hidden)
	    continue;

	if (index-- <= 0) {
	    return(&items[x]);
	}

	Cvo_ExpandPageSet *ch = items[x].Hierarchy();

	if (ch) {
	    ++level;
	    Cvo_ExpandPageLine *it = ch->Item(index, level);
	    if (it)
		return(it);
	    --level;
	}
    }

    return((Cvo_ExpandPageLine *)0);
}

void
Cvo_ExpandPageSet::HideItem(CARD index, BOOL v)
{
    CARD level;

    Cvo_ExpandPageLine *hi = Item(index, level);
    if (hi)
	hi->Hide(v);
}

void
Cvo_ExpandPageSet::DeleteItem(CARD &index)
{
    for (CARD x = 0; x < nitems; ++x) {

	if (items[x].hidden)
	    continue;

        if (index-- <= 0) {
	    Cvo_ExpandPageLine hi = items[x];
	    while (++x < nitems)
		items[x-1] = items[x];
	    items[--nitems] = hi;
	    return;
        }

        Cvo_ExpandPageSet *ch = items[x].Hierarchy();

        if (ch) {
            ch->DeleteItem(index);
            if (index <= 0)
                return;
        }
    }
}

BOOL
Cvo_ExpandPageSet::DeleteItem(Cvo_ExpandPageLine *i)
{
    if (i >= items && i < items + nitems) {
	Cvo_ExpandPageLine hi = *i;
	while (++i < items + nitems)
	    i[-1] = i[0];
	i[0] = hi;
	return(True);
    }
    for (CARD x = 0; x < nitems; ++x) {
        Cvo_ExpandPageSet *ch = items[x].Hierarchy();
	if (ch && ch->DeleteItem(i))
	    return(True);
    }
    return(False);
//XXX    removedlines = True;
//XXX    SendPageEvent();
}

Cvo_ExpandPageLine *
Cvo_ExpandPageSet::AppendItem(wchar_t *text, int length, void *adata)
{
    if (nitems >= maxitems) {
	int newmax = maxitems + 64;

        Cvo_ExpandPageLine *ni = new Cvo_ExpandPageLine[newmax];

        for (int x = 0; x < maxitems; ++x) {
            ni[x] = items[x];
            items[x].Zap();
        }
        maxitems = newmax;

        delete [] items;
        items = ni;
    }
    if (length < 0) {
	for (length = 0; text[length]; ++length)
	    ;
    }
    items[nitems].SetText(text, length, adata);
    return(&items[nitems++]);
//XXX    newlines = True;
//XXX    SendPageEvent();
}

Cvo_ExpandPageSet *
Cvo_ExpandPageLine::AddHierarchy()
{
    if (!hierarchy)
	hierarchy = new Cvo_ExpandPageSet;
    return(hierarchy);
}

void
Cvo_ExpandPageLine::SetText(wchar_t *t, int len, void *a)
{
    if (len < 0)
	for (len = 0; t[len]; ++len)
	    ;
    text = new wchar_t[len + 1];
    text[length = len] = 0;
    memcpy(text, t, len * sizeof(wchar_t));
    adata = a;
//XXX    changedlines = True;
//XXX    SendPageEvent();
}

int
Cvo_ExpandPageSet::NumberLines()
{
    int cnt = 0;

    for (int x = 0; x < nitems; ++x)
	if (!items[x].hidden)
	    cnt += items[x].NumberLines();
    return(cnt);
}

int
Cvo_ExpandPageLine::NumberLines()
{
    Cvo_ExpandPageSet *ch = Hierarchy();

    return(ch ? ch->NumberLines() + 1 : 1);
}

void
Cvo_ExpandPage::SendPageEvent()
{
    Cvo_PageChangedEvent pce;

    if (!win || !output)
        CVO_VOID_RETURN

    if (newlines || changedlines || removedlines) {
	pce.newlines = newlines;
	pce.changedlines = changedlines;
	pce.removedlines = removedlines;
       
	newlines = False;
	changedlines = False;
	removedlines = False;

	win->SendEvent(CvoPageChangedEvent, &pce);
    }
}
