//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: EvSignal.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
//
// This code was initially contributed by Jim Nowicki 11-92
//
#include <stdio.h>
#include <stdlib.h>
#include <Cvo/Ev.h++>
#include <Cvo/util.h++>

EV_SIG_CALLBACK_PROC Ev::def_sig[NSIG+1];

//
// Function:    Ev_SignalCatcher()
// Description: This function is called by the O.S. upon occurance of a signal.
//              This function will queue up the received signal, and then
//              return.  The main event processing loop will then call the
//              user's signal handler from the main event loop.  This allows
//              the user to deal with signals in a relatively safe manner.
//              In order for this routine to deal with the receipt of signals
//              in an asyncronous manner, multiple signal queues are
//              maintained.  Each queue has an active flag, which should be
//              checked whenever the queue is to be accessed.  If a queue
//              is active, the next queue is checked, on so on.  The queues
//              are kept in an array so that the actual number should be
//              adjustible.  Note that since signals are asynchronous, but not
//              actually multitasked, that this mechanism should be sufficient.
//              Note also that it is still possible to lose signals, if either
//              all queues are active, or if a signal queue fills up.  This
//              shouldn't happen normally.  If multiple signals are received
//              in rapid succession, this may happen, although the actual
//              window in which this may happen is quite small.
//              Also, it may be possible that the signal handlers may not be
//              called in the same order as the signals arrive.
//
void
Ev_SignalCatcher(int signo)
{   CVO_ENTER
#if	defined(SIGCLD)
    if (signo != SIGCLD) {
       signal(signo, (EV_SIG_CALLBACK_PROC) Ev_SignalCatcher);
    }
#endif
    Ev::sigPending = 1;
    for (int i = 0; i < EvNumberSignalQueues; i++) {
        if (!Ev::signalQs[i].SetActive()) {
           Ev::signalQs[i].Push(signo);
           Ev::signalQs[i].SetInactive();
           break;
        }
    }
    CVO_VOID_RETURN
}

void
Ev::DispatchSignalHandlers()
{   CVO_ENTER
    sigPending = 0;
    int sigcld = 0;

    for (int i = 0; i < EvNumberSignalQueues; i++) {
        assert(!signalQs[i].Active());
        signalQs[i].SetActive();
        while (!signalQs[i].Empty()) {
              int signo = signalQs[i].Pop();
              if (signo > 0 && signo <= NSIG && signals[signo] != NULL) {
                 signalQs[i].SetInactive();
                 signals[signo]->CallCallback();
                 signalQs[i].SetActive();
              }
#if	defined(SIGCLD)
              if (signo == SIGCLD) {
                 sigcld = 1;
              }
#endif
        }
        signalQs[i].SetInactive();
    }
#if	defined(SIGCLD)
    if (sigcld) {
       signal(SIGCLD, (EV_SIG_CALLBACK_PROC) Ev_SignalCatcher);
    }
#endif
    CVO_VOID_RETURN
}

EvSignal::EvSignal(int signo, EvSignalProc cb, void *userdata)
{   CVO_ENTER
    userData = userdata;
    callback = cb;
    signbr   = signo;
    next     = NULL;

    assert(signo > 0 && signo <= NSIG);
    if (signals[signo] == NULL) {
       def_sig[signo] = signal(signo, (EV_SIG_CALLBACK_PROC) Ev_SignalCatcher);
    }
    Link((Ev **) &signals[signo]);
    signals[signo] = this;
    nbrSignals++;
    CVO_VOID_RETURN
}

EvSignal::~EvSignal()
{   CVO_ENTER
    assert(signbr > 0 && signbr <= NSIG);
    Unlink((Ev **) &signals[signbr]);
    if (signals[signbr] == NULL) {
       signal(signbr, def_sig[signbr]);
    }
    nbrSignals--;
    CVO_DONE
}
