//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Confirm.cc,v 1.7 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Confirm.h++>
#include <Cvo/Label.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Button.h++>

static Cvo_Default def[] = {
    "*CvoConfirm.Pad:10",
    "*CvoConfirm.InternalPad:10",

    "*Color*CvoConfirm*Background:firebrick3",

    "*Color*CvoConfirm.Raise:",

    // Below are Mono options

    "*CvoConfirm.Raise:10",
};

CONSTRUCTORS_2ARG(Cvo__Confirm, Cvo_Window, "CvoConfirm", char *, va_list)
static XEvent * _Cvo_ConfirmFilter(Cvo_Object *, XEvent *, void *);

void
Cvo__Confirm::_Init(char *fmt, va_list ap)
{   CVO_ENTER
    Cvo_Frame *frame;
    Cvo_Button *button1;
    Cvo_Button *button2;

    char *xrp;

    if (xrp = GetResource(_Qlabel, _QLabel, fmt ? fmt : Name()))
        fmt = xrp;

    char buf[1024];
    vsprintf(buf, fmt, ap);

    new Cvo_Label("label", this, buf);

    FillFrame(False);
    VerticalChildren();
    okay = 0;
    cancel = 0;
    type = CvoT__Confirm;

    frame = new Cvo_Frame(this);
    button1 = new Cvo_Button("confirm", frame);
    button1->SetText(GetResource(_Qconfirm, _QMessage, "Confirm"));
    button1->Register(CvoButtonUpEvent, &Cvo__Confirm_Okay, this);


    button2 = new Cvo_Button("cancel", frame);
    button2->SetText(GetResource(_Qcancel, _QMessage, "Cancel"));
    button2->LayOpposite();
    button2->Register(CvoButtonUpEvent, &Cvo__Confirm_Cancel, this);

    int w1 = button1->CalculateWidth() + button1->StringWidth("  ");
    int w2 = button2->CalculateWidth() + button2->StringWidth("  ");
    if (w2 > w1)
	w1 = w2;
    w2 = button2->StringWidth("        ");
    if (w2 > w1)
	w1 = w2;
    button1->SetMinPixelSize(w1, 0);
    button2->SetMinPixelSize(w1, 0);
    button1->ExpandFrame();
    button2->ExpandFrame();
    CVO_VOID_RETURN
}

void
Cvo__Confirm_Okay(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo__Confirm *cc = (Cvo__Confirm *)w;

    cc->okay = 1;
    CVO_VOID_RETURN
}

void
Cvo__Confirm_Cancel(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo__Confirm *cc = (Cvo__Confirm *)w;

    cc->cancel = 1;
    CVO_VOID_RETURN
}

int
Cvo_Confirm(char *_name, Cvo_Object *w, char *fmt, ...)
{   CVO_ENTER

    va_list ap;
    va_start(ap, fmt);

    Cvo__Confirm *cc = new Cvo__Confirm(_name, w, fmt, ap);

    va_end(ap);
    CVO_RETURN(Cvo_Confirm(cc))
}

int
Cvo_Confirm(Cvo__Confirm *cc)
{   CVO_ENTER
    while (cc->ExclusiveGrabbed())
	Cvo_ScanInputs(True);

    cc->ExpandFrame();
    cc->MakeOverlay();
    cc->Map();
    cc->RootObject()->RaiseWindow();
    cc->Flush();
    Cvo_PushExEventFilter(_Cvo_ConfirmFilter, 0, cc);

    while (!cc->okay && !cc->cancel)
	Cvo_ScanInputs(True);

    Cvo_PopEventFilter();

    int ret = cc->okay;
    delete cc;
    CVO_RETURN(ret)
}

static XEvent *
_Cvo_ConfirmFilter(Cvo_Object *win, XEvent *ev, void *cco)
{   CVO_ENTER
    switch (ev->type) {
    case CvoKeyTextEvent:
    case KeyPress:
    case KeyRelease:
    case ButtonPress:
    case ButtonRelease:
    case MotionNotify:
	while (win && win != (Cvo_Object *)cco)
	    win = win->Parent();
	if (!win)
	    CVO_RETURN(0)
	CVO_RETURN(ev)
    default:
	CVO_RETURN(ev)
    }
}
