//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Configure.cc,v 1.5 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>

static int
ignoreerror(Display *, XErrorEvent *)
{
    return(0);
}

void
Cvo_Object::PreConfigure(XConfigureEvent *ev)
{   CVO_ENTER
    oldconfigured = configured;
    configured = True;

    if (!parent) {
	if (ev) {
	    SetPosition(ev->x, ev->y);

	    Cvo_Window *w;
	    if (!frame && !flattened && (w = ToWindow()) && w->chamfer
		&& ev->width > w->XWidth() && ev->height > w->XHeight())
		    w->_clearChamfer();
	}
	if (PWin()) {
	    XWindowAttributes xwa;

	    //
	    // We reset the error handler to deal with the case that our
	    // parent has actually been destroyed but we have not been
    	    // told yet.  This can happen when a window manager is "restarted"
	    // Enclose the work with XSync() to assure only this request has
	    // the ignore filter turned on.
	    //

	    XSync(Dpy(), False);
    	    int (*eh)(Display *, XErrorEvent *);
	    eh = XSetErrorHandler(ignoreerror);
    	    Status s = XGetWindowAttributes(Dpy(), PWin(), &xwa);
	    XSync(Dpy(), False);
	    XSetErrorHandler(eh);

    	    if (s) {
		borderWidth = xwa.border_width;
		SetPosition(xwa.x, xwa.y);
    	    } else if (ev) {
	    	pwindow = 0;
		borderWidth = ev->border_width;
		SetPosition(ev->x + borderWidth, ev->y + borderWidth);
    	    }
	} else if (ev) {
	    borderWidth = ev->border_width;
	    SetPosition(ev->x + borderWidth, ev->y + borderWidth);
	}


    } else
	if (ev)
	    borderWidth = ev->border_width;

    CVO_VOID_RETURN
}

void
Cvo_Object::Configure(XConfigureEvent *ev)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Configure, "Configure(%s, %s)\n", Name(), Class());

    if (!parent && ev) {
	width = ev->width;
	height = ev->height;
	Cvo_LayoutWindow *lw = ToLayoutWindow();
	if (lw) {
	    width -= 2 * lw->horizontalPad;
	    height -= 2 * lw->verticalPad;
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::PostConfigure(XConfigureEvent *ev)
{   CVO_ENTER
    Cvo_Window *w;

    if ((w = ToWindow()) && !parent && !frame && ev && w->chamfer && !flattened)
	w->_drawChamfer();
    CVO_VOID_RETURN
}

void
Cvo_Object::Reparent(XReparentEvent *ev)
{   CVO_ENTER
    if (!parent) {
	XWindowAttributes xwa;

	pwindow = ev->parent;

	XGetWindowAttributes(Dpy(), PWin(), &xwa);

	borderWidth = xwa.border_width;

	Cvo_LayoutWindow *lw = ToLayoutWindow();
	SetPosition(xwa.x + ev->x + borderWidth,
		    xwa.y + ev->y + borderWidth);


	Window root_return, parent_return, *children_return;
	unsigned int nchilren_return;

	parent_return = pwindow;
	do {
	    children_return = 0;
	    XQueryTree(Dpy(), pwindow = parent_return,
			      &root_return,
			      &parent_return,
			      &children_return, &nchilren_return);
	    if (children_return) {
		XFree(_xfree_t children_return);
	    }
	} while (parent_return && root_return != parent_return);

	if (pwindow == root_return)
	    pwindow = 0;

	_PassOnSelectMask(selectMask);
    }
    CVO_VOID_RETURN
}
