//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Chart.cc,v 1.8 1994/10/19 18:46:37 prb Exp $"); }

#include <Cvo/Chart.h++>
#include <Cvo/Pin.h++>
#include <Cvo/PeelOff.h++>
#include <Cvo/OptionMenu.h++>

static Cvo_Default defs[] = {
    "*CvoChart*grafik.Sunken: False",
    "*CvoChart*grafik*Pad: 0",
    "*CvoChart.Cursor:Top Left Arrow",
    "*vertical.label: Vertical",
    "*horizontal.label: Horizontal",
    "*vertical-side.label: V-side",
    "*horizontal-side.label: H-side",

    "*legend.Chamfer: 0",
    "*legend.BorderWidth: 0",
    "*legend-box*Chamfer: 0",
    "*CvoChartLegend.BorderWidth: 0",
    "*CvoChart.frame1.internalPad: 15",

    "*Color*CvoChart.linecolor: black",
    "*Color*CvoChart.backcolor: white",
    "*Color*CvoChart.color0: blue",
    "*Color*CvoChart.color1: firebrick",
    "*Color*CvoChart.color2: green",
    "*Color*CvoChart.color3: yellow",
    "*Color*CvoChart.color4: plum",
    "*Color*CvoChart.color5: AntiqueWhite4",
    "*Color*CvoChart.color6: snow2",
    "*Color*CvoChart.color7: honeydew1",
    "*Color*CvoChart.color8: cyan2",
    "*Color*CvoChart.color9: thistle",
    "*Color*CvoChart.color10: CadetBlue",
    "*Color*CvoChart.color11: wheat",

    // Below are Mono options

    "*CvoChart.linecolor: black",
    "*CvoChart.backcolor: white",
    "*CvoChart.color0: gray47",
    "*CvoChart.color1: gray72",
    "*CvoChart.color2: gray22",
    "*CvoChart.color3: gray60",
    "*CvoChart.color4: gray10",
    "*CvoChart.color5: gray85",
    "*CvoChart.color6: gray35",
    "*CvoChart.color7: gray54",
    "*CvoChart.color8: gray16",
    "*CvoChart.color9: gray79",
    "*CvoChart.color10: gray41",
    "*CvoChart.color11: gray91",
};

CONSTRUCTORS_3ARG(Cvo_Chart, Cvo_Window, "CvoChart", int,
		  Cvo_ChartOrient, Cvo_GraphObject*)
CONSTRUCTORS_2ARG(Cvo_ChartLegend, Cvo_Frame, "CvoChartLegend",
		  const Cvo_Color &, char *)
CONSTRUCTORS_2ARG(Cvo_ChartLegend, Cvo_Frame, "CvoChartLegend",
		  const Cvo_Color &, wchar_t *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Chart)

static void FillRhombus(Cvo_Window *, int x, int y,
				      int w, int h, int = 0, int = 0);
static void orienthandler(Cvo_Object *, XEvent *, void *);

void
Cvo_Chart::_Init(int nc, Cvo_ChartOrient orient, Cvo_GraphObject *o)
{
    ncolors = nc;
    ncolumns = 0;

    linecolor = Cvo_Color(this, GetResource("lineColor", "Foreground",
        "black"));
    backcolor = Cvo_Color(this, GetResource("backcolor", "Background",
        "white"), 1);
    
    colors = new Cvo_Color[ncolors];
    for (int i = 0; i < ncolors; ++i) {
        char buf[32];
        sprintf(buf, "color%d", i);
        colors[i] = Cvo_Color(this,GetResource(buf, "Color", "gray"));
    }

    VerticalChildren();

    frame1 = new Cvo_Frame("frame1", this);

    frame2 = new Cvo_Frame("frame2", this);
    frame2->ExpandFrame();
    frame2->HorizontalChildren();

    frame3 = new Cvo_Frame("frame3", this);
    frame3->HorizontalChildren();

    if (o != NULL) {
        grafik = o->CloneMe(frame2, this);
    } else {
        switch(orientation = orient) {
	case Cvo_ChartVertical:
	    grafik = new Cvo_VerticalGraph("grafik", frame2, this);
	    break;
	case Cvo_ChartHorizontal:
	    grafik = new Cvo_HorizontalGraph("grafik", frame2, this);
	    break;
	case Cvo_ChartVerticalSide:
	    grafik = new Cvo_VerticalSideGraph("grafik", frame2, this);
	    break;
	case Cvo_ChartHorizontalSide:
	    grafik = new Cvo_HorizontalSideGraph("grafik", frame2, this);
	    break;
	default:
	    fprintf(stderr,"Unknown type\n");
	    exit(1);
	    break;
	}
    }
    grafik->ExpandFrame();
    grafik->LayOpposite();

    legends = new Cvo_ChartLegend *[nc];

    legend = new Cvo_Window("legend", this);
    legend->HorizontalChildren();

    for (i = 0; i < nc; ++i) {
        legends[i] = 0;

        char *xrp;

        char buf[16];
        sprintf(buf, "legend%d", i);
        if (xrp = GetResource(buf, "Legend", 0)) {
            SetLegend(i, xrp);
        }
    }

    label = 0;

    marks = 0;
    cmarks = 0;
}

void
Cvo_Chart::SetLegend(int col, char *lab)
{
    if (col < 0 || col >= ncolors)
        return;

    if (legends[col]) {
        legends[col]->label->SetText(lab);
        return;
    }

    char buf[16];
    sprintf(buf, "legend%d", col);
    legends[col] = new Cvo_ChartLegend(buf, legend, colors[col], lab);
    legends[col]->FillFrame(False);
    if (legend->Mapped())
	legends[col]->Map();
}

void
Cvo_Chart::SetLegend(int col, wchar_t *lab)
{
    if (col < 0 || col >= ncolors)
        return;

    if (legends[col]) {
        legends[col]->label->SetText(lab);
        return;
    }

    char buf[16];
    sprintf(buf, "legend%d", col);
    legends[col] = new Cvo_ChartLegend(buf, legend, colors[col], lab);
    legends[col]->FillFrame(False);
    if (legend->Mapped())
	legends[col]->Map();
}


void
Cvo_Chart::CreateColumns (int nc)
{
    if (ncolumns) {
        while (ncolumns-- > 0)
            delete[] columns[ncolumns];
        delete[] columns;
    }

    columns = new double *[ncolumns = nc];
    while (nc-- > 0) {
        columns[nc] = new double[ncolors];
        memset(columns[nc], 0, sizeof(double) * ncolors);
    }
    grafik->dirty = True;
}

void
Cvo_Chart::SetOrientation(Cvo_ChartOrient orient)
{
    if (orient != orientation) {
        Cvo_Size mins = grafik->minSize;
        Cvo_Size defs = grafik->defSize;
        Cvo_Size maxs = grafik->maxSize;
        double min = grafik->GetMinimum();
        BOOL pixmapbacking = grafik->pixmapbacking;

        delete grafik;

        orientation = orient;
        switch(orient) {
	case Cvo_ChartVertical:
	    grafik = new Cvo_VerticalGraph("grafik", frame2, this);
	    break;
	case Cvo_ChartHorizontal:
	    grafik = new Cvo_HorizontalGraph("grafik", frame2, this);
	    break;
	case Cvo_ChartVerticalSide:
	    grafik = new Cvo_VerticalSideGraph("grafik", frame2, this);
	    break;
	case Cvo_ChartHorizontalSide:
	    grafik = new Cvo_HorizontalSideGraph("grafik", frame2, this);;
	    break;
	default:
	    fprintf(stderr,"Unknown type\n");
	    exit(1);
	    break;
	}

        grafik->ExpandFrame();
        grafik->LayOpposite();
//      grafik->minSize = mins;
//      grafik->defSize = defs;
//      grafik->maxSize = maxs;
        grafik->SetMinimum(min);

        for(Cvo_ChartMark *sm=marks;sm;sm=sm->Next())
            grafik->AddMark(sm);
        for (sm=cmarks;sm;sm=sm->Next())
            grafik->AddColumnMark(sm);

	if (marklabel)
	    grafik->SetText(marklabel);
	if (cmarklabel)
	    grafik->SetColumnText(cmarklabel);

        grafik->EvaluateMarks();
        grafik->EvaluateColumnMarks();
        grafik->Map();
    }
}

void
Cvo_ChartLegend::_Init(const Cvo_Color &col, char *lab)
{
    HorizontalChildren();
    box = new Cvo_Window("legend-box", this);
    box->SetWindowBackground(col);
    box->AspectRatio(1, 1);
    label = new Cvo_Label("legend-label", this, lab);
    label->ExpandFrame();
    label->LeftJustify();
    box->SetMinPixelSize(label->TextAttribute()->MHeight(),
            		 label->TextAttribute()->MHeight());
    ExpandFrame();
}

void
Cvo_ChartLegend::_Init(const Cvo_Color &col, wchar_t *lab)
{
    HorizontalChildren();
    box = new Cvo_Window("legend-box", this);
    box->SetWindowBackground(col);
    box->AspectRatio(1, 1);
    label = new Cvo_Label("legend-label", this, lab);
    label->ExpandFrame();
    label->LeftJustify();
    box->SetMinPixelSize(label->TextAttribute()->MHeight(),
             		 label->TextAttribute()->MHeight());
    ExpandFrame();
}

void
Cvo_Chart::Clear()
{
    ClearMarks();
    ClearColumnMarks();
    grafik->CreateColumns(1);
    Redraw();
}

void
Cvo_Chart::SetText(wchar_t *s)
{
    if (marklabel)
	delete[] marklabel;

    wchar_t *p=s;
    int len=0;
    while(*p++)
	len++;

    p = marklabel = new wchar_t [len+1];

    while (*p++ = *s++)
	    ;
    marklabel[len]='\0';

    grafik->SetText(marklabel);
}

void
Cvo_Chart::SetText(char *s)
{
    if (marklabel)
	delete[] marklabel;

    wchar_t *p;
    int len;

    p = marklabel = new wchar_t [len = strlen(s) + 1];

    _Cvo_mbstowcs(&marklabel,s,&len);

    grafik->SetText(marklabel);
}

void
Cvo_Chart::SetColumnText(wchar_t *s)
{
    if (cmarklabel)
	delete[] cmarklabel;

    wchar_t *p = s;
    int len = 0;
    while (*p++)
	len++;

    p = cmarklabel = new wchar_t [len+1];

    while (*p++ = *s++)
	;

    grafik->SetColumnText(cmarklabel);
}


void
Cvo_Chart::SetColumnText(char *s)
{
    if (cmarklabel)
	delete[] cmarklabel;

    wchar_t *p;
    int len;

    p = cmarklabel = new wchar_t [len = strlen(s) + 1];

    _Cvo_mbstowcs(&cmarklabel,s,&len);

    grafik->SetColumnText(cmarklabel);
}


void
Cvo_Chart::SetTitle(char *s)
{
    if (label) {
        label->SetText(s);
	RootObject()->ToLayoutWindow()->ReLayout(1);
    } else {
        label = new Cvo_Label("title", frame1, s);
        label->ExpandFrame();
        if (Mapped())
            label->Map();
    }
}

void
Cvo_Chart::SetTitle(wchar_t *s)
{
    if (label) {
        label->SetText (s);
    } else {
        label = new Cvo_Label ("title", frame1, s);
        label->ExpandFrame ();
        if (Mapped ())
            label->Map ();
    }
}

void
Cvo_Chart::CloneEvent(XEvent *ev, void *)
{
    Cvo_PeelOffEvent *poe = (Cvo_PeelOffEvent *)ev;
    Cvo_Chart *oc = (Cvo_Chart *)poe->peelwin;
    Cvo_Chart *nc = (Cvo_Chart *)Clone(oc);

    Cvo_Object *obj = oc;

    while (obj->Parent())
        obj = obj->Parent();

    nc->MakeTransient(obj);

    nc->ForceMoveWindow(poe->x - obj->BorderWidth(),
          		poe->y - obj->BorderWidth());

    nc->AddPin();

    nc->ForceResizeWindow(oc->Width(), oc->Height());
    nc->Map();
    nc->Flush();
}

Cvo_Object *
Cvo_Chart::Clone(Cvo_Object *old)
{
    Cvo_Chart *oc = (Cvo_Chart *)old;

    Cvo_Chart *nc = new Cvo_Chart(oc->Name(), Cvo_MAINWINDOW,
        			  oc->ncolors, oc->orientation, grafik);

    nc->minSize = oc->minSize;
    nc->defSize = oc->defSize;
    nc->maxSize = oc->maxSize;

    nc->CreateColumns(oc->ncolumns);

    for (unsigned i = 0; i < oc->ncolumns; ++i)
        for (unsigned j = 0; j < oc->ncolors; ++j)
            nc->Set(i, j, oc->columns[i][j]);

    for (Cvo_ChartMark *sm = oc->marks; sm; sm = sm->Next())
        nc->AddMark(sm->string, sm->value);

    for (sm = oc->cmarks; sm; sm = sm->Next())
        nc->AddColumnMark(sm->string, int(sm->value));

    for (i = 0; i < oc->ncolors; ++i) {
        if (oc->legends[i]) {
            nc->SetLegend(i, oc->legends[i]->label->Text());
        }
    }

    if (marklabel)
	nc->SetText(marklabel);
    if (cmarklabel)
	nc->SetColumnText(cmarklabel);

    nc->EvaluateMarks();
    nc->EvaluateColumnMarks();

    nc->SetTitle("");			// This gobbles up the default
					// title in the resources
    nc->SetTitle(oc->label->Text());	// And this one really sets the text

    return(nc);
}

void
Cvo_Chart::AddPeelOff()
{
    Cvo_PeelOff *po = new Cvo_PeelOff("peel", frame1, this);
    po->PlaceBefore(label);
    if (this->Mapped())
        po->Map();

    Register(CvoPeelOffEvent, &Cvo_Chart::CloneEvent);
}

static void
DestroyMe(Cvo_Object *, XEvent *, void *vchart)
{
    delete (Cvo_Chart *)vchart;
}

inline void
initializelist(Cvo_MenuItem *i, char *r = NULL,
	       void (*func)(Cvo_Object*,XEvent*,void*) = NULL,
               void *data = NULL, int flags = CvoM_ALWAYSFLAT)
{
    i->resource = r;
    i->func = func;
    i->data = data;
    i->flags = flags;
}

void
Cvo_Chart::AddOrientSelect(long mask)
{
    orientlist = new Cvo_MenuItem[5];
    odata = new OrientData[4];
        
    if (mask & Cvo_ChartVertical) {
        odata[0].c = this;
        odata[0].o = Cvo_ChartVertical;
        initializelist(orientlist, "vertical", orienthandler,
		       (void *)(odata+0), 0);
    } else {
        initializelist(orientlist);
    }

    if (mask & Cvo_ChartHorizontal) {
        odata[1].c = this;
        odata[1].o = Cvo_ChartHorizontal;
        initializelist(orientlist+1, "horizontal", orienthandler,
		       (void*)(odata+1), 0);
    } else {
        initializelist(orientlist+1);
    }

    if (mask & Cvo_ChartVerticalSide) {
        odata[2].c = this;
        odata[2].o = Cvo_ChartVerticalSide;
        initializelist(orientlist+2, "vertical-side", orienthandler,
		       (void*)(odata+2), 0);
    } else {
        initializelist(orientlist+2);
    }

    if (mask & Cvo_ChartHorizontalSide) {
        odata[3].c = this;
        odata[3].o = Cvo_ChartHorizontalSide;
        initializelist(orientlist+3, "horizontal-side", orienthandler,
		       (void*)(odata+3), 0);
    } else {
        initializelist(orientlist+3);
    }

    initializelist(orientlist+4,NULL,NULL,NULL,0);

    menu = new Cvo_OptionMenu("orient",frame1,orientlist);
    switch(orientation) {
    case Cvo_ChartVertical:
	menu->MakeCurrent(menu->MenuEntries());
	break;
    case Cvo_ChartHorizontal:
	menu->MakeCurrent(menu->MenuEntries()->next);
	break;
    case Cvo_ChartVerticalSide:
	menu->MakeCurrent(menu->MenuEntries()->next->next);
	break;
    case Cvo_ChartHorizontalSide:
	menu->MakeCurrent(menu->MenuEntries()->next->next->next);
	break;
    default:
	fprintf(stderr,"Unknown orientation\n");
	Cvo_Exit(1);
	break;
    }
    menu->PlaceAfter(label);
    if (this->Mapped())
        menu->Map();
}

void
orienthandler(Cvo_Object *, XEvent *, void *d)
{
    OrientData *orient = (OrientData*)d;

    orient->c->SetOrientation(orient->o);
}


void
Cvo_Chart::AddPin()
{
    Cvo_Pin *pin = new Cvo_Pin("pin", frame1);
    pin->ForceOn();
    pin->PlaceBefore(label);
    if (this->Mapped())
        pin->Map();
    pin->Register(CvoButtonUpEvent, DestroyMe, this);
}

Cvo_ChartMark*
Cvo_Chart::AddMark(char *str, double v)
{
    Cvo_ChartMark *ret = new Cvo_ChartMark(&marks, v, str);
    grafik->AddMark(ret);
    return(ret);
}

Cvo_ChartMark*
Cvo_Chart::AddColumnMark(char *str, int v)
{
    Cvo_ChartMark *ret = new Cvo_ChartMark(&cmarks, v, str);
    grafik->AddColumnMark(ret);
    return(ret);
}


Cvo_ChartMark::Cvo_ChartMark(Cvo_ChartMark **root, double v, char *str)
        : Cvo_RootedList((Cvo_RootedList **)root)
{
    value = v;
    string = new char[strlen(str)+1];
    strcpy(string,str);
}

void
Cvo_Chart::ClearMarks()
{
    while(marks)
        RemoveMark(marks);
    grafik->ClearMarks();
}


void
Cvo_Chart::ClearColumnMarks()
{
    while(cmarks)
        RemoveColumnMark(cmarks);
    grafik->ClearColumnMarks();
}

void
Cvo_Chart::RemoveMark(Cvo_ChartMark *sm)
{
    sm->Unlink((Cvo_RootedList**)&marks);
    delete sm;
}

void
Cvo_Chart::RemoveColumnMark(Cvo_ChartMark *sm)
{
    sm->Unlink((Cvo_RootedList**)&cmarks);
    delete sm;
}
