//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Button.cc,v 1.5 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/Button.h++>
#include <string.h>

static Cvo_Default def[] = {
    "*CvoButton.Cursor:Top Left Arrow",
    "*CvoButton.Pad:2",
    "*CvoButton.FontWeight:Bold",
};

CONSTRUCTORS(Cvo_Button, Cvo_BasicButton, "CvoButton")
CONSTRUCTORS_1ARG(Cvo_Button, Cvo_BasicButton, "CvoButton", char *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Button)

void
Cvo_Button::_Init()
{   CVO_ENTER
    type = CvoT_Button;
    LoadFont();
    label = GetNewResource(_Qlabel, _QLabel, 0);
    Register(Expose, &Cvo_Button::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_Button::SetDefaultText(char *s)
{   CVO_ENTER
    if (!label) {
        label = new char[strlen(s)+1];
        strcpy(label, s);
    }
    CVO_VOID_RETURN
}

void
Cvo_Button::SetText(char *s)
{   CVO_ENTER
    delete [] label;
    label = new char[strlen(s)+1];
    strcpy(label, s);

    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_Button::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    if (!label)
	CVO_VOID_RETURN
    SetGC(CurrentBackground(), CurrentForeground());
    DrawStrings(leftjustify ? Cvo_LEFT_JUSTIFY :
		rightjustify ? Cvo_RIGHT_JUSTIFY :
		0,
		0, 0, Width(), Height(), label);
    CVO_VOID_RETURN
}

CARD16
Cvo_Button::CalculateWidth()
{   CVO_ENTER
    if (!label)
	CVO_RETURN(0);
    XRectangle log;

    StringsExtents(label, -1, log);
    CVO_RETURN(log.width)
}

CARD16
Cvo_Button::CalculateHeight()
{   CVO_ENTER
    XRectangle log;
    if (!label)
	CVO_RETURN(0);

    StringsExtents(label, -1, log);
    CVO_RETURN(log.height)
}
