//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: AssociatedData.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Object.h++>

Atom Cvo_AssociatedData::atom_max = Atom(0);
char **Cvo_AssociatedData::atom_list = 0;
Atom Cvo_AssociatedData::atom_list_max = Atom(0);

Cvo_Atom::Cvo_Atom(char *s)
{
    for (atom = 0; atom < Cvo_AssociatedData::atom_max; ++atom) {
	if (!strcmp(Cvo_AssociatedData::atom_list[atom], s))
	    return;
    }
    atom = Cvo_AssociatedData::atom_max++;
    if (atom == Cvo_AssociatedData::atom_list_max) {
	Cvo_AssociatedData::atom_list_max += 8;

	char **al = new char *[int(Cvo_AssociatedData::atom_list_max)];
	for (Atom i = 0; i < atom; ++i)
	    al[i] = Cvo_AssociatedData::atom_list[i];
	delete [] Cvo_AssociatedData::atom_list;
	Cvo_AssociatedData::atom_list = al;
    }

    Cvo_AssociatedData::atom_list[atom] = new char [strlen(s) + 1];
    strcpy(Cvo_AssociatedData::atom_list[atom], s);
}

Cvo_AnyData &
Cvo_AssociatedData::Init(Atom a)
{
    if (a == Atom(-1))
	Cvo_Failure(CvoE_ABORT, CvoE_UNITATOM, "Atom is uninitialized\n");
    if (a >= atom_max) {
	if (a == 0) {
	    Cvo_Failure(CvoE_WARN, CvoE_BADCLIB,
			"Global constructors were probably not called.\n");
	    Cvo_Failure(CvoE_WARN, CvoE_BADCLIB2,
			"The application was probably linked improperly\n");
	}
	Cvo_Failure(CvoE_ABORT, CvoE_BADATOM, "Atom %ld is out of range\n", a);
    }

    Cvo_AnyData *d = new Cvo_AnyData[int(atom_list_max)];

    for (Atom i = 0; i < max; ++i)
	d[i] = data[i];

    delete [] data;
    data = d;

    while (max < atom_list_max) {
	data[max] = (long)0;
	data[max] = (void *)0;
	++max;
    }

    return(data[a]);
}
