//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Toggle.h++,v 1.4 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Toggle_)
#define	_Cvo_Toggle_

#if	!defined(_Cvo_Button_)
#include <Cvo/Button.h++>
#endif
#if	!defined(_Cvo_Label_)
#include <Cvo/Label.h++>
#endif

class Cvo_Toggle : public Cvo_Window {
protected:
    BOOL	toggle:1;		// 1 -> toggled on

private:
    void _Init()			{ type = CvoT_Toggle; toggle = 0; }
public:
    CONSTRUCDECL(Cvo_Toggle)
    void Toggle() 			{ toggle ^= 1; Redraw(); }
    void ForceOn() 			{ toggle = 1; Redraw(); }
    void ForceOff() 			{ toggle = 0; Redraw(); }
};

class Cvo_SquareToggle : public Cvo_Toggle {
protected:
    CARD16		inset;		// Depth of the toggle

private:
    void _Init();
protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_SquareToggle)
    void ExposureHandler(XEvent * = 0, void * = 0);
public:
    CONSTRUCDECL(Cvo_SquareToggle)
    CARD16 CalculateWidth()		{ return(inset * 3); }
    CARD16 CalculateHeight()		{ return(inset * 3); }
};

class Cvo_BasicToggleButton : public Cvo_BasicButton {
protected:
    unsigned		pressed:1;	// Set if in pressed position

private:
    void _Init()			{ type = CvoT_BasicToggleButton;
					   pressed = 0; }
public:
    CONSTRUCDECL(Cvo_BasicToggleButton)
    void LocalDown(XEvent *, int, char **)	{ Toggle(); }
    void LocalUp(XEvent *, int, char **)	{ ; }

    virtual void Toggle();
    void ForceOn();
    void ForceOff();
    virtual void Update();
    int Pressed()			{ return(pressed); }
};

class Cvo_ToggleButton : public Cvo_BasicToggleButton {
protected:
    char		*label;

private:
    void _Init();
    void _Init(char *s)			{ _Init(); SetDefaultText(s); }
protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_ToggleButton)
    void ExposureHandler(XEvent * = 0, void * = 0);
public:
    CONSTRUCDECL(Cvo_ToggleButton)
    CONSTRUCDECL_1ARG(Cvo_ToggleButton, char *)
    // XXX - should support wchar_t * as well.

    ~Cvo_ToggleButton()			{ delete [] label; }
    void SetText(char *s);
    void SetDefaultText(char *s);
    void Update();
    CARD16 CalculateWidth();
    CARD16 CalculateHeight();
};

class Cvo_SquareToggleButton : public Cvo_BasicToggleButton {
protected:
    Cvo_SquareToggle	*tog;
    Cvo_Label		*lab;
private:
    void _Init();
    void _Init(char *s)			{ _Init(); SetText(s); }
    void _Init(wchar_t *s)		{ _Init(); SetText(s); }
public:
    CONSTRUCDECL(Cvo_SquareToggleButton)
    CONSTRUCDECL_1ARG(Cvo_SquareToggleButton, char *)
    CONSTRUCDECL_1ARG(Cvo_SquareToggleButton, wchar_t *)
    ~Cvo_SquareToggleButton()		{ delete tog; delete lab; }
    void Update();
    void SetText(char *s);
    void SetText(wchar_t *s);
    void SetDefaultText(char *s)	{ if (!lab) SetText(s); }
    void SetDefaultText(wchar_t *s)	{ if (!lab) SetText(s); }
};

#endif
