//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: TextBoard.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_TextBoard_)
#define	_Cvo_TextBoard_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif
#if	!defined(_Cvo_RootedList_)
#include <Cvo/RootedList.h++>
#endif

class Cvo_TextBoardItem : public Cvo_RootedList {
public:
    char		*string;
    int			x;
    int			y;

    Cvo_TextBoardItem(Cvo_TextBoardItem **, char *);
    ~Cvo_TextBoardItem()		{ delete [] string; }
    void SetLocation(int nx, int ny)	{ x = nx; y = ny; }
    Cvo_TextBoardItem *Next() { return((Cvo_TextBoardItem *)(next)); }
    Cvo_TextBoardItem *Prev() { return((Cvo_TextBoardItem *)(prev)); }
};

class Cvo_TextBoard : public Cvo_Window {
    Cvo_TextBoardItem		*items;
    void _Init();

protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_TextBoard)
    void ExposureHandler(XEvent * = 0, void * = 0);

public:
    CONSTRUCDECL(Cvo_TextBoard)
    Cvo_TextBoardItem *AddString(char *str, int x = -1, int y = -1);
    void RemoveString(Cvo_TextBoardItem *tbi)
			{ tbi->Unlink((Cvo_RootedList **)&items); delete tbi; }
    void Erase();
};
#endif
