//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Text.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Text_)
#define	_Cvo_Text_

#if	!defined(_Cvo_CRT_)
#include <Cvo/CRT.h++>
#endif

#include <limits.h>

#define	CvoT_MAXOPTS	8
#define	CvoT_MAXSTR	128		// Maximum # of chars in a ^[] string

class Cvo_Text : public Cvo_CRT {
    int		options[CvoT_MAXOPTS+1];
    int		table;
    int		options_index;
    BOOL	rawtext:1;
    int		mbtmp_index:4;
    char	mbtmp[MB_LEN_MAX];

    CARD16	save_cursor_x;
    CARD16	save_cursor_y;

    CARD16	my_cursor_x;
    CARD16	my_cursor_y;

    wchar_t     krbstr[CvoT_MAXSTR];	// String from ^[] sequence
    wchar_t    *krbptr;    	 	// Current location in tx_krbstr

    void _Init();
public:
    CONSTRUCDECL(Cvo_Text)
    void Putc(char c);
    void Putc(wchar_t c);
    void Puts(char *s);
    void Puts(wchar_t *s)		{ while (*s) Putc(*s++); }
    void Write(wchar_t *s, int cnt)	{ while (cnt-- > 0) Putc(*s++); }
    void Write(char *s, int cnt);
    void Cooked()			{ rawtext = 0; }
    void Raw()				{ rawtext = 1; }
    int NLines()		{ return(rows); }
    int NCols()			{ return(Width()/TextAttribute()->MWidth()); }
    void MoveCursor(int y, int x)
	{ if (y < 0) y = 0;
	  if (x < 0) x = 0;
	  Cvo_CRT::MoveCursor(my_cursor_y = y, my_cursor_x = x); }
    void VisualBell();
};
#endif
