//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: RootedList.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_RootedList_)
#define	_Cvo_RootedList_

//
// A Rooted list is a modified doubly linked list
// The head's prev pointer points to the tail
// The tail's next pointer is NULL
// If an entry is created with NULL passed as the pointer to the root pointer,
// it is created without be connected to any list.
//
class Cvo_RootedList {
protected:
    Cvo_RootedList	*next;
    Cvo_RootedList	*prev;
    Cvo_RootedList(Cvo_RootedList **, int (*)(Cvo_RootedList *,
                                              Cvo_RootedList *) = 0);
    void Insert(Cvo_RootedList **, int (*)(Cvo_RootedList *,
                                           Cvo_RootedList *) = 0);
    void ReInsert(Cvo_RootedList **, int (*)(Cvo_RootedList *,
                                             Cvo_RootedList *));
    friend void Cvo_RootedList_Sort(Cvo_RootedList **,
				    int (*)(Cvo_RootedList *,
					    Cvo_RootedList *));
public:
    void Unlink(Cvo_RootedList **);
};

#endif
