//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: List.h++,v 1.3 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_List_)
#define	_Cvo_List_

#if	!defined(_Cvo_TextViewPort_)
#include <Cvo/TextViewPort.h++>
#endif

class Cvo_List : public Cvo_TextViewPort {
    int			current;		// Current item selected
    BOOL		radiostyle:1;
    BOOL		reselect:1;
    void _Init(Cvo_Page *);
protected:
    int Special(int x)		{ return(x == current ? CvoTVP_RAISED : 0); }
    void Bind();
public:
    CONSTRUCDECL_1ARG(Cvo_List, Cvo_Page *)
    virtual void Down(XEvent *, int, char **);
    virtual void Up(XEvent *, int, char **);
    friend void Cvo_List_PageChanged(Cvo_Object *, XEvent *, void *);
    void ClearSelected();
    void NewTextPage(Cvo_Page *);
    void UseRadioStyle(BOOL v = True)	{ radiostyle = v; }
    void AllowReselect(BOOL v = True)	{ reselect = v; }
    void Select(int line, int count = 0, int button = 0);
    int Current()			{ return(current); }
};

inline void
Cvo_List::ClearSelected()
{
    if (current >= firstline && current <= lastline) 
	text->FlattenLine(current - firstline);
    current = -1;
}

inline void
Cvo_List::NewTextPage(Cvo_Page *p)
{
    //
    // Allow the user to specify a NULL page to get the
    // list to reevaluate itself. This allows, albeit
    // manually, more than one list to contribute to a page.
    //
    if (p != NULL)
	    page = p;
    Cvo_TextViewPort_PageChanged(this,NULL,this);
}

#define	CvoListItemSelectedEvent	(Cvo_ListEventType + InternalEvent0)

struct Cvo_ListItemSelectedEvent : Cvo_AnyEvent {
    int             line;
    void	    *item;
    int             button;		// Which button was pressed
    int             oldline;		// previous line selected
    int		    count;		// Click count
};

#endif
