//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: FilePage.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_FilePage_)
#define	_Cvo_FilePage_
#if     !defined(_Cvo_Page_)
#include <Cvo/Page.h++>
#endif

#define	Cvo_FILEPAGE_BLOCK	100

class Cvo_FilePageBlock {
    int		fline;
    int		lline;
    char	*block;
    char	*lines[Cvo_FILEPAGE_BLOCK+1];
public:
    Cvo_FilePageBlock(CARD s)	{ lline = -1; block = new char[s]; }
    ~Cvo_FilePageBlock()	{ delete [] block; }
    char *Line(CARD x)		{ return (lline > int(x) && fline <= int(x)
					    ? lines[x - fline] : 0); }
    void Load(FILE *fp, CARD line, off_t start, off_t end);
};

class Cvo_FilePage : public Cvo_Page {
protected:
    FILE		*fp;
    off_t		*offsets;
    int			nlines;
    int			maxblock;
    Cvo_FilePageBlock	*block1;
    Cvo_FilePageBlock	*block2;
    void _Init();
public:
    Cvo_FilePage(char *);
    Cvo_FilePage(FILE *);
    ~Cvo_FilePage();

    int NumberLines()				{ return(nlines); }
    void *GetLine(CARD);
    void *GetLine(CARD, Cvo_CharacterBuffer *);
    void Draw(CARD, const XRectangle &clip, int x, int y);
    CARD Width(CARD);
    CARD Height(CARD);
    CARD TotalHeight();

//  Cvo_TextAttribute *GetAttribute(CARD)	{ return(0); }
//  Cvo_TextAttribute **GetAttributes(CARD)	{ return(0); }
};
#endif
