//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: ExpandPage.h++,v 1.3 1994/08/10 18:11:11 prb Exp $
//
#if     !defined(_Cvo_ExpandPage_)
#define _Cvo_ExpandPage_

#include <Cvo/Page.h++>
#include <Cvo/Buffer.h++>

class Cvo_ExpandPageSet;
class Cvo_ExpandPage;

class Cvo_ExpandPageLine {
    friend Cvo_ExpandPageSet;
    friend Cvo_ExpandPage;

    wchar_t		*text;
    int			length;
    Cvo_ExpandPageSet	*hierarchy;
    void		*adata;
    BOOL		closed:1;
    BOOL		hidden:1;

    void Zap()				{ text = 0; length = 0; hierarchy = 0;
					  adata = 0;
					  closed = True; hidden = False; }
    inline ~Cvo_ExpandPageLine();
    Cvo_ExpandPageLine()			{ Zap(); }
    int	NumberLines();
public:
    Cvo_ExpandPageSet *Hierarchy()		{ return(closed ? 0 : hierarchy); }
    Cvo_ExpandPageSet *AddHierarchy();
    void SetText(wchar_t *, int, void *);
    void Close(BOOL v = True)		{ closed = v; }
    BOOL SubPage()			{ return(hierarchy ? True : False); }
    BOOL Closed()			{ return(closed || !hierarchy); }
    wchar_t *Text()			{ return(text); }
    int Length()			{ return(length); }
    void *GetAssociatedData()		{ return(adata); }
    void Hide(BOOL v = True)		{ hidden = v; }
};

class Cvo_ExpandPageSet {
    friend Cvo_ExpandPageLine;
    friend Cvo_ExpandPage;

    Cvo_ExpandPageLine	*items;
    int			nitems;
    int			maxitems;

    Cvo_ExpandPageSet()			{ items = 0; nitems = 0; maxitems = 0; }
    ~Cvo_ExpandPageSet()			{ delete [] items; }
    Cvo_ExpandPageLine *Item(CARD &, CARD &);
    int	NumberLines();
    BOOL DeleteItem(Cvo_ExpandPageLine *hi);
    void DeleteItem(CARD &n);
    void HideItem(CARD n, BOOL);
public:
    Cvo_ExpandPageLine *AppendItem(wchar_t *, int, void *);
    Cvo_ExpandPageLine *AppendItem(char *, int, void *);
    Cvo_ExpandPageLine *AppendItem(wchar_t *t, void *v = 0)
				    { return(AppendItem(t, -1, v)); }
    Cvo_ExpandPageLine *AppendItem(char *t, void *v = 0)
				    { return(AppendItem(t, -1, v)); }
};

class Cvo_ExpandPage : public Cvo_Page {
    Cvo_ExpandPageSet	hierarchy;
    BOOL output : 1;
    BOOL newlines : 1;
    BOOL changedlines : 1;
    BOOL removedlines : 1;
    void SendPageEvent();
public:
    Cvo_ExpandPage()		{ newlines = False; changedlines = False;
				  removedlines = False; output = True; }
    int NumberLines()		{ return(hierarchy.NumberLines()); }
    void *GetLine(CARD);
    void *GetLine(CARD, Cvo_CharacterBuffer *);
    void Draw(CARD, const XRectangle &clip, int x = 0, int y = 0);
    CARD Width(CARD);
    CARD Height(CARD);
    BOOL HandlePress(CARD, int, int, XEvent *);
    Cvo_ExpandPageSet *Hierarchy()		{ return(&hierarchy); }

    Cvo_ExpandPageLine *AppendItem(wchar_t *t, int n, void *v = 0)
				    { return(hierarchy.AppendItem(t, n, v)); }
    Cvo_ExpandPageLine *AppendItem(char *t, int n, void *v = 0)
				    { return(hierarchy.AppendItem(t, n, v)); }
    Cvo_ExpandPageLine *AppendItem(wchar_t *t, void *v = 0)
				    { return(hierarchy.AppendItem(t, -1, v)); }
    Cvo_ExpandPageLine *AppendItem(char *t, void *v = 0)
				    { return(hierarchy.AppendItem(t, -1, v)); }
    void DeleteItem(Cvo_ExpandPageLine *hi)	{ hierarchy.DeleteItem(hi); }
    void DeleteItem(CARD n)		{ hierarchy.DeleteItem(n); }
    void HideItem(Cvo_ExpandPageLine *hi, BOOL v = True)
					{ hi->Hide(v); }
    void HideItem(CARD n, BOOL v = True){ hierarchy.HideItem(n, v); }
    void *GetAssociatedData(CARD);
    void DisableDisplay()               { output = 0;           }
    void EnableDisplay()                { output = 1; SendPageEvent(); }
};

inline
Cvo_ExpandPageLine::~Cvo_ExpandPageLine()
{
    delete [] text;
    delete hierarchy;
}
#endif
