//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: EventTypes.h++,v 1.5 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_EventTypes_)
#define	_Cvo_EventTypes_
struct Cvo_AnyEvent : XAnyEvent {
	Cvo_Object	*win;
};

//
// Note that because some machines might have a 16 bit int, you should
// not have a type greater than 0x0000ff00 (Cvo_UserEventType).
// Lets hope that 255 event types are enough.  If not, it would be best to
// change the event mask to be 0x7f instead of 0xff and then add an extra
// bit downward for new event types.
//
// Otherwise we should have an extra field in Cvo_AnyEvent that is a CARD32
// which would contain the full event code and the type would only be the
// lower bits of the code.
//

#define	Cvo_ButtonEventType	0x00000100
#define	Cvo_InputEventType	0x00000200
#define	Cvo_ListEventType	0x00000300
#define	Cvo_OpenFileEventType	0x00000400
#define	Cvo_PageEventType	0x00000500
#define	Cvo_ScrollBarEventType	0x00000600
#define	Cvo_SkylineEventType	0x00000700
#define	Cvo_TextEventType	0x00000800
#define	Cvo_TreeEventType	0x00000900
#define	Cvo_RadioBoxEventType	0x00000a00
#define	Cvo_MiscEventType	0x00000b00
#define	Cvo_MPPEventType	0x00000c00
#define	Cvo_PiechartEventType	0x00000d00
#define	Cvo_MenuEventType	0x00000e00
#define	Cvo_ToolTalkEventType	0x00000f00
#define	Cvo_WindowViewPortType	0x00001000
#define	Cvo_PeelOffEventType	0x00001100
#define	Cvo_PaintEventType	0x00001200
#define	Cvo_ChartEventType	0x00001300
#define	Cvo_ShellEventType	0x00001400
#define	Cvo_IwinEventType	0x00001500
#define	Cvo_HelpEventType	0x00001600

#define Cvo_UserEventType   	0x0000ff00

#define	CvoHelpEvent			(Cvo_MiscEventType + InternalEvent0)
#define	CvoDestroyedEvent		(Cvo_MiscEventType + InternalEvent1)
#define	CvoResizeEvent			(Cvo_MiscEventType + InternalEvent2)
#define	CvoMovedEvent			(Cvo_MiscEventType + InternalEvent3)
#define	CvoFocusInEvent			(Cvo_MiscEventType + InternalEvent4)
#define	CvoFocusOutEvent		(Cvo_MiscEventType + InternalEvent5)
#define	CvoMapRequestEvent		(Cvo_MiscEventType + InternalEvent6)
#define	CvoUnmapRequestEvent		(Cvo_MiscEventType + InternalEvent7)
#define	CvoCreatedEvent			(Cvo_MiscEventType + InternalEvent8)
#define	CvoPreMapRequestEvent		(Cvo_MiscEventType + InternalEvent9)
#define	CvoCreatedChildEvent		(Cvo_MiscEventType + InternalEvent10)
#define	CvoExitEvent			(Cvo_MiscEventType + InternalEvent11)
#define	CvoBindEvent			(Cvo_MiscEventType + InternalEvent12)
#define	CvoDestroyedChildEvent		(Cvo_MiscEventType + InternalEvent13)
#define	CvoDeleteWindowEvent		(Cvo_MiscEventType + InternalEvent14)
#define	CvoDismissedEvent		(Cvo_MiscEventType + InternalEvent15)

//
// This one is different because we need to use the 0x0000ff00 bits for
// the state of the button mask, just as in a KeyPress.  This number evaluates
// to 47, so we hope X11 doesn't get up that far anytime soon.
//
#define	CvoKeyTextEvent			(InternalEvent0-1)

typedef Cvo_AnyEvent	Cvo_DestroyedEvent;
typedef Cvo_AnyEvent	Cvo_CreatedEvent;
typedef Cvo_AnyEvent	Cvo_BindEvent;
typedef Cvo_AnyEvent	Cvo_DeleteWindowEvent;

struct Cvo_KeyTextEvent : Cvo_AnyEvent {
    Window	root;	        // root window that the event occured on
    Window	subwindow;	// child window
    Time	time;		// milliseconds
    int		x, y;		// pointer x, y coordinates in event window
    int		x_root, y_root;	// coordinates relative to root
    CARD	state;		// key or button mask
    CARD	keycode;	// detail
    BOOL	same_screen:1;	// same screen flag
    BOOL	have_sym;	// True if keysym is set
    BOOL	have_text;	// True if text is set

    KeySym		keysym;		// The possible keysym
    Cvo_CharacterBuffer	*text;		// The possible text generated
};

struct Cvo_ResizeEvent : Cvo_AnyEvent {
    int		old_width;
    int		old_height;
    int		new_width;
    int		new_height;
    int		tag;			// A Tag to indicate who did the resize
};

struct Cvo_MovedEvent : Cvo_AnyEvent {
    int		old_x;
    int		old_y;
    int		new_x;
    int		new_y;
    int		tag;			// A Tag to indicate who did the move
};

struct Cvo_CreatedChildEvent : Cvo_AnyEvent {
    Cvo_Object	*child;
};

struct _Cvo_XButtonEvent : XButtonEvent {
    int		count;			// count of times pressed (dblclk)
    BOOL	multiclick:1;		// True if a multiclick happened
};

#define	Cvo_LAYOUTTAG	0x8001		// Generated from Layout
#define	Cvo_CONFIGTAG	0x8002		// Generated from Configure

void Cvo_PrintEvent(FILE *, XEvent *, Cvo_Object * = 0);
void Cvo_SetPrintEventFilter(BOOL (*ef)(Cvo_Object *, XEvent *));

#endif
