//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Cursor.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Cursor_)
#define	_Cvo_Cursor_

class _Cvo_Cursor;

class Cvo_Cursor {
    _Cvo_Cursor  *realcursor;
    inline Cvo_Cursor(_Cvo_Cursor *rc)	{ realcursor = rc; }
public:
    Cvo_Cursor(Cvo_Object *, char *);
    Cvo_Cursor(Cvo_Object *, unsigned);
    Cvo_Cursor(Cvo_Object *, const Cvo_Cursor &);

    inline Cvo_Cursor()			{ realcursor = 0; }
    inline ~Cvo_Cursor();
    inline Cvo_Cursor(const Cvo_Cursor &);
    inline Cvo_Cursor &operator=(const Cvo_Cursor &);

    _Cvo_Cursor *operator->() const	{ return(realcursor); }

    BOOL Empty() const			{ return(realcursor ? False : True); }
    BOOL Full() const			{ return(realcursor ? True : False); }
    int operator ==(const Cvo_Cursor &cc) const
					{ return(cc.realcursor == realcursor); }
    int operator !=(const Cvo_Cursor &cc) const
					{ return(cc.realcursor != realcursor); }
};

class _Cvo_Cursor {
    friend Cvo_Cursor;
    static _Cvo_Cursor	*root;		// Root of all cursors
    _Cvo_Cursor		*next;		// Next cursor in list
    Display		*dpy;		// A display this cursor was created on
    int			refcnt;		// Reference count
    CARD32		fore;		// Foreground color
    CARD32		back;		// Background color
    unsigned		index;		// Cursor cursor index
    Cursor		cursor;		// Actual cursor
    ~_Cvo_Cursor();
    _Cvo_Cursor();
    _Cvo_Cursor* Copy()			{ ++refcnt; return(this); }
    void Release()			{ if (--refcnt <= 0) delete this; }
    static _Cvo_Cursor *LoadCursor(Cvo_Object *, unsigned);
public:
    Cursor CursorValue()		{ return(cursor); }
};

//
// Inlines for Cvo_Cursor
//
inline
Cvo_Cursor::Cvo_Cursor(const Cvo_Cursor &cc)
{
    if (cc.realcursor)
        realcursor = cc->Copy();
    else
        realcursor = 0;
}

inline Cvo_Cursor &
Cvo_Cursor::operator=(const Cvo_Cursor &cc)
{
    if (realcursor != cc.realcursor) {
        if (realcursor)
            realcursor->Release();
        if (cc.realcursor)
            realcursor = cc->Copy();
        else
            realcursor = 0;
    }
    return(*this);
}

inline
Cvo_Cursor::~Cvo_Cursor()
{
    if (realcursor)
        realcursor->Release();
}
#endif
