//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: ButtonMenu.h++,v 1.3 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_ButtonMenu_)
#define	_Cvo_ButtonMenu_

#if	!defined(_Cvo_MenuBar_)
#include <Cvo/MenuBar.h++>
#endif
#if	!defined(_Cvo_BasicButton_)
#include <Cvo/BasicButton.h++>
#endif
#if	!defined(_Cvo_MenuLabel_)
#include <Cvo/MenuLabel.h++>
#endif

class Cvo_MenuBarFilter;

class Cvo_ButtonMenu : public Cvo_MenuLabel {
    friend Cvo_MenuBarFilter;

    Cvo_MenuItem      *menuitems;	// Items the user passed in
    int               waitcnt;		// how many buttons need to go up
    Cvo_Menu	      *menu;		// The menu when it is up
    Cvo_MenuBar       *bar;		// Menu bar this is on (if any)
    int               cnt;
    BOOL	      flat:1;
    void _Init(Cvo_MenuItem *, Cvo_MenuBar * = 0);
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_ButtonMenu)
    void Start(XEvent *, void *);
    static void CallMe(Cvo_Object *, XEvent *, void *);
    static void Destroyed(Cvo_Object *, XEvent *, void *);
protected:
    void Bind();
public:
    CONSTRUCDECL_1ARG(Cvo_ButtonMenu, Cvo_MenuItem *)
    CONSTRUCDECL_2ARG(Cvo_ButtonMenu, Cvo_MenuItem *, Cvo_MenuBar *)

    void Down(XEvent *, int, char **);
    void Up(XEvent *, int, char **);  
    void ForceDown(); 
    void ForceUp(BOOL v = True);
    void ForceRelease()             { cnt = 0; }
    virtual void LocalDown(XEvent *, int, char **); 
    virtual void LocalUp(XEvent *, int, char **);   

    void _Create();
    void Accelerate();
    Cvo_Menu *Menu()			{ return(menu); }
    Cvo_MenuBar *Bar()			{ return(bar); }
};

class Cvo_ButtonMenuFilter : public Cvo_MenuSessionFilter {
public:
    Cvo_MenuSessionFilterResponse Filter(Cvo_Object *, XEvent *);
};  

class Cvo_MenuBarFilter : public Cvo_MenuSessionFilter {
    Cvo_MenuBar		*bar;
    Cvo_ButtonMenu	*menu;
public:
    Cvo_MenuBarFilter(Cvo_ButtonMenu *, Cvo_MenuBar *);
    Cvo_MenuSessionFilterResponse Filter(Cvo_Object *, XEvent *);
};  
#endif
