//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Base.h++,v 1.8 1994/09/13 15:43:02 prb Exp $
//
#if	!defined(_Cvo_Base_)
#define	_Cvo_Base_

#if	!defined(_Cvo_Ev_)
#include <Cvo/Ev.h++>
#endif
#include <sys/types.h>
#include <Cvo/MWM.h++>
#include <Cvo/RootedList.h++>

class Cvo_Object;
class Cvo_Font;
class _Cvo_Font;
class _Cvo_Color;

struct _Cvo_XButtonEvent;

class _Cvo_ButtonData {
	Cvo_Object	*lastobject;
	Time		lastrelease;
	int		lastx;
	int		lasty;
	int		laststate;
	CARD16		count;
	BOOL		multiclick:1;
public:
	_Cvo_ButtonData	()	{ lastobject = 0;
				  lastrelease = 0;
				  laststate = 0;
				  lastx = 0;
				  lasty = 0;
				  count = 0;
				  multiclick = False; }
	void Release(Cvo_Object *, _Cvo_XButtonEvent *);
	void Count(Cvo_Object *, _Cvo_XButtonEvent *);
};

class Cvo_AnyData {
    union {
        void *void_data;
        long word_data;
    } u;
public:
    Cvo_AnyData()		{ ; }
    Cvo_AnyData(Cvo_AnyData &d) { u = d.u; }
    Cvo_AnyData(void * v)       { u.void_data = v; }
    Cvo_AnyData(long w)         { u.word_data = w; }

#if !defined(__REF_POINTER_BUG__)
    operator void *&()          { return(u.void_data); }
#endif
    operator long&()            { return(u.word_data); }
};

class Cvo_Atom {
    Atom	atom;
public:
    Cvo_Atom()				{ atom = Atom(-1); }
    Cvo_Atom(Atom a)			{ atom = a; }
    Cvo_Atom(char *s);
    operator Atom&()			{ return(atom); }
    BOOL Initialized()			{ return(atom != Atom(-1)); }
};

class Cvo_AssociatedData {
    friend Cvo_Atom;
    static Atom         atom_max;
    static Atom         atom_list_max;
    static char         **atom_list;
    Atom		max;
    Cvo_AnyData         *data;

    Cvo_AnyData &Init(Atom);
public:
    Cvo_AssociatedData()                { data = 0; max = 0; }
    Cvo_AnyData &operator [](int i)     { return(i < max ? data[i] : Init(i)); }
};

enum _Cvo_Protocols {
	CvoP_DELETE_WINDOW = 0,
	CvoP_LAST_PROTOCOL,
	CvoA_MOTIF_WM_HINTS,
	CvoA_MOTIF_WM_MESSAGES,
	CvoA_MOTIF_WM_OFFSET,
	CvoA_MOTIF_WM_MENU,
	CvoA_MOTIF_BINDINGS,
	CvoP_LAST
};

class Cvo_Accelerator : public Cvo_RootedList {
    CARD		state;
    KeyCode		key;
    void		*data;
    void		(*func)(Cvo_Object *, XEvent *, void *);

    void _Init(KeyCode, CARD, void (*)(Cvo_Object *, XEvent *, void *), void *);
public:
    Cvo_Accelerator(Cvo_Accelerator **, KeyCode, CARD, 
		    void (*)(Cvo_Object *, XEvent *, void *), void * = 0);
    Cvo_Accelerator(Cvo_Accelerator **, KeyCode, 
		    void (*)(Cvo_Object *, XEvent *, void *), void * = 0);

    Cvo_Accelerator *Next() { return((Cvo_Accelerator *)(next)); }
    Cvo_Accelerator *Prev() { return((Cvo_Accelerator *)(prev)); }
    BOOL Check(Cvo_Object *, XEvent *ev);
    BOOL CheckOnly(Cvo_Object *, XEvent *ev);
};

class Cvo_DisplayList {
	Display			*dpy;
	int			refcnt;
	Cvo_DisplayList		*next;
	Cvo_DisplayList		*prev;
	Cvo_Object		*main;		// Main object
	_Cvo_Font		*fonts;		// List of fonts open
#if !defined(X11R4)
	XIM			input_method;
	XIMStyle		input_style;
#endif
	EvInputEvent		*ei;		// Our Input Event handler
	Cvo_Object		*focus;		// Object currently focused on
	Window			fwindow;
	int			revert_to;
    	Cvo_Accelerator		*accelerators;
	BOOL			clicktotype : 1;
public:
	BOOL			loadingfont : 1;
	BOOL			ineventloop : 1;
	BOOL			mousegrabbed : 1;
	BOOL			kbdgrabbed : 1;
	_Cvo_Color		*colors;
	_Cvo_ButtonData		buttons[5];
	int                 	clickrate; // How fast to click to get dblclk
	int                 	clickmove; // How far can move and still dlbclk

	Cvo_AssociatedData	associatedData;
	char			*tt_procid;
	int			tt_refcnt;
	Atom			*protocols;
    	int			max_keypermod;
    	KeySym			*modifiermap;

	void ReadResources();
public:
	static Cvo_DisplayList	*root;

	Cvo_DisplayList(Display *_dpy);
	~Cvo_DisplayList();
	int Remove(Display *_dpy);
	int Add(Display *_dpy);
	Display *FindDisplay(int fd);
	Cvo_DisplayList *FindDisplayList(Display *);

	Display *Dpy()			{ return(dpy); }
	Cvo_DisplayList *Next()		{ return(next); }
	_Cvo_Font *Fonts()		{ return(fonts); }
	inline Cvo_Font Font();
	void Set1stFont(_Cvo_Font *f)	{ fonts = f; }
#if !defined(X11R4)
	void SetInputMethod(XIM i)	{ input_method = i; }
	void SetInputStyle(XIMStyle s)	{ input_style = s; }
	XIM InputMethod()		{ return(input_method); }
	XIMStyle InputStyle()		{ return(input_style); }
#endif
	void GiveFocus(Cvo_Object *obj, int = RevertToPointerRoot);
	Cvo_Object *Focus()		{ return(focus); }
	BOOL ClickToType()		{ return(clicktotype); }
    	void MakeClickToType(BOOL v = True)	{ clicktotype = v; }

        void OutFocus();
        void InFocus(Cvo_Object *);

	char * GetResource(char *_name, char *_class, char *_default = 0);
	BOOL GetResourceTruth(char *_name, char *_class, BOOL);
	int GetResourceInt(char *_name, char *_class, int);
	char * Get(XrmQuarkList qname, XrmQuarkList qclass,
                   XrmQuark cname = 0, XrmQuark cclass = 0);

	void BRelease(Cvo_Object *, _Cvo_XButtonEvent *);
	void BCount(Cvo_Object *, _Cvo_XButtonEvent *);
	int ClickRate() 		{ return(clickrate); }
	int ClickMove() 		{ return(clickmove); }

	Cvo_Object *GetGroup(Cvo_Object *o)
					{ return(main ? main : (main = o)); }
	BOOL IsMain(Cvo_Object *obj)	{ return(obj == main); }

	char *ToolTalkProcID()		{ return(tt_procid); }
	int  &ToolTalkRefCnt()		{ return(tt_refcnt); }
	_Cvo_Color *Color(int);

    	GC DefaultGc()		{ return(DefaultGC(dpy, DefaultScreen(dpy))); }

    	GContext DefaultGContext()    { return(XGContextFromGC(DefaultGc())); }

	Cvo_Accelerator *AddAccelerator(Cvo_Object *, KeyCode, CARD, 
			void (*)(Cvo_Object *, XEvent *, void *), void * = 0);
	Cvo_Accelerator *AddAccelerator(Cvo_Object *, KeyCode,
			void (*)(Cvo_Object *, XEvent *, void *), void * = 0);
    	static void DeleteAccel(Cvo_Object *, XEvent *, void *);
    	static XEvent *AccelFilter(Cvo_Object *, XEvent *, void *);
    	static XEvent *AccelCheckFilter(Cvo_Object *, XEvent *, void *);

    	CARD GetModMask(KeySym k1, KeySym k2 = NoSymbol);
    	CARD GetModMask(KeyCode);
    	void FillModMask();
};

class Cvo_Base {
public:
	fd_set		selectMask;
	char		*InstanceName;
	char		*ProgramName;
	char		*ClassName;
	char		*ResourceName;
	char		*DisplayName;
	char		*Locale;
	XrmQuark	QInstanceName;
	XrmQuark	QProgramName;
	XrmQuark	QClassName;
	XrmQuark	QResourceName;
	XrmQuark	QDisplayName;
	XrmQuark	QLocale;
	char		**argv;
	int		argc;
	XrmDatabase	rdb;
	XrmDatabase	ddb;		//

	Cvo_Base();
	Cvo_DisplayList *AddDisplay(Display *dpy);
	void RemoveDisplay(Display *dpy);
	Display *FindDisplay(int fd);
	Cvo_DisplayList *FindDisplayList(Display *);
	//
	// GetOption
	char *GetOption(char *_name, char *_class);
	char *GetResource(char *_name, char *_class);
	char *GetLocaleOption(char *_name, char *_class);
};

extern void Cvo_Exit(Cvo_Object *, XEvent *, void *);
extern int  Cvo_FileFilter(char *patter, char *string);
extern void Cvo_FlushDisplays();
extern void Cvo_InitializeLocale(char * = 0);
extern BOOL Cvo_OpenDefaultDisplay(void);
extern void Cvo_Parse(int *argc, char ***argv);
extern void Cvo_ScanDisplays();
extern void Cvo_ScanInputs(BOOL = False);
extern void Cvo_SetUsageArguments(char *, int = 0, int = -1);
extern void Cvo_usage();
extern BOOL Cvo_ParseAccelerator(Cvo_Object *, char *, KeyCode &, CARD &);
extern BOOL Cvo_ParseAccelerator(Cvo_Object *, wchar_t *, KeyCode &, CARD &);

extern Cvo_Base _Cvo_Base;
extern BOOL _cvo_debug_mode;
extern BOOL _cvo_debug_print_events;

extern Cvo_Atom CvoA_PRIMARY;
extern Cvo_Atom CvoA_STRING;
extern Cvo_Atom CvoA_SELECTION;

#endif
