//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: convert.h++,v 1.4 1994/09/07 20:42:18 prb Exp $
//
/*****************************************************************************/
/*  convert.h++ - 							     */
/*  Date of origin: September 93 					     */
/*                                                                           */
/*  Synopsis:                                                                */
/*                                                                           */
/*  Return Values:                                                           */
/*                                                                           */
/*  Bugs:                                                                    */
/*                                                                           */
/*  Can Be Found in:                                                         */
/*                                                                           */
/*  Environmental needs:                                                     */
/*                                                                           */
/*  History:                                                                 */
/*     Author       Date    Comments                                         */
/*     ------       ----    --------                                         */
/*     Paul Algren   9-93   Initial implementation 			     */
/*                                                                           */
/*  Portions of this software may still be in development.  The existence of */
/*  the software still in development is not a commitment of actual release  */
/*  or support by Cray Research, Inc.  If it is released, the final form of  */
/*  the product and the time of official release is at the discretion of     */
/*  Cray Research, Inc.                                                      */
/*                                                                           */
/*****************************************************************************/
#ifndef __CONVERT_H_DEFINED__
#  define __CONVERT_H_DEFINED__ 1

static inline long
Cvo_read32(unsigned char *b)
{
    return((b[0] << 24L) |
	   (b[1] << 16L) |
	   (b[2] <<  8L) |
	   (b[3]       ));
}

static inline char*
Cvo_store32(long lng, char* bytes)
{
    bytes[0] = (char)((lng >> 24) & 0xff);
    bytes[1] = (char)((lng >> 16) & 0xff);
    bytes[2] = (char)((lng >>  8) & 0xff);
    bytes[3] = (char)((lng >>  0) & 0xff);
    return(bytes);
}

static inline char*
Cvo_store16(short shrt, char* bytes)
{
    bytes[0] = (char)((shrt >> 8) & 0xff);
    bytes[1] = (char)((shrt >> 0) & 0xff);
    return(bytes);
}

static inline long
Cvo_read32(signed char *b)
{
    return(Cvo_read32((unsigned char *)b));
}

static inline short
Cvo_read16(unsigned char *b)
{
    return((b[0] <<  8L) |
	   (b[1]       ));
}

static inline short
Cvo_read16(signed char *b)
{
    return(Cvo_read16((unsigned char *)b));
}

#if defined(__BROKEN_CHAR__)
//
// AIX is buggy and thinks that char is neither unsigned nor signed.
// Go figure...
//
static inline short
Cvo_read16(char *b)
{
    return(Cvo_read16((unsigned char *)b));
}

static inline long
Cvo_read32(char *b)
{
    return(Cvo_read32((unsigned char *)b));
}
#endif

#endif /* __CONVERT_H_DEFINED__ */
