//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Window.h++,v 1.8 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Window_)
#define	_Cvo_Window_

#if	!defined(_Cvo_LayoutWindow_)
#include <Cvo/LayoutWindow.h++>
#endif
#if	!defined(_Cvo_Color_)
#include <Cvo/Color.h++>
#endif
#if	!defined(_Cvo_TextAttribute_)
#include <Cvo/TextAttribute.h++>
#endif

class Cvo_Image;

class Cvo_Window : public Cvo_LayoutWindow {
    friend Cvo_Object;
    friend Cvo_LayoutWindow;
    friend Cvo_TextAttribute;
protected:
    Cvo_Color		foreground;	// foreground color for window
    Cvo_Color		background;	// background color for window
    Cvo_Color		border;		// border color of window

    Cvo_TextAttribute  *textAttributes;	// A rooted list of text attributes

    Window		shadow;		// X window ID of shadow (if any)
    GC			gc;		// default GC

    short		chamfer;	// # of pixels in chamfered edge
    short		moat;		// # of pixels in the moat
    short		moatChamfer;	// # of pixels in the moats chamfer
    short		moatEdge;	// # of pixels outside the moat

    Cvo_Image		*iconPixmap;	// Pixmap to use for the icon
    Cvo_Image		*iconMask;	// PixmapMask to use for the icon
public:
    //
    // Constructors/Destructors
    //
public:
    CONSTRUCDECL(Cvo_Window)
    ~Cvo_Window();
    friend XEvent * _Cvo_event(XEvent *event);
    //
    // Virtual Functions
    //
protected:
    //
    // The three exposure routines are called in the following order:
    //
    //	PreExposure()
    //	Exposure()	// Maybe more than once
    //	-- UsersHandler --
    //	PostExposure()
    //
    // Derived classes should be sure to always be something like:
    // MyClass::Exposure(XExposeEvent *e)
    // {
    //	MyParentClass::Exposure(e);
    //	...
    // }
    //
    void PreExposure(XExposeEvent *);
    virtual void Exposure(XExposeEvent * = 0);
    void PostExposure(XExposeEvent *);

    void HandleResizeEvent(XEvent *, void *);
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Window)

    void HandleFocusIn(XEvent *, void *);
    void HandleFocusOut(XEvent *, void *);
public:
    void InitializeFocus();
    void Outline();
    void NeedInputContext();
    void LoadFont();			// This should not really be all that
	                            // public
public:
    void _Create();			// Call the actual X creation functions
    virtual void Erase();		// Erase the contents of the window

    //
    // Member Functions
    //
private:
    void _Init();
    void _sdraw(const Cvo_Color &, int r, XSegment *s, int t,
		int sx = 0, int sy = 0, int w = 0, int h = 0);
    void _edraw(const Cvo_Color &, int r, XSegment *s, int t,
		int sx = 0, int sy = 0, int w = 0, int h = 0);
public:
    void _drawChamfer();
    void _clearChamfer();

    void DrawRaisedChamfer(int, int, int, int, int, const Cvo_Color &);
    void DrawLoweredChamfer(int, int, int, int, int, const Cvo_Color &);
    void DrawEtchedChamfer(int, int, int, int, int, const Cvo_Color &);

    void DrawRaisedChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0)
	{ DrawRaisedChamfer(r, x, y, w, h, background); }
    void DrawLoweredChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0)
	{ DrawLoweredChamfer(r, x, y, w, h, background); }
    void DrawEtchedChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0)
	{ DrawEtchedChamfer(r, x, y, w, h, background); }

    void ClearChamfer(int r, int x = 0, int y = 0, int w = 0, int h = 0);
    void Redraw();			// Redraw the contents of the window

    Cvo_Color &Foreground() 		// foreground color for window
	{ return(foreground); }
    Cvo_Color &Background() 		// background color for window
	{ return(background); }
    Cvo_Color &CurrentBackground() 		// background color for window
	{ return((background.Full() && !DontSink() && Sunken())
				? background->Select()
				: background); }
    Cvo_Color &CurrentForeground() 	// background color for window
	{ return((foreground.Empty() || Sensitive())
				? foreground
				: foreground->Grayed()); }
    Cvo_Color &Border()			// border color of window
	{ return(border); }
    void SetWindowForeground(const Cvo_Color &c)	// only useful before Create()
	{ foreground = c; }
    void SetWindowBackground(const Cvo_Color &c)
	{ background = c; }

    Cvo_TextAttribute *TextAttribute()	// The basic text attribute
	{ return(textAttributes); }
    void SetGC(const Cvo_Color &bg, const Cvo_Color &fg)
	{ TextAttribute()->ModifyGC(bg, fg); }
    Cvo_TextAttribute *NewTextAttribute()
	{ return(TextAttribute()->Copy(&textAttributes)); }
    Cvo_TextAttribute *NewTextAttribute(XrmQuark);
    Cvo_TextAttribute *NewTextAttribute(char *);

    Window Shadow()			// X window ID of shadow (if any)
	{ return(shadow); }
    GC Gc()				// default GC
	{ return(gc); }
    GC SaveGC();			// Save a copy of the GC
    void RestoreGC(GC);			// Restore from saved copy (and free)

    short Chamfer()			// # of pixels in chamfered edge
	{ return(chamfer); }

    void SetSensitive()
	{ unsensitive = 0; Redraw(); }
    void SetUnsensitive()
	{ unsensitive = 1; Redraw(); }

    void Flatten()			// Flatten the window
	{ flattened = 1; }
    void Unflatten()			// Unflatten the window
	{ flattened = 0; }

    void HideMoat(BOOL v = True)	{ hidemoat = v; }

    void MakeFrame();			// Turn this window into a frame

    void NormalBackground();		// Set background to be normal
    void SelectBackground();		// Set background to be selected

    void SetIconPixmap(Cvo_Image *);
    void SetIconMask(Cvo_Image *);

    //
    // DrawString(x, y, string, [length])
    //	Draw only the text
    // ImageString(x, y, string, [length])
    //	Draw text and background
    //
    //	x, y:	Origin of where to draw the string
    //	string:	What to draw
    //	length: Optional length of string
    //
    void DrawString(int x, int y, char *str, int len = -1)
	{ TextAttribute()->Draw(x, y, str, len); }
    void ImageString(int x, int y, char *str, int len = -1)
	{ TextAttribute()->Image(x, y, str, len); }
    void DrawString(int x, int y, wchar_t *str, int len)
	{ TextAttribute()->Draw(x, y, str, len); }
    void ImageString(int x, int y, wchar_t *str, int len)
	{ TextAttribute()->Image(x, y, str, len); }

    void DrawStrings(int mode, int x, int y, int w, int h,
		     char *str, int len = -1)
	{ TextAttribute()->DrawStrings(mode, x, y, w, h, str, len); }
    void DrawStrings(int mode, int x, int y, int w, int h,
		     wchar_t *str, int len = -1)
	{ TextAttribute()->DrawStrings(mode, x, y, w, h, str, len); }

    int StringsExtents(char *s, int n, XRectangle &log);
    int StringsExtents(wchar_t *s, int n, XRectangle &log);

    //
    // StringWidth(string, [length])
    //	Return number of pixels wide the string will be
    // StringExtents(string, [lenght], ink, [log])
    //	Return size of the string in ink and log
    //
    //	string:	What to measure
    //	length: Optional length of string
    //	ink:	The box that will contain everything that is drawn
    //	log:	The box which you should not write within
    //
    int StringWidth(char *s, int n = -1);
    int StringWidth(wchar_t *s, int n = -1);
    int StringHeight(char *s, int n = -1);
    int StringHeight(wchar_t *s, int n = -1);
    void StringExtents(char *s, int n, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, n, ink, log); }
    void StringExtents(char *s, int n, XRectangle &ink)
	{ TextAttribute()->Extents(s, n, ink); }
    void StringExtents(char *s, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, ink, log); }
    void StringExtents(char *s, XRectangle &ink)
	{ TextAttribute()->Extents(s, ink); }
    void StringExtents(wchar_t *s, int n, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, n, ink, log); }
    void StringExtents(wchar_t *s, int n, XRectangle &ink)
	{ TextAttribute()->Extents(s, n, ink); }
    void StringExtents(wchar_t *s, XRectangle &ink, XRectangle &log)
	{ TextAttribute()->Extents(s, ink, log); }
    void StringExtents(wchar_t *s, XRectangle &ink)
	{ TextAttribute()->Extents(s, ink); }

    void DrawArrow(int dir, int x, int y, int w, int h = -1);
    void DrawUpArrow(int x, int y, int w, int h = -1);
    void DrawDownArrow(int x, int y, int w, int h = -1);
    void DrawLeftArrow(int x, int y, int w, int h = -1);
    void DrawRightArrow(int x, int y, int w, int h = -1);

    void MainLoop();

    //
    // Below are helper functions to standard X Lib calls.  They will
    // do coordinate translation for you.
    //
    virtual void DrawLine(int x1, int y1, int x2, int y2)
	{ ToXCoord(&x1,&y1); ToXCoord(&x2, &y2);
	      XDrawLine(Dpy(), window, gc, x1, y1, x2, y2); }
    virtual void DrawPoint(int x, int y)
	{ ToXCoord(&x,&y);
	  XDrawPoint(Dpy(), window, gc, x, y); }
    virtual void DrawArc(int x, int y, int w, int h, int ang1, int ang2)
	{ ToXCoord(&x,&y);
	  XDrawArc(Dpy(), window, gc, x, y, w, h, ang1, ang2); }
    virtual void DrawRectangle(int x, int y, int w, int h)
	{ ToXCoord(&x,&y);
	  XDrawRectangle(Dpy(), window, gc, x, y, w, h); }
    virtual void DrawRectangle(const XRectangle &r)
	{ DrawRectangle(r.x, r.y, r.width, r.height); }
    virtual void FillArc(int x, int y, int w, int h, int ang1, int ang2)
	{ ToXCoord(&x,&y);
	  XFillArc(Dpy(), window, gc, x, y, w, h, ang1, ang2); }
    virtual void FillRectangle(int x, int y, int w, int h)
	{ ToXCoord(&x,&y);
	  XFillRectangle(Dpy(), window, gc, x, y, w, h); }
    virtual void FillRectangle(const XRectangle &r)
	{ FillRectangle(r.x, r.y, r.width, r.height); }
    virtual void ClearArea(int x, int y, int w, int h, Bool exp = False)
	{ ToXCoord(&x,&y);
	  XClearArea(Dpy(), window, x, y, w, h, exp); }
    virtual void ClearArea(const XRectangle &r, Bool exp = False)
	{ ClearArea(r.x, r.y, r.width, r.height, exp); }
    virtual void ClearWindow()
	{ int x = 0; int y = 0; ToXCoord(&x, &y);
	  XClearArea(Dpy(), window, x, y, width, height, False); }
    virtual void CopyArea(int x, int y, int w, int h, int dx, int dy)
	{ ToXCoord(&x,&y); ToXCoord(&dx, &dy);
          incopy = True;
	  XCopyArea(Dpy(), window, window, gc, x, y, w, h, dx, dy); }
    virtual void PutImage(XImage *im, int x, int y, int dx, int dy, int w, int h)
	{ ToXCoord(&dx, &dy);
	  XPutImage(Dpy(), window, gc, im, x, y, dx, dy, w, h); }
    virtual void PutImage(XImage *im, int dx, int dy, int w, int h)
	{ ToXCoord(&dx, &dy);
	  XPutImage(Dpy(), window, gc, im, 0, 0, dx, dy, w, h); }

    void MoveResizeWindow(int x, int y, int w, int h, int tag = 0);
    void MoveWindow(int x, int y, int tag = 0);
    void MoveWindow(int xc, int yc, int x, int y, int flags = 0, int tag = 0);
    void ResizeWindow(int w, int h, int tag = 0);
    void RaiseWindow();
    void LowerWindow();

    void SetWindowBorder(const Cvo_Color &c)
        { if (c->UsePixmap())
            XSetWindowBorderPixmap(Dpy(), window, c->GetPixmap());
          else
            XSetWindowBorder(Dpy(), window, c->Pixel()); }

    //
    // The following helper functions are used to adjust values in the
    // default GC
    //
    void SetArcMode(int arc_mode)
	{ XSetArcMode(Dpy(), gc, arc_mode); }
    void SetBackground(const Cvo_Color &c)
	{ XGCValues v;
	  v.background = c->Pixel();
	  XChangeGC(Dpy(), gc, GCBackground, &v); }
    void SetBackground(CARD32 p)
	{ XGCValues v;
	  v.background = p;
	  XChangeGC(Dpy(), gc, GCBackground, &v); }
    void SetClipMask(Pixmap mask)
	{ XSetClipMask(Dpy(), gc, mask); }
    void SetClipOrigin(int x, int y)
	{ ToXCoord(&x, &y);
	  XSetClipOrigin(Dpy(), gc, x, y); }
    void SetClipRectangles(int x, int y, const XRectangle rect[], int n, int o)
	{ ToXCoord(&x, &y);
	  XSetClipRectangles(Dpy(), gc, x, y, (XRectangle *)rect, n, o); }
    void SetDashes(int off, char list[], int n)
	{ XSetDashes(Dpy(), gc, off, list, n); }
    void SetFillRule(int rule)
	{ XSetFillRule(Dpy(), gc, rule); }
    void SetFillStyle(int style)
	{ XSetFillStyle(Dpy(), gc, style); }
    void SetForeground(const Cvo_Color &c)
	{ XGCValues v;
	  CARD32 mask = GCForeground|GCFillStyle;
	  v.foreground = c->Pixel();
	  if (c->UsePixmap()) {
	    v.stipple = c->GetPixmap(1);
	    mask |= GCStipple;
	    v.fill_style = FillOpaqueStippled;
	  } else
	    v.fill_style = FillSolid;
	  XChangeGC(Dpy(), gc, mask, &v); }
    void SetForegroundOnly(const Cvo_Color &c)
	{ XGCValues v;
	  v.foreground = c->Pixel();
	  XChangeGC(Dpy(), gc, GCForeground, &v); }
    void SetForeground(CARD32 p)
	{ XGCValues v;
	  v.foreground = p;
	  v.fill_style = FillSolid;
	  XChangeGC(Dpy(), gc, GCForeground | GCFillStyle, &v); }
    void SetFunction(int func)
	{ XSetFunction(Dpy(), gc, func); }
    void SetGraphicsExposures(Bool exp)
	{ XSetGraphicsExposures(Dpy(), gc, exp); }
    void SetLineAttributes(unsigned int w, int line, int cap, int join)
	{ XSetLineAttributes(Dpy(), gc, w, line, cap, join); }
    void SetPlaneMask(unsigned long mask)
	{ XSetPlaneMask(Dpy(), gc, mask); }
    void SetRegion(Region r)
	{ XSetRegion(Dpy(), gc, r); }
    void SetStipple(Pixmap stipple)
	{ XSetStipple(Dpy(), gc, stipple); }
    void SetSubwindowMode(int mode)
	{ XSetSubwindowMode(Dpy(), gc, mode); }
    void SetTile(Pixmap tile)
	{ XSetTile(Dpy(), gc, tile); }
    void SetTSOrigin(int x, int y)
	{ ToXCoord(&x, &y);
	  XSetTSOrigin(Dpy(), gc, x, y); }
};

inline void
Cvo_MainLoop(Cvo_Window *obj)
{
    obj->MainLoop();
}
#endif
