//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Tree.h++,v 1.5 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Tree_)
#define	_Cvo_Tree_

#include <Cvo/Frame.h++>

enum Cvo_TreeDirect_enum { Bottom_to_Top, Top_to_Bottom };

class Cvo_TreeNode;
class Cvo_TreeViewPortPanner;

struct ColumnPtr {
    Cvo_TreeNode	*_topNode;
    ColumnPtr		*Next;
    ColumnPtr		*Prev;
    int			width;
    int			offset;
};

class Cvo_Tree : public Cvo_Window {
    friend Cvo_TreeNode;

    CARD16		hspace;
    CARD16		vspace;
    CARD16		gravity;
    Cvo_Color		lineColor;
    BOOL		mapstate : 1;
    BOOL		dirty : 1;
    BOOL		deleting : 1;
    XSegment            *lines;
    int                 maxlines;
    int                 nlines;
    ColumnPtr  		*columns;
    Cvo_TreeDirect_enum layoutDirection;
    Cvo_Cursor		save_cursor;
    int			sibling_sep;
    int			tree_sep;
    int			child_sep;

    void _Init();

    void SetColumns(ColumnPtr *c)	{ columns = c; }
    ColumnPtr *Columns()		{ return (columns); }
    int Sibling_Sep()			{ return(sibling_sep); }
    int Tree_Sep()			{ return(tree_sep); }
    int Child_Sep()			{ return(child_sep); }
    void ComputeLayout(int);
    void ResetAll();
protected:
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Tree)
public:
    CONSTRUCDECL(Cvo_Tree)
    CARD16 HSpace()			{ return(hspace); }
    CARD16 VSpace()			{ return(vspace); }
    CARD16 Gravity()			{ return(gravity); }
    void ExposureHandler(XEvent * = 0, void * = 0);
    void ChildHandler(XEvent * = 0, void * = 0);
    BOOL MapState()			{ return(mapstate); }
    BOOL SetMapState(BOOL = True);
    void ReleaseMapState(BOOL, Cvo_TreeDirect_enum = Bottom_to_Top, BOOL = True);
    void SetGravity(CARD16);
    Cvo_Color LineColor()		{ return(lineColor); }
    void _AddLine(int, int, int, int);
    void MakeDirty()                    { dirty = True; }
    void SetSibling_Sep(int sep)	{ if (sep > 0) sibling_sep = sep; }
    void SetTree_Sep(int sep)		{ if (sep > 0) tree_sep = sep; }
    void SetChild_Sep(int sep)		{ if (sep > 0) child_sep = sep; }
    void FillPixmap(Cvo_TreeViewPortPanner *, int, int);
    void ColWidthAdj(ColumnPtr *);

    void StandardLayoutChildren(int force, int olay);
    int StandardLayoutFunction(int force, int, int, int);
    int StandardComputeLayoutSize(int force);

    friend void _CvoTreeMapHandler(Cvo_Object *, XEvent *, void *);
    friend void _CvoTreeUnmapHandler(Cvo_Object *, XEvent *, void *);
};

class Cvo_TreeNode {
    friend Cvo_Tree;
    Cvo_Tree            *base;
    Cvo_Window          *object;
    Cvo_Registration    *reg;
    Cvo_Registration    *childreg;
    Cvo_TreeNode        *parent;
    Cvo_TreeNode        *sibling;
    Cvo_TreeNode        *elder;
    Cvo_TreeNode        *children;
    Cvo_TreeNode        *_up;
    Cvo_TreeNode        *_dn;

    int                 x;
    int	                y;
    int			width;
    int			height;
    BOOL		map_with_par:1;
    BOOL		mapped:1;

    Cvo_CharacterBuffer	label;
    INT16		lwidth;
    INT16		lheight;
    INT16		vpad;
    INT16		hpad;
    INT16		chamfer;
    INT16		bw;

    int			pad;
    ColumnPtr		*col;
    void 		*client_data;
    void ConvertTree();
    void ConvertCol(ColumnPtr *);
    void ResetPad();
    void IncPad(int);
    void Layout(int);
    void Layout_Pixmap(Cvo_TreeViewPortPanner *, int, int, int=-1, int=-1);
    void DrawLines();
    void DrawLine(int, int);
    void SetColWidth(int, int);

public:
    Cvo_TreeNode(Cvo_Window *, Cvo_Tree *);
    Cvo_TreeNode(Cvo_Window *, Cvo_TreeNode *);
    Cvo_TreeNode(char *, Cvo_TreeNode *);

    ~Cvo_TreeNode();

    Cvo_Tree *Tree()		{ return(base); }
    Cvo_Window *Object()	{ return(object); }

    Cvo_TreeNode *Parent()   	{ return(parent); }
    Cvo_TreeNode *Sibling()  	{ return(sibling); }
    Cvo_TreeNode *Elder()    	{ return(elder); }
    Cvo_TreeNode *Children() 	{ return(children); }

    BOOL MapWithParent()        { return(map_with_par); }
    BOOL SetMapWithParent(BOOL = True);
    BOOL Mapped()		{ return(object ? object->Mapped() : mapped); }
    void Map();
    void Unmap()		{ if (object) object->Unmap();
				  else mapped = False; }

    int FullWidth()	{ return(object ? object->FullWidth()
					: (lwidth + (hpad + bw) * 2)); }
    int FullHeight()	{ return(object ? object->FullHeight()
					: (lheight + (vpad + bw) * 2)); }

    int Width()		{ return(object ? object->Width() : lwidth); }
    int Height()	{ return(object ? object->Height() : lheight); }
    int DesWidth()	{ return(object ? object->Layout()->desired.width
					: (lwidth + (hpad + bw) * 2)); }
    int DesHeight()	{ return(object ? object->Layout()->desired.height
					: (lheight + (vpad + bw) * 2)); }
    int MinWidth()	{ return(object ? object->Layout()->minimum.width
					: (lwidth + (hpad + bw) * 2)); }
    int MinHeight()	{ return(object ? object->Layout()->minimum.height
					: (lheight + (vpad + bw) * 2)); }
    int VerticalPad()	{ return(object ? object->VerticalPad() : vpad); }
    int HorizontalPad()	{ return(object ? object->HorizontalPad() : hpad); }
    int BorderWidth()	{ return(object ? object->BorderWidth() : bw); }

    void  *Client_data() { return (client_data); }
    void   SetClient_data(void *data) { client_data = data; }

    void Draw(XExposeEvent * = 0);

    friend void _CvoTreeDeleteHandler(Cvo_Object *, XEvent *, void *);
    friend void _CvoTreeMapHandler(Cvo_Object *, XEvent *, void *);
    friend void _CvoTreeUnmapHandler(Cvo_Object *, XEvent *, void *);
    friend void _CvoTreeChildHandler(Cvo_Object *, XEvent *, void *);
};

#define CvoTreeRedrawEventType (Cvo_TreeEventType + InternalEvent0)

#endif
