//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: TimeVal.h++,v 1.4 1994/08/10 18:11:11 prb Exp $
//
//
// This code was initially contributed by Jim Nowicki 11-92
//
#if     !defined(_Cvo_TimeVal_)
#define _Cvo_TimeVal_

#include <Cvo/_Machine.h++>

#if	defined(__NEED_GETTIMEOFDAY_DEF__)
#if	defined(__SYSV_GETTIMEOFDAY__)
extern "C" int gettimeofday(struct timeval *tp);
#else
extern "C" int gettimeofday(struct timeval *, struct timezone *);
#endif
#endif

class EvTimeVal : public timeval {
private:

public:
    EvTimeVal()   { }
    EvTimeVal(long ms)
	{ tv_sec = ms / 1000L; tv_usec = (ms % 1000L) * 1000L; }
    EvTimeVal(long sec, long usec)
	{ tv_sec = sec + (usec / 1000000L); tv_usec = usec % 1000000L; };

    void SetCurrentTime(long sec = 0, long usec = 0);
    void FromNow(long sec, long usec = 0);
    void RoundUp();
    void RoundUpTo(long sec);
    void RoundDownTo(long sec);

    EvTimeVal operator +(const EvTimeVal &);
    EvTimeVal operator -(const EvTimeVal &);
    int operator ==(const EvTimeVal &);
    int operator !=(const EvTimeVal &);
    int operator >(const EvTimeVal &);
    int operator >=(const EvTimeVal &);
    int operator <(const EvTimeVal &);
    int operator <=(const EvTimeVal &);
    EvTimeVal &operator +=(const EvTimeVal &);
    EvTimeVal &operator -=(const EvTimeVal &);
};

//
// Define timeval operations
//

inline void
EvTimeVal::SetCurrentTime(long sec, long usec)
{
#if defined(__SYSV_GETTIMEOFDAY__)
    gettimeofday(this);
#else
    gettimeofday(this, 0);
#endif
    //
    // Fix up the returned value        XXX - This should not be needed
    //                                  XXX - Fixes bug from gettimeofday()
    tv_usec += usec;

    while (tv_usec < 0) {
	if (tv_sec > 0) {
	    tv_usec += 1000000L;
	    tv_sec--;
	} else {
	    tv_usec = 0;
            break;
        }
    }

    if (tv_usec > 1000000L) {
	tv_sec += sec + (tv_usec / 1000000L);
	tv_usec %= 1000000L;
    }
}

inline void
EvTimeVal::RoundUp()            // Round up to the next second
{
    if (tv_usec != 0) {
	tv_sec++;
	tv_usec = 0;
    }
}

inline void
EvTimeVal::RoundUpTo(long sec)
{
    if (sec > 0) {
	if (tv_usec != 0) {
	    tv_sec++;
	    tv_usec = 0;
	}
	tv_sec += sec - tv_sec % sec;
    }
}

inline void
EvTimeVal::RoundDownTo(long sec)
{
    if (sec > 0) {
	tv_usec = 0;
	tv_sec -= tv_sec % sec;
    }
}


inline EvTimeVal
EvTimeVal::operator+(const EvTimeVal &x)
{
    long sec = tv_sec + x.tv_sec;
    long usec = tv_usec + x.tv_usec;

    if (usec >= 1000000L) {
	usec -= 1000000L;
	sec++;
    }
    return(EvTimeVal(sec, usec));
}

inline EvTimeVal
EvTimeVal::operator-(const EvTimeVal &x)
{
    long sec = tv_sec - x.tv_sec;
    long usec = tv_usec - x.tv_usec;

    if (usec < 0L) {
	usec += 1000000L;
	sec--;
    }
    return(EvTimeVal(sec, usec));
}

inline int
EvTimeVal::operator==(const EvTimeVal &x)
{
    return(tv_sec == x.tv_sec && tv_usec == x.tv_usec);
}

inline int
EvTimeVal::operator!=(const EvTimeVal &x)
{
    return(tv_sec != x.tv_sec || tv_usec != x.tv_usec);
}

inline int
EvTimeVal::operator>(const EvTimeVal &x)
{
    return(tv_sec > x.tv_sec || tv_sec == x.tv_sec && tv_usec > x.tv_usec);
}

inline int
EvTimeVal::operator>=(const EvTimeVal &x)
{
    return(tv_sec > x.tv_sec || tv_sec == x.tv_sec && tv_usec >= x.tv_usec);
}

inline int
EvTimeVal::operator<(const EvTimeVal &x)
{
    return(tv_sec < x.tv_sec || tv_sec == x.tv_sec && tv_usec < x.tv_usec);
}

inline int
EvTimeVal::operator<=(const EvTimeVal &x)
{
    return(tv_sec < x.tv_sec || tv_sec == x.tv_sec && tv_usec <= x.tv_usec);
}

inline EvTimeVal &
EvTimeVal::operator+=(const EvTimeVal &x)
{
    tv_sec  += x.tv_sec;
    tv_usec += x.tv_usec;

    if (tv_usec >= 1000000L) {
	tv_usec -= 1000000L;
	tv_sec++;
    }
    return(*this);
}

inline EvTimeVal &
EvTimeVal::operator-=(const EvTimeVal &x)
{
    tv_sec  -= x.tv_sec;
    tv_usec -= x.tv_usec;

    if (tv_usec < 0L) {
	tv_usec += 1000000L;
	tv_sec--;
    }
    return(*this);
}

inline void
EvTimeVal::FromNow(long sec, long usec)
{
    tv_sec += sec + (usec / 1000000L);
    tv_usec += usec % 1000000L;

    if (tv_usec >= 1000000L) {
	tv_usec -= 1000000L;
	tv_sec++;
    }
}

#endif
