//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Pin.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Pin_)
#define	_Cvo_Pin_

#if	!defined(_Cvo_BasicButton_)
#include <Cvo/BasicButton.h++>
#endif

#define _cvo_pin_width 28
#define _cvo_pin_height 16

class Cvo_Pin : public Cvo_BasicButton {
private:
    BOOL pushed:1;			// True if pin is pushed in
    BOOL oldpushed:1;			// True if pin is pushed in
    void _Init();
protected:
    void Bind();
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Pin)
    void ExposureHandler(XEvent * = 0, void * = 0);
public:
    CONSTRUCDECL(Cvo_Pin)

    BOOL Pressed()			{ return(pushed); }
    void ForceOn()			{ pushed = 1; Exposure(); }
    void ForceOff()			{ pushed = 0; Exposure(); }

    void LocalDown(XEvent *ev, int, char **);
    void LocalUp(XEvent *ev, int, char **);
    void Enter(XEvent *ev, int, char **);
    void Leave(XEvent *ev, int, char **);

    CARD16 CalculateWidth()		{ return(_cvo_pin_width); }
    CARD16 CalculateHeight()		{ return(_cvo_pin_height); }
};
#endif
