//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Page.h++,v 1.5 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Page_)
#define	_Cvo_Page_

#if	!defined(_Cvo_Window_)
#include <Cvo/Window.h++>
#endif

class Cvo_Page {
protected:
    Cvo_Window *win;

    //
    // Technically these functions do not belong here, but since many pages are
    // going to include text, these functions provide common functions for
    // drawing and sizing text.
    //
    void DrawText(Cvo_TextAttribute *, wchar_t *, int, const XRectangle &, int, int);
    void DrawText(Cvo_TextAttribute **, wchar_t *, int, const XRectangle &, int, int);
    CARD WidthText(Cvo_TextAttribute *, wchar_t *, int);
    CARD WidthText(Cvo_TextAttribute **, wchar_t *, int);
    CARD HeightText(Cvo_TextAttribute *, wchar_t *, int);
    CARD HeightText(Cvo_TextAttribute **, wchar_t *, int);
public:
    Cvo_Page()				{ win = 0; }
    virtual ~Cvo_Page()			{ ; }	// To get g++ to shut up.
    virtual int NumberLines() = 0;
    virtual void *GetLine(CARD) = 0;
    virtual void *GetLine(CARD, Cvo_CharacterBuffer *) = 0;
    virtual void Draw(CARD, const XRectangle &clip, int x = 0, int y = 0) = 0;
    virtual CARD Width(CARD) = 0;
    virtual CARD Height(CARD) = 0;
    virtual CARD TotalWidth();
    virtual CARD TotalHeight();
    virtual BOOL HandlePress(CARD, int, int, XEvent *)	{ return(False); }
    virtual void SetWindow(Cvo_Window *w)			{ win = w; }

    virtual Cvo_TextAttribute *GetAttribute(CARD)	{ return(0); }
    virtual Cvo_TextAttribute **GetAttributes(CARD)	{ return(0); }

    virtual BOOL Modified(CARD)				{ return(True); }
};

//
// A PageChanged Event should be sent each time the contents
// of the page is changed.  In the future maybe there should
// be some information added as to how the page changed, i.e.
// a new line was added, a line was deleted, everything
// changed, etc.
//
#define	CvoPageChangedEvent	(Cvo_PageEventType + InternalEvent0)


struct Cvo_PageChangedEvent : Cvo_AnyEvent {
    BOOL	newlines:1;
    BOOL	changedlines:1;
    BOOL	removedlines:1;
};
#endif
