//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Errors.h++,v 1.2 1994/08/10 18:11:11 prb Exp $
//
#if	!defined(_Cvo_Errors_)
#define	_Cvo_Errors_

//
// Definitions of error levels
//
#define	CvoE_FATAL	0
#define	CvoE_WARN	1
#define	CvoE_ABORT	2

//
// Definitions of errors message numbers
//
#define	CvoE_CANTOPEN	1	// Cannot open display ``%s''\n
#define	CvoE_NULLWIN	2	// Null window argument passed to ``%s(%s)''\n
#define	CvoE_NULLFONT	3	// Null fontname passed to ``%s''\n
#define	CvoE_BADFONT	4	// Unable to create fontset ``%s(%s)''\n
#define	CvoE_CANTOPENW	5	// Cannot create window ``%s(%s)''\n
#define	CvoE_MISSFONT	6	// Unable to open font %s\n
#define	CvoE_BADEVENT	7	// %d is a invalid event number\n
#define	CvoE_NOMEM	8	// Out of memory in routine ``%s''\n
#define	CvoE_LOCALE	9	// Cannot set locale to %s\n
#define	CvoE_UNSLOCALE	10	// Locale %s not supported by X\n
#define	CvoE_LOCALEMOD	11	// Cannot set locale modifiers for %s\n
#define	CvoE_SELECT	12	// Failure on select system call\n
#define	CvoE_NOFONT	13	// Unable to open any fonts for %s\n
#define	CvoE_BADPARENT	14	// InputOutput Window %s's parent is InputOnly\n
#define	CvoE_NULLDPY	15	// Null display argument passed to ``%s(%s)''\n
#define	CvoE_UNSUPIM	16	// Cannot support an imput method for %s\n
#define	CvoE_UNSUPIMS	17	// Cannot support an imput method style for %s\n
#define	CvoE_NOIC	18	// Cannot create an imput context for %s\n
#define	CvoE_STATICLASS	19	// Cvo Object appears to be an automatic\n
#define	CvoE_COPYCLASS	20	// Copy constructor called on Cvo Object\n
#define	CvoE_NONUMERIC	21	// Option %s passed none numeric value %s\n
#define	CvoE_BADATOM	22	// Atom %d is out of range\n
#define CvoE_UNITATOM	23	// Atom is uninitialized\n
#define CvoE_BADCLIB	24	// Global constructors were probably not called.\n
#define CvoE_BADCLIB2	25	// The application was probably linked improperly\n

//
// Tree Errors
//
#define	CvoE_MISSNODE	0x0100	// Current node is not displayed!\n

//
// Translation Errors
//
#define	CvoE_BAD_MOD	0x0110	// Unknown modifer %s in translation %s\n
#define	CvoE_BAD_CHAR	0x0111	// Unknown character %c in translation %s\n
#define	CvoE_MISSOPEN	0x0112	// Missing '<' in translation %s\n
#define	CvoE_NOACTION	0x0113	// Missing actions in translation %s\n
#define	CvoE_BADDIRECT	0x0114	// Bad directive %s in translation table\n
#define	CvoE_OVERWITE	0x0115	// Internal: overwriting translation table\n
#define	CvoE_MISSTRAN	0x0116	// Could not bind the translation ``%s''\n
#define	CvoE_BAD_EVENT	0x0117	// Unknown event type %s in translation %s\n

//
// Cut Buffer Errors
//
#define	CvoE_CUTOPEN	0x0130	// Cannot open 

//
// Picture Errors
//
#define	CvoE_CANTLOAD	0x0140	// Cannot load file %s as a picture\n

//
// ToolTalk Errors
//
#define	CvoE_TTDOWN	0x0150	// ToolTalk server down\n
#define	CvoE_TTNINSTALL	0x0151	// ToolTalk service type %s not installed\n
#define	CvoE_TTALREADY	0x0152	// "%s cannot install ToolTalk, it is already installed on %s\n

//
// Menu Errors
#define	CvoE_BADMENU	0x0160	// Bad menu in menu item creation\n
#define	CvoE_BADPREV	0x0161	// Bad menu item passed to menu item creation\n

void Cvo_Failure(int level, int error, char *message, ...);
void Cvo_Failure(int level, Display *dpy, XErrorEvent *err);
void Cvo_Failure(int level, int error, Display *dpy, XErrorEvent *err,
		 char *message, ...);
#endif
