#include <sys/types.h>

/* structures */
typedef struct _RangeTblEntry{
	unsigned long	begin;
	unsigned long	end;
} RangeTblEntry;

typedef struct _RangeTbl{
	unsigned long	length;
	RangeTblEntry	*entry;
	unsigned long	alloc_len;
	unsigned long	alloc_unit;
} RangeTbl;

/* public functions */
RangeTbl	*RangeTbl_create(int num);
int	RangeTbl_add(RangeTbl *tbl, RangeTblEntry *add_entry);
boolean_t	RangeTbl_in(RangeTbl *tbl, unsigned long code);
void	RangeTbl_destroy(RangeTbl *tbl, int num);
