#include <sys/types.h>
#include <stdio.h>

/* structures */
typedef struct _LookupTableEntry{
	unsigned long	offset;
	int	target_byte;
	void	*cs_entry;
	int	entry_unit;
	void	*entry;
} LookupTableEntry;

typedef struct _LookupTable{
	int	src_size;
	int	dst_size;
	boolean_t	cs_on;
	int	tbl_ptr;
	int	length;
	int	alloc_len;
	int	alloc_unit;
	LookupTableEntry	*tbl_list;
} LookupTable;

/* public functions */
LookupTable	*LookupTable_create(int src_size, int dst_size, boolean_t cs_on);
int	LookupTable_add(LookupTable *lookup, unsigned long src, unsigned long dst, int cs);
int	LookupTable_save(LookupTable *lookup, FILE *fp);
void	LookupTable_destroy(LookupTable *lookup);
