/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Copyright (c) 1999 Sun Microsystems, Inc.
 * Copyright (c) 1999 Nihon Sun Microsystems K.K.
 * All rights reserved.
 */

/*
 * "$Id: csc_norm.c,v 1.4 1999/06/23 09:07:30 kasha Exp $"
 */

#pragma ident	"@(#)csc_norm.c 1.5	00/09/14 SMI"

#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "csconv.h"
#include "csc_conf_info.h"
#include "csc_norm.h"
#include "csc_norm_internal.h"

#include "trace_message.h"


#if !defined(CSC_NORM_FILE)
#define CSC_NORM_FILE		"encoding.norm"
#endif /* !CSC_NORM_FILE */

#if !defined(CSC_NORM_HOME_DIR)
#define CSC_NORM_HOME_DIR	CSC_BASE_DIR_PERSONAL
#endif /* !CSC_NORM_HOME_DIR */
#if !defined(CSC_NORM_SYSTEM_DIR)
#define CSC_NORM_SYSTEM_DIR	CSC_BASE_DIR_SYSTEM
#endif /* !CSC_NORM_SYSTEM_DIR */
#if !defined(CSC_NORM_VENDOR_DIR)
#define CSC_NORM_VENDOR_DIR	CSC_BASE_DIR_DEFAULT
#endif /* !CSC_NORM_VENDOR_DIR */

#define 	CSC_NORM_PLATFORM	(0)
#define 	CSC_NORM_LOCALE		(1)
#define 	CSC_NORM_ENCODING1	(2)
#define 	CSC_NORM_ENCODING2	(3)
#define 	CSC_NORM_LOCALE_N	(4)
#define 	CSC_NORM_ENCODING1_N	(5)
#define 	CSC_NORM_ENCODING2_N	(6)
#define 	CSC_NORM_NUM		(7)


csc_norm_encoding_t *
csc_norm_encoding(
	const char *	platform,
	const char *	locale,
	const char *	encoding1,
	const char *	encoding2)
{
	int			num;
	int			platform_any;
	int			locale_any;
	int			encoding1_any;
	int			encoding2_any;
	csc_conf_file_t *	norm_file;
	csc_conf_str_t		norm_str[CSC_NORM_NUM];
	csc_norm_encoding_t *	norm_encoding;
	csc_norm_encoding_t *	norm_encoding_free;

	TRACE_MESSAGE('n', ("csc_norm_encoding: %s %s %s %s\n",
			    platform, locale, encoding1, encoding2));

#if defined(CSC_PRIVATE_CUSTOMIZE)
	norm_file = csc_conf_open(CSC_NORM_FILE, CSC_CONF_CUSTOMIZE_ENABLED,
				  csc_norm_internal, csc_norm_internal_len);
#else /* !CSC_PRIVATE_CUSTOMIZE */
	norm_file = csc_conf_open(CSC_NORM_FILE, CSC_CONF_CUSTOMIZE_DISABLED,
				  csc_norm_internal, csc_norm_internal_len);
#endif /* !CSC_PRIVATE_CUSTOMIZE */
	if (NULL == norm_file) {
		return NULL;
	}

	norm_encoding = NULL;
	norm_encoding_free = NULL;

	platform_any  = CSC_IS_ANY(platform,  strlen(platform));
	locale_any    = CSC_IS_ANY(locale,    strlen(locale));
	encoding1_any = CSC_IS_ANY(encoding1, strlen(encoding1));
	encoding2_any = CSC_IS_ANY(encoding2, strlen(encoding2));

	while (0 != (num = csc_conf_read(norm_file, norm_str, CSC_NORM_NUM))) {
		if ((CSC_NORM_NUM != num)                                  ||
		    ((!platform_any)                                    &&
		     (!CSC_IS_ANY(norm_str[CSC_NORM_PLATFORM].ptr,
				  norm_str[CSC_NORM_PLATFORM].len))     &&
		     (0 != csc_strcmp(platform,
				      &(norm_str[CSC_NORM_PLATFORM]))))    ||
		    ((!locale_any)                                      &&
		     (!CSC_IS_ANY(norm_str[CSC_NORM_LOCALE].ptr,
				  norm_str[CSC_NORM_LOCALE].len))       &&
		     (0 != csc_strcmp(locale,
				      &(norm_str[CSC_NORM_LOCALE]))))      ||
		    ((!encoding1_any)                                   &&
		     (!CSC_IS_ANY(norm_str[CSC_NORM_ENCODING1].ptr,
				  norm_str[CSC_NORM_ENCODING1].len))    &&
		     (0 != csc_strcmp(encoding1,
				      &(norm_str[CSC_NORM_ENCODING1]))))   ||
		    ((!encoding2_any)                                   &&
		     (!CSC_IS_ANY(norm_str[CSC_NORM_ENCODING2].ptr,
				  norm_str[CSC_NORM_ENCODING2].len))    &&
		     (0 != csc_strcmp(encoding2,
				      &(norm_str[CSC_NORM_ENCODING2]))))) {
			continue;
		}

		norm_encoding = malloc(sizeof (csc_norm_encoding_t));
		if (NULL == norm_encoding) {
			break;
		}

		if (CSC_IS_ANY(norm_str[CSC_NORM_LOCALE_N].ptr,
			       norm_str[CSC_NORM_LOCALE_N].len)) {
			if (locale_any) {
				continue;
			} else {
				norm_encoding->locale = strdup(locale);
				if (NULL == norm_encoding->locale) {
					norm_encoding_free = norm_encoding;
					norm_encoding = NULL;
					break;
				}
			}
		} else {
			norm_encoding->locale =
				malloc(norm_str[CSC_NORM_LOCALE_N].len + 1);
			if (NULL == norm_encoding->locale) {
				norm_encoding_free = norm_encoding;
				norm_encoding = NULL;
				break;
			}
			memmove(norm_encoding->locale,
				norm_str[CSC_NORM_LOCALE_N].ptr,
				norm_str[CSC_NORM_LOCALE_N].len);
			*(norm_encoding->locale +
			  norm_str[CSC_NORM_LOCALE_N].len) = '\0';
		}
		if (CSC_IS_ANY(norm_str[CSC_NORM_ENCODING1_N].ptr,
			       norm_str[CSC_NORM_ENCODING1_N].len)) {
			if (encoding1_any) {
				continue;
			} else {
				norm_encoding->encoding1 = strdup(encoding1);
				if (NULL == norm_encoding->encoding1) {
					norm_encoding_free = norm_encoding;
					norm_encoding = NULL;
					break;
				}
			}
		} else {
			norm_encoding->encoding1 =
				malloc(norm_str[CSC_NORM_ENCODING1_N].len + 1);
			if (NULL == norm_encoding->encoding1) {
				norm_encoding_free = norm_encoding;
				norm_encoding = NULL;
				break;
			}
			memmove(norm_encoding->encoding1,
				norm_str[CSC_NORM_ENCODING1_N].ptr,
				norm_str[CSC_NORM_ENCODING1_N].len);
			*(norm_encoding->encoding1 +
			  norm_str[CSC_NORM_ENCODING1_N].len) = '\0';
		}
		if (CSC_IS_ANY(norm_str[CSC_NORM_ENCODING2_N].ptr,
			       norm_str[CSC_NORM_ENCODING2_N].len)) {
			if (encoding2_any) {
				continue;
			} else {
				norm_encoding->encoding2 = strdup(encoding2);
				if (NULL == norm_encoding->encoding2) {
					norm_encoding_free = norm_encoding;
					norm_encoding = NULL;
					break;
				}
			}
		} else {
			norm_encoding->encoding2 =
				malloc(norm_str[CSC_NORM_ENCODING2_N].len + 1);
			if (NULL == norm_encoding->encoding2) {
				norm_encoding_free = norm_encoding;
				norm_encoding = NULL;
				break;
			}
			memmove(norm_encoding->encoding2,
				norm_str[CSC_NORM_ENCODING2_N].ptr,
				norm_str[CSC_NORM_ENCODING2_N].len);
			*(norm_encoding->encoding2 +
			  norm_str[CSC_NORM_ENCODING2_N].len) = '\0';
		}
		break;
	}

	csc_norm_free(norm_encoding_free);

	csc_conf_close(norm_file);

#if defined(ENABLE_TRACE)
	if (TRACE_P('n')) {
		if (norm_encoding) {
			TRACE_MESSAGE('n', ("csc_norm_free: end: %s %s %s\n",
					    norm_encoding->locale ?
					    norm_encoding->locale : "(nil)",
					    norm_encoding->encoding1 ?
					    norm_encoding->encoding1 : "(nil)",
					    norm_encoding->encoding2 ?
					    norm_encoding->encoding2 : "(nil)"));
		} else {
			TRACE_MESSAGE('n', ("csc_norm_free: end: (nil)\n"));
		}
	}
#endif /* ENABLE_TRACE */

	return norm_encoding;
}

void
csc_norm_free(csc_norm_encoding_t * ne)
{
	if (NULL == ne) {
		return;
	}
	free(ne->locale);
	free(ne->encoding1);
	free(ne->encoding2);
	free(ne);
}
