/*
 * Copyright (c) 1999 Sun Microsystems, Inc.
 * Copyright (c) 1999 Nihon Sun Microsystems K.K.
 * All rights reserved.
 */

/*
 * "$Id: nil.c,v 1.1 1999/04/06 09:30:47 kasha Exp $"
 */

#pragma ident	"@(#)nil.c 1.1	99/04/06 SMI"


#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>

#include "csconv.h"


typedef struct _csc_state {
	char *		locale;
} csc_state_t;


csc_state_t *
nil_open(
	const char *	locale,
	const char *	tocode,
	const char *	fromcode)
{
	csc_state_t *	csc_state;

	if (NULL == (csc_state = malloc(sizeof (*csc_state)))) {
		return NULL;
	}

	csc_state->locale = NULL;

	return csc_state;
}


void
nil_close(csc_state_t * csc_state)
{
	if (NULL != csc_state) {
		free(csc_state);
	}

	return;
}


size_t
nil_conv(
	csc_state_t *	csc_state,
	const char **	inbuf,
	size_t *	inbytesleft,
	char **		outbuf,
	size_t *	outbytesleft)
{
	size_t		len;
	int		too_big;

	if ((NULL == inbuf) || (NULL == *inbuf)) {
		return 0;
	}

	if (*inbytesleft < *outbytesleft) {
		too_big = 0;
		len = *inbytesleft;
	} else {
		too_big = 1;
		len = *outbytesleft;
	}

	memmove(*outbuf, *inbuf, len);

	*inbuf += len;
	*inbytesleft -= len;
	*outbuf += len;
	*outbytesleft -= len;

	if (0 != too_big) {
		errno = E2BIG;
		return (size_t)(-1);
	}
	return 0;
}
