/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
#ifdef  sccs
static char     sccsid[] = "@(#)input_method.h	1.3 00/09/13";
#endif
#endif

#include <mle/cm.h>
#include <mle/env.h>
#include <mle/cmkeys.h>
#ifdef sun
#include <regexpr.h>
#endif
#include <locale.h>
#include "code_table.h"

/* Input Method Properties */
#define AUTO_POPUP       	1<<0    /* popup every time */
#define MATCH_ONLY         	1<<1    /* or display only matched choices */
#define AUTO_COMMIT             1<<2    /* Commit pre-edit on non-pre-edit
                                           keys */
#define CASE_SENSITIVE         	1<<3    /* lowercase != uppercase letters */

#define auto_popup(im_no)       (im[im_no].props & AUTO_POPUP)
#define display_all(im_no)      (!(im[im_no].props & MATCH_ONLY))
#define auto_commit(im_no)      (im[im_no].props & AUTO_COMMIT)
#define case_sensitive(im_no)   (im[im_no].props & CASE_SENSITIVE)

/*
 * input method structure:
 */
struct input_method {
	char		name[16];	/* input method name in keybind.dat */
        int           	function_key;   /* F key to get to this mode */
        int           	ctl_key;        /* ctl key to get to this mode */
        char          	next_choice;    /* key for next choice */
        char          	prev_choice;    /* key for prev choice */
        char          	focus_right;    /* Move the focus forward */
        char          	focus_left;     /* Move the focus backward */
        char          	focus_longer;   /* Lengthen the focus area */
        char          	focus_shorter;  /* Shorten the focus area  */
	char    	disp_sel_key;	/* Display selections */
        char          	commit_key;	/* To commit pre-edit region */
	char    	cmt_fst_sel_key; /* Commit the first selection */
	char    	wild_char;	/* Wild Char */
        u_char         	message[30];    /* message on the mode region */
        char          	ct_file[80];    /* Code table file */
        short         	props;          /* Properties */
        short         	dic_no;         /* Link dictionary # */
        table_index     tab_idx[MAXIDX];
        code_table      *c_tab;         /* Initial = NULL */
        char          	*data;
};

/*
 * dictionary
 */
struct  dictionary {
        char    file[80];       /* dictionary file name */
        int     wc;             /* total word count */
        char    **word;
};

